/*--------------------------------------------------------------------------+
$Id: EnvironmentError.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.error;

/**
 * An error class for signaling problems in the execution environment, e.g. a
 * missing XML parser implementation.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 1CB0F442AF74D835E3DD1D78B1A5FDAB
 */
public class EnvironmentError extends Error {

	/** Create new error. */
	public EnvironmentError(String message) {
		super(message);
	}

	/** Create new error. */
	public EnvironmentError(String message, Throwable cause) {
		super(message, cause);
	}

	/** Create new error. */
	public EnvironmentError(Throwable cause) {
		super(cause);
	}
}