/*
 * $Id: elevator_gui.c,v 1.13 2009-06-03 11:34:06 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "elevator_gui.h"

#ifdef HAVE_GTK
#include "elevator_gui_gtk.h"
#endif

void *
elevator_gui_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_mech_power_switch,
	struct sig_dio48 *port_dio48,
	struct sig_boolean *port_opt_led_a,
	struct sig_boolean *port_opt_led_b,
	struct sig_boolean *port_opt_led_c,
	struct sig_boolean *port_opt_led_d,
	struct sig_boolean *port_opt_led_e,
	struct sig_boolean *port_opt_led_f,
	struct sig_boolean *port_opt_led_g,
	struct sig_boolean *port_opt_led_arrow_down,
	struct sig_boolean *port_opt_led_arrow_up,
	struct sig_boolean *port_opt_led_panel_0,
	struct sig_boolean *port_opt_led_panel_1,
	struct sig_boolean *port_opt_led_panel_2,
	struct sig_boolean *port_opt_led_0_up,
	struct sig_boolean *port_opt_led_1_down,
	struct sig_boolean *port_opt_led_1_up,
	struct sig_boolean *port_opt_led_2_down,
	struct sig_boolean *port_mech_button_panel_0,
	struct sig_boolean *port_mech_button_panel_1,
	struct sig_boolean *port_mech_button_panel_2,
	struct sig_boolean *port_mech_button_0_up,
	struct sig_boolean *port_mech_button_1_down,
	struct sig_boolean *port_mech_button_1_up,
	struct sig_boolean *port_mech_button_2_down,
	struct sig_integer *port_mech_door_0,
	struct sig_integer *port_mech_door_1,
	struct sig_integer *port_mech_door_2,
	struct sig_integer *port_mech_cabin
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return elevator_gui_gtk_create(page, name,
				port_manage,
				port_mech_power_switch,
				port_dio48,
				port_opt_led_a,
				port_opt_led_b,
				port_opt_led_c,
				port_opt_led_d,
				port_opt_led_e,
				port_opt_led_f,
				port_opt_led_g,
				port_opt_led_arrow_down,
				port_opt_led_arrow_up,
				port_opt_led_panel_0,
				port_opt_led_panel_1,
				port_opt_led_panel_2,
				port_opt_led_0_up,
				port_opt_led_1_down,
				port_opt_led_1_up,
				port_opt_led_2_down,
				port_mech_button_panel_0,
				port_mech_button_panel_1,
				port_mech_button_panel_2,
				port_mech_button_0_up,
				port_mech_button_1_down,
				port_mech_button_1_up,
				port_mech_button_2_down,
				port_mech_door_0,
				port_mech_door_1,
				port_mech_door_2,
				port_mech_cabin);
		break;
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
elevator_gui_destroy(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		elevator_gui_gtk_destroy(_cpssp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
