/*
 * Copyright (c) 2007-2009, Sergey Zorin. All rights reserved.
 *
 * This software is distributable under the BSD license. See the terms
 * of the BSD license in the COPYING file provided with this software.
 *
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <string.h>

#include <gtk/gtk.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#include <gio/gio.h>

#include "interface.h"
#include "support.h"
#include "model.h"

gpointer model = 0;

GtkListStore* list_model;

void
apply() {
  GConfClient* gconf_client;
  MODEL* m = (MODEL*)model;
  GSList* diff_ext_mime_types = NULL;
  GtkTreeIter i;
  gboolean go = gtk_tree_model_get_iter_first(GTK_TREE_MODEL(list_model), &i);
  
  while(go) {
    gboolean enabled;
    gchar* mime_type;
    
    gtk_tree_model_get(GTK_TREE_MODEL(list_model), &i, 
      ENABLE_GDIFF_EXT, &enabled, 
      MIME_TYPE, &mime_type, 
      -1);
    
    if(enabled) {
      diff_ext_mime_types = g_slist_append(diff_ext_mime_types, mime_type);
    }
    
    go = gtk_tree_model_iter_next(GTK_TREE_MODEL(list_model), &i);
    
//    g_free(mime_type);
  }
	
  gconf_client = gconf_client_get_default ();
    gconf_client_set_string(gconf_client, "/apps/diff-ext/diff", m->diff_tool->str, NULL);
    gconf_client_set_string(gconf_client, "/apps/diff-ext/diff3", m->diff3_tool->str, NULL);
    gconf_client_set_bool(gconf_client, "/apps/diff-ext/enable-diff3",m->enable_diff3, NULL);
    gconf_client_set_list(gconf_client, "/apps/diff-ext/mime-types", GCONF_VALUE_STRING, diff_ext_mime_types, NULL);
  g_object_unref(G_OBJECT(gconf_client));
  
  g_slist_free(diff_ext_mime_types);
}

gint
compare_string(GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer data) {
  gint result = 0;
  gint sort_column = GPOINTER_TO_INT(data);
  gchar* type1;
  gchar* type2;
  
  gtk_tree_model_get(model, a, sort_column, &type1, -1);
  gtk_tree_model_get(model, b, sort_column, &type2, -1);
  
  if (type1 == NULL || type2 == NULL) {
    if (type1 == NULL) {
      result = -1;
    } else {
      result = 1;
    }
  } else {
    result = g_utf8_collate(type1, type2);
  }
  
  g_free(type1);
  g_free(type2);
  
  return result;
}

gint
compare_enabled(GtkTreeModel* model, GtkTreeIter* x1, GtkTreeIter* x2, gpointer data) {
  gboolean e1;
  gboolean e2;
  gint result;
  
  gtk_tree_model_get(model, x1, ENABLE_GDIFF_EXT, &e1, -1);
  gtk_tree_model_get(model, x2, ENABLE_GDIFF_EXT, &e2, -1);
  
  if(e1 != e2) {
    if(e1) {
      result = 1;
    } else {
      result = -1;
    }
  }
  
  return result;
}

int
main (int argc, char *argv[])
{
  GtkWidget* main;
  GConfClient* gconf_client;
  MODEL m;
  GList* mime_types = g_content_types_get_registered();
  GSList* diff_ext_mime_types = NULL;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, SETUP_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);
  gconf_init(argc, argv, 0);

  add_pixmap_directory (SETUP_DATA_DIR "/" PACKAGE_NAME);

  gtk_window_set_default_icon_name("de");
  
  m.diff_tool = g_string_new("");
  m.diff3_tool = g_string_new("");
  gconf_client = gconf_client_get_default ();
    g_string_assign(m.diff_tool, gconf_client_get_string(gconf_client, "/apps/diff-ext/diff", NULL));
    g_string_assign(m.diff3_tool, gconf_client_get_string(gconf_client, "/apps/diff-ext/diff3", NULL));
    m.enable_diff3 = gconf_client_get_bool(gconf_client, "/apps/diff-ext/enable-diff3", NULL);
/*    diff_ext_mime_types = eel_preferences_get_string_glist("/apps/diff-ext/mime-types");*/
    diff_ext_mime_types = gconf_client_get_list(gconf_client, "/apps/diff-ext/mime-types", GCONF_VALUE_STRING, NULL);
  g_object_unref(G_OBJECT(gconf_client));
  
  list_model = gtk_list_store_new(COLUMNS_COUNT, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING);
  gtk_tree_sortable_set_sort_func(GTK_TREE_SORTABLE(list_model), ENABLE_GDIFF_EXT, compare_enabled, NULL, NULL);
  gtk_tree_sortable_set_sort_func(GTK_TREE_SORTABLE(list_model), MIME_TYPE, compare_string, GINT_TO_POINTER(MIME_TYPE), NULL);
  gtk_tree_sortable_set_sort_func(GTK_TREE_SORTABLE(list_model), MIME_DESCRIPTION, compare_string, GINT_TO_POINTER(MIME_DESCRIPTION), NULL);
  gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(list_model), MIME_TYPE, GTK_SORT_ASCENDING);
  
  while(mime_types != 0) {
    GtkTreeIter iter;
    char* type = (char*)mime_types->data;
    
    gtk_list_store_append(list_model, &iter);
    gtk_list_store_set(list_model, &iter,
      MIME_TYPE, type,
      MIME_DESCRIPTION, g_content_type_get_description(type),
      -1);
    if((diff_ext_mime_types == NULL) || (g_slist_find_custom(diff_ext_mime_types, type, (GCompareFunc)strcmp) != NULL)) {
      gtk_list_store_set(list_model, &iter,
        ENABLE_GDIFF_EXT, TRUE,
        -1);
    } else {
      gtk_list_store_set(list_model, &iter,
        ENABLE_GDIFF_EXT, FALSE,
        -1);
    }
    
    mime_types = g_list_next(mime_types);
  }
  
  g_slist_free(diff_ext_mime_types);
  
  if(!g_path_is_absolute(m.diff_tool->str)) {
    g_string_assign(m.diff_tool, g_find_program_in_path(m.diff_tool->str));
  }
  
  if(!g_path_is_absolute(m.diff3_tool->str)) {
    g_string_assign(m.diff3_tool, g_find_program_in_path(m.diff3_tool->str));
  }
  
  model = &m;
  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  main = create_main();
  gtk_widget_show(main);

  gtk_main();
  return 0;
}

