/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#include "Attribute.hh"

#include <string>

namespace Cryptonit {

Attribute::Attribute( )
{
    values.clear();
    type = AttributeString;
}

Attribute::Attribute( const Attribute& src )
{
    values.clear();
    values = src.values;
    type = src.type;
}

Attribute::Attribute( Attribute* attr )
{
    values.clear();
    type = attr->getType();
    values = attr->values;
}

Attribute::Attribute( AttributeType t )
{
    values.clear();
    type = t;
}


Attribute::Attribute( const std::string &val, AttributeType t)
{
    values.clear();
    type = t;
    append( val );
}

Attribute::Attribute( const std::string &val )
{
    values.clear();
    type = AttributeString;
    append( val );
}


Attribute::Attribute( const char* val, unsigned long len, AttributeType t )
{
    values.clear();
    type = t;
    append( std::string( val, len ) );
}


Attribute::Attribute( const std::vector<std::string>& val )
{
    values.clear();
    type = AttributeString;
    values = val;
}

Attribute::Attribute( const std::vector<std::string>& val, AttributeType t )
{
    values.clear();
    type = t;
    values = val;
}


Attribute::~Attribute( )
{
    values.clear();
}


AttributeType Attribute::getType() const
{
    return type;
}



bool Attribute::append( const std::string &val )
{
    if( val != "" ) {
	values.push_back( val );
	return true;
    }
    else return false;
}


bool Attribute::append( const std::string &val, AttributeType t )
{
    if( val != "" ) {
	if( t != getType() ) 
	    return false;
	else {
	    values.push_back( val );
	    return true;
	}
    }
    else return false;
}


bool Attribute::append( const char* val, unsigned long len, AttributeType t )
{
    if( val != "" ) {
	if( t != getType() ) 
	    return false;
	else {
	    values.push_back( std::string(val, len) );
	    return true;
	}
    }
    else return false;
}


bool Attribute::erase( const std::string &val )
{
    std::vector<std::string>::iterator i;

    i = values.begin();

    while( i != values.end() && *i != val ) i++;
    if( i != values.end() ) {
	values.erase( i );
	return true;
    }
    else return false;
}

bool Attribute::clear()
{
    values.clear();
    return true;
}

std::vector<std::string> Attribute::getValues()
{
    return values;
}


const std::string& Attribute::getFirstValue() const
{
    return values.front();
}



const std::string& Attribute::getLastValue() const
{
    return values.back();
}


unsigned int Attribute::getNbValues() const
{
    return values.size();
}

	
} // Namespace
