/***************************************************************************
 *   Copyright (C) 2004-2011 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.4.4. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BCITER_H
#define C2BCITER_H

#include "ui_c2bCiter.h"

#include <QSystemTrayIcon>

class QLabel;
class c2bCiterModel;
class c2bCoreCiter;
class c2bSettings;


class c2bCiter : public QWidget
{

    Q_OBJECT

public:
    c2bCiter(QWidget* parentw = 0);
    ~c2bCiter();


public:
    void load();
    void setTrayIcon();


public slots:
    void show();
    void switchShowHide();


signals:
    void openFile(const QString& fn);


protected:
    void keyPressEvent(QKeyEvent* qevent);


private:
    QString _filter_string;
    QStringList _bibtex_files;
    QSystemTrayIcon* _tray_icon;
    Ui::c2bCiter ui;
    bool _clipboard_connected;
    bool _filter_mode;
    bool _view_selected;
    c2bCiterModel* _citations;
    c2bCoreCiter* _citerP;
    c2bSettings* _settingsP;
    void addFiles(const QString& dir);
    void citeReferences();
    void editReference();
    void openFile();
    void openUrl();
    void reload(const c2bCiterModel::State& state);
    void setActions();
    void setFilter(const bool do_filter);
    void toggleSelectedFilter();
    void updateUserTimestamp();


private slots:
    void doSearchInFiles();
    void filterDataChanged(const QString& filter);
    void help();
    void openDirectory();
    void openFiles();
    void reload();
    void showMessage(const QString& ms);
    void toggleCb2Bib();
    void toggleClipboard();
    void toggleFullScreen();
    void trayIconActivated(QSystemTrayIcon::ActivationReason r);

};

#endif
