/* GeneratorDropHandler.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gui.dnd;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

import org.grinvin.factories.FactoryException;
import org.grinvin.factories.FactoryManager;
import org.grinvin.generators.graphs.GraphGenerator;
import org.grinvin.generators.graphs.GraphGeneratorInstance;
import org.grinvin.generators.graphs.GraphGeneratorInstanceManager;
import org.grinvin.generators.graphs.GraphListElementGeneratorSink;
import org.grinvin.worksheet.HasGraphList;
import org.grinvin.gui.components.GeneratorInstanceListComponent;

/**
 * Allows a generator to be dropped onto a component. As a result, the user is asked
 * to present parameters and a new generator instance is created and added to the component.<p>
 * Currently only supports components of type
 * {@link org.grinvin.gui.components.GeneratorInstanceListComponent}.
 */
public class GeneratorDropHandler extends AbstractDropHandler {
    
    // cannot be instantiated by clients
    private GeneratorDropHandler() {
        super(GraphGenerator.class, false);
    }
    
    /**
     * The unique shared object of this type.
     */
    private static final GeneratorDropHandler DROP_HANDLER = new GeneratorDropHandler();
    
    public static GeneratorDropHandler getInstance() {
        return DROP_HANDLER;
    }
    
    //
    private GraphGeneratorInstance getInstance(GraphGenerator generator)
    throws FactoryException{
        if (FactoryManager.configureFactory(generator)) {
            GraphGeneratorInstance ggi =
                    GraphGeneratorInstanceManager.getInstance().createInstance(generator);
            return ggi;
        } else {
            return null;
        }
    }
    
    public boolean acceptDrop(JComponent target, Object object, int seqNr) {
        if (seqNr > 0)
            return false;
        // TODO: avoid instanceof by introducing interface AcceptsGeneratorDrop
        if (target instanceof GeneratorInstanceListComponent) {
            try {
                GraphGeneratorInstance ggi = getInstance((GraphGenerator)object);
                if (ggi == null)
                    return false;
                else {
                    ((GeneratorInstanceListComponent)target).getModel().add(ggi);
                    return true;
                }
            } catch (FactoryException ex) {
                Logger.getLogger("org.grinvin.list").log(Level.WARNING, "Failed to create graph generator instance from generator", ex);
                return false;
            }
        } else if (target instanceof HasGraphList) {
            try {
                GraphGeneratorInstance ggi = getInstance((GraphGenerator)object);
                if (ggi == null)
                    return false;
                else {
                    new GraphListElementGeneratorSink(ggi, (HasGraphList)target).start();
                    return true;
                }
            } catch (FactoryException ex) {
                Logger.getLogger("org.grinvin.list").log(Level.WARNING, "Failed to create graph generator instance from generator", ex);
                return false;
            }
        } else {
            return false;
        }
    }
    
}
