/* FactoryDropHandler.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gui.dnd;

import java.net.URI;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

import org.grinvin.factories.FactoryManager;
import org.grinvin.factories.FactoryParameterException;
import org.grinvin.factories.graphs.GraphFactory;
import org.grinvin.worksheet.HasGraphList;
import org.grinvin.list.graphs.GraphListElement;
import org.grinvin.list.graphs.GraphListElementManager;

/**
 * Allows a factory to be dropped onto a component. As a result, the user is asked
 * to present parameters and a new graph is created and added to the component.<p>
 * A component
 * which uses this handler should be of type {@link org.grinvin.worksheet.HasGraphList}.
 */
public class FactoryDropHandler extends AbstractDropHandler {
    // TODO: make this an inner class of GraphListElement?
    
    //
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.grinvin.list.resources");
    
    // cannot be instantiated by clients
    private FactoryDropHandler() {
        super(GraphFactory.class, false);
        // empty
    }
    
    /**
     * The unique shared object of this type.
     */
    private static final FactoryDropHandler DROP_HANDLER = new FactoryDropHandler();
    
    public static FactoryDropHandler getInstance() {
        return DROP_HANDLER;
    }

    public boolean acceptDrop(JComponent target, Object object, int seqNr) {
        if (seqNr > 0)
            return false;
        if (target instanceof HasGraphList) {
            try {
                GraphFactory factory = (GraphFactory)object;
                if (FactoryManager.configureFactory(factory)) {
                    URI uri = factory.getURI();
                    GraphListElement gle = GraphListElementManager.getInstance().getGraphListElement(uri);
                    if(!((HasGraphList)target).getGraphList().contains(gle)){
                        ((HasGraphList)target).getGraphList().add(gle);
                        return true;
                    } else {
                        JOptionPane.showMessageDialog(target, MessageFormat.format(BUNDLE.getString("GraphList.duplicate"), gle), BUNDLE.getString("GraphList.warning.title"), JOptionPane.DEFAULT_OPTION);
                        return false;
                    }
                } else {
                    return false;
                }
            } catch (FactoryParameterException ex) {
                return false;
            }
        } else
            return false;
    }
    
}
