/* ExpressionListComponent.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gui.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;

import org.grinvin.expr.Expression;
import org.grinvin.expr.ExpressionToString;
import org.grinvin.list.ExpressionListModel;

/**
 * List of expressions.
 */
public class ExpressionListComponent extends JList {
    
    //
    private final ExpressionListModel model;
    
    // shared renderer instance
    private static final  ListCellRenderer RENDERER = new Renderer ();
    
    // TODO: probably needs a special 'ExpressionListElement' which
    // wraps expressions and their string/formula representations
    public ExpressionListComponent(ExpressionListModel model) {
        super(model);
        this.model = model;
        setCellRenderer(RENDERER);
        
        // keyboard interaction
        // TODO: factor out common code with other lists
        getInputMap(WHEN_FOCUSED).put(KeyStroke.getKeyStroke("DELETE"), "deleteSelectedElements");
        getActionMap().put("deleteSelectedElements", new AbstractAction() {
            public void actionPerformed(ActionEvent ev) {
                deleteSelectedElements();
            }
        });
    }
    
    /**
     * Delete currently selected elements.
     */
    public void deleteSelectedElements() {
        //TODO: code copied almost verbatim from WorksheetListComponent (except last line)
        
        // iterate over selected indices
        ListSelectionModel selectionModel = getSelectionModel();
        
        int iMin = selectionModel.getMinSelectionIndex();
        int iMax = selectionModel.getMaxSelectionIndex();
        
        if (iMin < 0 || iMax < iMin)
            return ; // no selection
        
        // remove all indicate elements
        for (int i = iMax; i >= iMin; i--)
            if (selectionModel.isSelectedIndex(i))
                model.remove(i);
    }
    
    private static class Renderer extends DefaultListCellRenderer {
        // converts expressions to strings
        private final ExpressionToString expressionToString;
        
        Renderer() {
            this.expressionToString = new ExpressionToString();
        }
        
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            ((Expression)value).accept(expressionToString);
            setText(expressionToString.getString());
            return this;
        }
        
    }
    
}
