/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.java.parser.BasicJavaParser;
import com.intellij.lang.java.parser.BasicJavaParserUtil;
import com.intellij.openapi.util.Key;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.AbstractBasicJavaDocElementTypeFactory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicJavaDocParser {
    private static final TokenSet TAG_VALUES_SET = TokenSet.create((IElementType[])new IElementType[]{JavaDocTokenType.DOC_TAG_VALUE_TOKEN, JavaDocTokenType.DOC_TAG_VALUE_COMMA, JavaDocTokenType.DOC_TAG_VALUE_DOT, JavaDocTokenType.DOC_TAG_VALUE_LPAREN, JavaDocTokenType.DOC_TAG_VALUE_RPAREN, JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN, JavaDocTokenType.DOC_TAG_VALUE_LT, JavaDocTokenType.DOC_TAG_VALUE_GT, JavaDocTokenType.DOC_TAG_VALUE_COLON, JavaDocTokenType.DOC_TAG_VALUE_QUOTE});
    private static final TokenSet INLINE_TAG_BORDERS_SET = TokenSet.create((IElementType[])new IElementType[]{JavaDocTokenType.DOC_INLINE_TAG_START, JavaDocTokenType.DOC_INLINE_TAG_END});
    private static final TokenSet SKIP_TOKENS = TokenSet.create((IElementType[])new IElementType[]{JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS});
    private static final String SEE_TAG = "@see";
    private static final String LINK_TAG = "@link";
    private static final String LINK_PLAIN_TAG = "@linkplain";
    private static final String PARAM_TAG = "@param";
    private static final String VALUE_TAG = "@value";
    private static final String SNIPPET_TAG = "@snippet";
    private static final Set<String> REFERENCE_TAGS = ContainerUtil.immutableSet((Object[])new String[]{"@throws", "@exception", "@provides", "@uses"});
    private static final Key<Integer> BRACE_SCOPE_KEY = Key.create((String)"Javadoc.Parser.Brace.Scope");

    private BasicJavaDocParser() {
    }

    public static void parseJavadocReference(@NotNull PsiBuilder builder, @NotNull BasicJavaParser parser) {
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(0);
        }
        if (parser == null) {
            BasicJavaDocParser.$$$reportNull$$$0(1);
        }
        parser.getReferenceParser().parseJavaCodeReference(builder, true, true, false, false);
        BasicJavaDocParser.swallowTokens(builder);
    }

    public static void parseJavadocType(@NotNull PsiBuilder builder, @NotNull BasicJavaParser parser) {
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(2);
        }
        if (parser == null) {
            BasicJavaDocParser.$$$reportNull$$$0(3);
        }
        parser.getReferenceParser().parseType(builder, 7);
        BasicJavaDocParser.swallowTokens(builder);
    }

    private static void swallowTokens(PsiBuilder builder) {
        while (!builder.eof()) {
            builder.advanceLexer();
        }
    }

    public static void parseDocCommentText(@NotNull PsiBuilder builder, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(4);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(5);
        }
        builder.enforceCommentTokens(SKIP_TOKENS);
        while (!builder.eof()) {
            IElementType tokenType = BasicJavaDocParser.getTokenType(builder);
            if (tokenType == JavaDocTokenType.DOC_TAG_NAME) {
                BasicJavaDocParser.parseTag(builder, javaDocElementTypeContainer);
                continue;
            }
            BasicJavaDocParser.parseDataItem(builder, null, false, javaDocElementTypeContainer);
        }
    }

    private static void parseTag(PsiBuilder builder, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        IElementType tokenType;
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(6);
        }
        String tagName = builder.getTokenText();
        PsiBuilder.Marker tag = builder.mark();
        builder.advanceLexer();
        while ((tokenType = BasicJavaDocParser.getTokenType(builder)) != null && tokenType != JavaDocTokenType.DOC_TAG_NAME && tokenType != JavaDocTokenType.DOC_COMMENT_END) {
            BasicJavaDocParser.parseDataItem(builder, tagName, false, javaDocElementTypeContainer);
        }
        tag.done(javaDocElementTypeContainer.DOC_TAG);
    }

    private static void parseDataItem(PsiBuilder builder, @Nullable String tagName, boolean isInline, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        IElementType tokenType;
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(7);
        }
        if ((tokenType = BasicJavaDocParser.getTokenType(builder)) == JavaDocTokenType.DOC_INLINE_TAG_START) {
            int braceScope = BasicJavaDocParser.getBraceScope(builder);
            if (braceScope > 0) {
                BasicJavaDocParser.setBraceScope(builder, braceScope + 1);
                builder.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
                builder.advanceLexer();
                return;
            }
            PsiBuilder.Marker tag = builder.mark();
            builder.advanceLexer();
            tokenType = BasicJavaDocParser.getTokenType(builder);
            if (tokenType != JavaDocTokenType.DOC_TAG_NAME && tokenType != JavaDocTokenType.DOC_COMMENT_BAD_CHARACTER) {
                tag.rollbackTo();
                builder.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
                builder.advanceLexer();
                return;
            }
            BasicJavaDocParser.setBraceScope(builder, braceScope + 1);
            String inlineTagName = "";
            while (true) {
                if ((tokenType = BasicJavaDocParser.getTokenType(builder)) == JavaDocTokenType.DOC_TAG_NAME) {
                    inlineTagName = builder.getTokenText();
                } else if (tokenType == null || tokenType == JavaDocTokenType.DOC_COMMENT_END) break;
                BasicJavaDocParser.parseDataItem(builder, inlineTagName, true, javaDocElementTypeContainer);
                if (tokenType != JavaDocTokenType.DOC_INLINE_TAG_END) continue;
                braceScope = BasicJavaDocParser.getBraceScope(builder);
                if (braceScope > 0) {
                    BasicJavaDocParser.setBraceScope(builder, --braceScope);
                }
                if (braceScope == 0) break;
            }
            if (SNIPPET_TAG.equals(inlineTagName)) {
                tag.done(javaDocElementTypeContainer.DOC_SNIPPET_TAG);
            } else {
                tag.done(javaDocElementTypeContainer.DOC_INLINE_TAG);
            }
        } else if (TAG_VALUES_SET.contains(tokenType)) {
            if (SEE_TAG.equals(tagName) && !isInline || LINK_TAG.equals(tagName) && isInline || BasicJavaParserUtil.getLanguageLevel(builder).isAtLeast(LanguageLevel.JDK_1_4) && LINK_PLAIN_TAG.equals(tagName) && isInline) {
                BasicJavaDocParser.parseSeeTagValue(builder, false, javaDocElementTypeContainer);
            } else if (!isInline && tagName != null && REFERENCE_TAGS.contains(tagName)) {
                PsiBuilder.Marker tagValue = builder.mark();
                builder.remapCurrentToken(javaDocElementTypeContainer.DOC_REFERENCE_HOLDER);
                builder.advanceLexer();
                tagValue.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
            } else if (!isInline && PARAM_TAG.equals(tagName)) {
                BasicJavaDocParser.parseParameterRef(builder, javaDocElementTypeContainer);
            } else if (BasicJavaParserUtil.getLanguageLevel(builder).isAtLeast(LanguageLevel.JDK_1_5) && VALUE_TAG.equals(tagName) && isInline) {
                BasicJavaDocParser.parseSeeTagValue(builder, true, javaDocElementTypeContainer);
            } else if (SNIPPET_TAG.equals(tagName) && isInline) {
                BasicJavaDocParser.parseSnippetTagValue(builder, javaDocElementTypeContainer);
            } else {
                BasicJavaDocParser.parseSimpleTagValue(builder, javaDocElementTypeContainer);
            }
        } else if (tokenType == JavaDocTokenType.DOC_INLINE_CODE_FENCE) {
            BasicJavaDocParser.parseInlineCodeBlock(builder, javaDocElementTypeContainer);
        } else if (tokenType == JavaDocTokenType.DOC_CODE_FENCE) {
            BasicJavaDocParser.parseCodeBlock(builder, javaDocElementTypeContainer);
        } else if (tokenType == JavaDocTokenType.DOC_LBRACKET) {
            BasicJavaDocParser.parseMarkdownReferenceChecked(builder, javaDocElementTypeContainer);
        } else {
            BasicJavaDocParser.remapAndAdvance(builder);
        }
    }

    private static void parseInlineCodeBlock(PsiBuilder builder, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(8);
        }
        PsiBuilder.Marker tag = builder.mark();
        IElementType stopElementType = BasicJavaDocParser.findInlineToken(builder, JavaDocTokenType.DOC_INLINE_CODE_FENCE);
        int endOffset = builder.getCurrentOffset();
        tag.rollbackTo();
        if (stopElementType != JavaDocTokenType.DOC_INLINE_CODE_FENCE) {
            builder.advanceLexer();
            return;
        }
        tag = builder.mark();
        builder.advanceLexer();
        while (builder.getCurrentOffset() < endOffset && !builder.eof()) {
            builder.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
            builder.advanceLexer();
        }
        if (!builder.eof()) {
            builder.advanceLexer();
        }
        tag.done(javaDocElementTypeContainer.DOC_MARKDOWN_CODE_BLOCK);
    }

    private static void parseCodeBlock(PsiBuilder builder, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(9);
        }
        if (BasicJavaDocParser.getBraceScope(builder) > 0) {
            builder.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
            builder.advanceLexer();
            return;
        }
        char fenceStart = builder.getTokenText().charAt(0);
        PsiBuilder.Marker tag = builder.mark();
        while (!builder.eof()) {
            builder.advanceLexer();
            if (BasicJavaDocParser.getTokenType(builder) == JavaDocTokenType.DOC_CODE_FENCE && builder.getTokenText().charAt(0) == fenceStart) break;
            builder.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
        }
        if (!builder.eof()) {
            builder.advanceLexer();
        }
        tag.done(javaDocElementTypeContainer.DOC_MARKDOWN_CODE_BLOCK);
    }

    private static void parseMarkdownReferenceChecked(PsiBuilder builder, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        int endLabelOffset;
        boolean isShortRefEmpty;
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(10);
        }
        boolean hasLabel = true;
        PsiBuilder.Marker tag = builder.mark();
        int leftBracketCount = 1;
        int rightBracketCount = 0;
        int startLabelOffset = builder.getCurrentOffset();
        while (!builder.eof()) {
            IElementType token = BasicJavaDocParser.findInlineToken(builder, JavaDocTokenType.DOC_RBRACKET, JavaDocTokenType.DOC_LBRACKET, true);
            if (token == JavaDocTokenType.DOC_LBRACKET) {
                ++leftBracketCount;
                continue;
            }
            if (token != JavaDocTokenType.DOC_RBRACKET || leftBracketCount != ++rightBracketCount) continue;
            break;
        }
        boolean bl = isShortRefEmpty = (endLabelOffset = builder.getCurrentOffset()) - startLabelOffset <= 1;
        if (leftBracketCount != rightBracketCount || isShortRefEmpty) {
            tag.rollbackTo();
            builder.advanceLexer();
            return;
        }
        IElementType firstReferenceToken = BasicJavaDocParser.findInlineToken(builder, JavaDocTokenType.DOC_LBRACKET, JavaDocTokenType.DOC_SPACE, false);
        if (firstReferenceToken != JavaDocTokenType.DOC_LBRACKET) {
            hasLabel = false;
            if (leftBracketCount > 1 || firstReferenceToken == JavaDocTokenType.DOC_LPAREN) {
                tag.rollbackTo();
                builder.advanceLexer();
                return;
            }
        }
        if (hasLabel && BasicJavaDocParser.findInlineToken(builder, JavaDocTokenType.DOC_RBRACKET, JavaDocTokenType.DOC_LBRACKET, true) != JavaDocTokenType.DOC_RBRACKET) {
            hasLabel = false;
            if (leftBracketCount > 1) {
                tag.rollbackTo();
                builder.advanceLexer();
                return;
            }
        }
        tag.rollbackTo();
        tag = builder.mark();
        if (hasLabel) {
            while (!builder.eof()) {
                builder.advanceLexer();
                if (builder.getCurrentOffset() >= endLabelOffset) break;
                builder.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
            }
            builder.advanceLexer();
        }
        builder.advanceLexer();
        BasicJavaDocParser.parseMarkdownReference(builder, javaDocElementTypeContainer);
        builder.advanceLexer();
        tag.done(javaDocElementTypeContainer.DOC_MARKDOWN_REFERENCE_LINK);
    }

    private static void parseMarkdownReference(@NotNull PsiBuilder builder, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(11);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(12);
        }
        PsiBuilder.Marker refStart = builder.mark();
        if (BasicJavaDocParser.getTokenType(builder) == JavaDocTokenType.DOC_RBRACKET) {
            refStart.drop();
            return;
        }
        if (BasicJavaDocParser.getTokenType(builder) != JavaDocTokenType.DOC_SHARP) {
            builder.remapCurrentToken(javaDocElementTypeContainer.DOC_REFERENCE_HOLDER);
            builder.advanceLexer();
        }
        if (BasicJavaDocParser.getTokenType(builder) == JavaDocTokenType.DOC_SHARP) {
            builder.remapCurrentToken(JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN);
            builder.advanceLexer();
            builder.remapCurrentToken(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
            builder.advanceLexer();
            if (builder.getTokenType() == JavaDocTokenType.DOC_LPAREN) {
                builder.advanceLexer();
                PsiBuilder.Marker subValue = builder.mark();
                while (!builder.eof()) {
                    IElementType type = BasicJavaDocParser.getTokenType(builder);
                    if (type == JavaDocTokenType.DOC_COMMENT_DATA) {
                        builder.remapCurrentToken(javaDocElementTypeContainer.DOC_TYPE_HOLDER);
                    } else if (type != JavaDocTokenType.DOC_COMMA) break;
                    builder.advanceLexer();
                }
                if (BasicJavaDocParser.getTokenType(builder) == JavaDocTokenType.DOC_RPAREN) {
                    subValue.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
                    builder.advanceLexer();
                } else {
                    subValue.drop();
                }
            }
            refStart.done(javaDocElementTypeContainer.DOC_METHOD_OR_FIELD_REF);
            return;
        }
        refStart.drop();
    }

    @Nullable
    private static IElementType findInlineToken(@NotNull PsiBuilder builder, IElementType needle) {
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(13);
        }
        return BasicJavaDocParser.findInlineToken(builder, needle, null, false);
    }

    @Contract(mutates="param1")
    @Nullable
    private static IElementType findInlineToken(@NotNull PsiBuilder builder, IElementType needle, @Nullable IElementType travelToken, boolean isTravelTokenDisallowed) {
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(14);
        }
        IElementType token = null;
        while (!builder.eof()) {
            boolean travelTokenFound;
            builder.advanceLexer();
            IElementType previousToken = token;
            token = BasicJavaDocParser.getTokenType(builder, false);
            if (token == needle) {
                return token;
            }
            boolean bl = travelTokenFound = travelToken == token;
            if (!(travelToken != null && (isTravelTokenDisallowed && travelTokenFound || !isTravelTokenDisallowed && !travelTokenFound)) && (token != TokenType.WHITE_SPACE || previousToken != TokenType.WHITE_SPACE)) continue;
            break;
        }
        return builder.eof() ? null : token;
    }

    private static void parseSnippetTagValue(@NotNull PsiBuilder builder, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        IElementType token;
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(15);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(16);
        }
        PsiBuilder.Marker snippetValue = builder.mark();
        snippetValue.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        while ((token = BasicJavaDocParser.getTokenType(builder)) == JavaDocTokenType.DOC_TAG_VALUE_QUOTE) {
            builder.advanceLexer();
        }
        IElementType tokenType = BasicJavaDocParser.getTokenType(builder);
        if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_COLON) {
            BasicJavaParserUtil.emptyElement(builder, javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE_LIST);
            BasicJavaDocParser.parseSnippetTagBody(builder, javaDocElementTypeContainer);
        } else if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            BasicJavaDocParser.parseSnippetAttributeList(builder, javaDocElementTypeContainer);
            if (builder.getTokenType() == JavaDocTokenType.DOC_TAG_VALUE_COLON) {
                BasicJavaDocParser.parseSnippetTagBody(builder, javaDocElementTypeContainer);
            }
        } else {
            BasicJavaParserUtil.emptyElement(builder, javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE_LIST);
            IElementType current = BasicJavaDocParser.getTokenType(builder);
            while (current != null && current != JavaDocTokenType.DOC_INLINE_TAG_END) {
                builder.advanceLexer();
                current = BasicJavaDocParser.getTokenType(builder);
            }
        }
        snippetValue.done(javaDocElementTypeContainer.DOC_SNIPPET_TAG_VALUE);
    }

    private static void parseSnippetTagBody(@NotNull PsiBuilder builder, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        IElementType tokenType;
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(17);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(18);
        }
        PsiBuilder.Marker body = builder.mark();
        body.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        assert (BasicJavaDocParser.getTokenType(builder) == JavaDocTokenType.DOC_TAG_VALUE_COLON);
        builder.advanceLexer();
        while ((tokenType = BasicJavaDocParser.getTokenType(builder)) != null && tokenType != JavaDocTokenType.DOC_INLINE_TAG_END) {
            builder.advanceLexer();
        }
        body.done(javaDocElementTypeContainer.DOC_SNIPPET_BODY);
    }

    private static void parseSnippetAttributeList(@NotNull PsiBuilder builder, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(19);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(20);
        }
        PsiBuilder.Marker attributeList = builder.mark();
        block0: while (true) {
            IElementType type = BasicJavaDocParser.getTokenType(builder);
            while (type != JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                if (type != JavaDocTokenType.DOC_TAG_VALUE_QUOTE) break block0;
                builder.advanceLexer();
                type = BasicJavaDocParser.getTokenType(builder);
            }
            BasicJavaDocParser.parseSnippetAttribute(builder, javaDocElementTypeContainer);
        }
        attributeList.done(javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE_LIST);
    }

    private static void parseSnippetAttribute(@NotNull PsiBuilder builder, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(21);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(22);
        }
        PsiBuilder.Marker attribute = builder.mark();
        assert (builder.getTokenType() == JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
        builder.remapCurrentToken(JavaDocTokenType.DOC_TAG_ATTRIBUTE_NAME);
        builder.advanceLexer();
        BasicJavaDocParser.getTokenType(builder);
        if ("=".equals(builder.getTokenText())) {
            builder.advanceLexer();
            IElementType afterEqToken = BasicJavaDocParser.getTokenType(builder);
            if (afterEqToken == JavaDocTokenType.DOC_TAG_VALUE_QUOTE) {
                PsiBuilder.Marker quotedValue = builder.mark();
                builder.advanceLexer();
                if (BasicJavaDocParser.getTokenType(builder) == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                    builder.advanceLexer();
                }
                if (BasicJavaDocParser.getTokenType(builder) == JavaDocTokenType.DOC_TAG_VALUE_QUOTE) {
                    builder.advanceLexer();
                }
                quotedValue.collapse(javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE_VALUE);
            } else if (afterEqToken == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                builder.remapCurrentToken(javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE_VALUE);
                builder.advanceLexer();
            }
        }
        attribute.done(javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE);
    }

    private static void parseSeeTagValue(@NotNull PsiBuilder builder, boolean allowBareFieldReference, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        IElementType tokenType;
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(23);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(24);
        }
        if ((tokenType = BasicJavaDocParser.getTokenType(builder)) == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            BasicJavaDocParser.parseMethodRef(builder, builder.mark(), javaDocElementTypeContainer);
        } else if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            PsiBuilder.Marker refStart = builder.mark();
            builder.remapCurrentToken(javaDocElementTypeContainer.DOC_REFERENCE_HOLDER);
            builder.advanceLexer();
            if (BasicJavaDocParser.getTokenType(builder) == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
                BasicJavaDocParser.parseMethodRef(builder, refStart, javaDocElementTypeContainer);
            } else if (allowBareFieldReference) {
                refStart.rollbackTo();
                builder.remapCurrentToken(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
                BasicJavaDocParser.parseMethodRef(builder, builder.mark(), javaDocElementTypeContainer);
            } else {
                refStart.drop();
            }
        } else {
            PsiBuilder.Marker tagValue = builder.mark();
            builder.advanceLexer();
            tagValue.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
        }
    }

    private static void parseMethodRef(@NotNull PsiBuilder builder, @NotNull PsiBuilder.Marker refStart, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(25);
        }
        if (refStart == null) {
            BasicJavaDocParser.$$$reportNull$$$0(26);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(27);
        }
        if (BasicJavaDocParser.getTokenType(builder) == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            builder.advanceLexer();
        }
        if (BasicJavaDocParser.getTokenType(builder) != JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            refStart.done(javaDocElementTypeContainer.DOC_METHOD_OR_FIELD_REF);
            return;
        }
        builder.advanceLexer();
        if (BasicJavaDocParser.getTokenType(builder) == JavaDocTokenType.DOC_TAG_VALUE_LPAREN) {
            IElementType tokenType;
            builder.advanceLexer();
            PsiBuilder.Marker subValue = builder.mark();
            while (TAG_VALUES_SET.contains(tokenType = BasicJavaDocParser.getTokenType(builder))) {
                if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                    builder.remapCurrentToken(javaDocElementTypeContainer.DOC_TYPE_HOLDER);
                    builder.advanceLexer();
                    while (TAG_VALUES_SET.contains(tokenType = BasicJavaDocParser.getTokenType(builder)) && tokenType != JavaDocTokenType.DOC_TAG_VALUE_COMMA && tokenType != JavaDocTokenType.DOC_TAG_VALUE_RPAREN) {
                        builder.advanceLexer();
                    }
                    continue;
                }
                if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_RPAREN) {
                    subValue.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
                    builder.advanceLexer();
                    refStart.done(javaDocElementTypeContainer.DOC_METHOD_OR_FIELD_REF);
                    return;
                }
                builder.advanceLexer();
            }
            subValue.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
        }
        refStart.done(javaDocElementTypeContainer.DOC_METHOD_OR_FIELD_REF);
    }

    private static void parseParameterRef(@NotNull PsiBuilder builder, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(28);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(29);
        }
        PsiBuilder.Marker tagValue = builder.mark();
        while (TAG_VALUES_SET.contains(BasicJavaDocParser.getTokenType(builder))) {
            builder.advanceLexer();
        }
        tagValue.done(javaDocElementTypeContainer.DOC_PARAMETER_REF);
    }

    private static void parseSimpleTagValue(@NotNull PsiBuilder builder, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(30);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(31);
        }
        PsiBuilder.Marker tagData = builder.mark();
        while (true) {
            IElementType tokenType;
            if ((tokenType = BasicJavaDocParser.getTokenType(builder)) == JavaDocTokenType.DOC_COMMENT_BAD_CHARACTER) {
                builder.remapCurrentToken(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
            } else if (!TAG_VALUES_SET.contains(tokenType)) break;
            builder.advanceLexer();
        }
        tagData.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
    }

    @Nullable
    private static IElementType getTokenType(PsiBuilder builder) {
        return BasicJavaDocParser.getTokenType(builder, true);
    }

    @Nullable
    private static IElementType getTokenType(PsiBuilder builder, boolean skipWhitespace) {
        IElementType tokenType;
        while ((tokenType = builder.getTokenType()) == JavaDocTokenType.DOC_SPACE) {
            builder.remapCurrentToken(TokenType.WHITE_SPACE);
            if (!skipWhitespace) continue;
            builder.advanceLexer();
        }
        return tokenType;
    }

    private static int getBraceScope(PsiBuilder builder) {
        Integer braceScope = (Integer)builder.getUserData(BRACE_SCOPE_KEY);
        return braceScope != null ? braceScope : 0;
    }

    private static void setBraceScope(PsiBuilder builder, int braceScope) {
        builder.putUserData(BRACE_SCOPE_KEY, (Object)braceScope);
    }

    private static void remapAndAdvance(PsiBuilder builder) {
        if (INLINE_TAG_BORDERS_SET.contains(builder.getTokenType()) && BasicJavaDocParser.getBraceScope(builder) != 1) {
            builder.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
        }
        builder.advanceLexer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaDocElementTypeContainer";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refStart";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/java/parser/BasicJavaDocParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseJavadocReference";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parseJavadocType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDocCommentText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "parseTag";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDataItem";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "parseInlineCodeBlock";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "parseCodeBlock";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "parseMarkdownReferenceChecked";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "parseMarkdownReference";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "findInlineToken";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSnippetTagValue";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSnippetTagBody";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSnippetAttributeList";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSnippetAttribute";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSeeTagValue";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "parseMethodRef";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "parseParameterRef";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSimpleTagValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

