/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.diagnostics.StandardLibrarySpecialCompatibilityChecker;
import org.jetbrains.kotlin.library.BaseKotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsStandardLibrarySpecialCompatibilityChecker;", "Lorg/jetbrains/kotlin/backend/common/diagnostics/StandardLibrarySpecialCompatibilityChecker;", "<init>", "()V", "isStdlib", "", "library", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "getMessageToReport", "", "compilerVersion", "Lorg/jetbrains/kotlin/backend/common/diagnostics/StandardLibrarySpecialCompatibilityChecker$Version;", "stdlibVersion", "ir.serialization.js"})
public final class JsStandardLibrarySpecialCompatibilityChecker
extends StandardLibrarySpecialCompatibilityChecker {
    @NotNull
    public static final JsStandardLibrarySpecialCompatibilityChecker INSTANCE = new JsStandardLibrarySpecialCompatibilityChecker();

    private JsStandardLibrarySpecialCompatibilityChecker() {
    }

    @Override
    protected boolean isStdlib(@NotNull KotlinLibrary library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        return KotlinLibraryKt.isJsStdlib((BaseKotlinLibrary)((BaseKotlinLibrary)library));
    }

    @Override
    @Nullable
    protected String getMessageToReport(@NotNull StandardLibrarySpecialCompatibilityChecker.Version compilerVersion, @NotNull StandardLibrarySpecialCompatibilityChecker.Version stdlibVersion) {
        String string;
        Intrinsics.checkNotNullParameter((Object)compilerVersion, (String)"compilerVersion");
        Intrinsics.checkNotNullParameter((Object)stdlibVersion, (String)"stdlibVersion");
        if (stdlibVersion.compareTo(compilerVersion) < 0) {
            string = "The Kotlin/JS standard library has an older version (" + stdlibVersion + ") than the compiler (" + compilerVersion + "). Such a configuration is not supported.";
        } else if (!stdlibVersion.hasSameLanguageVersion(compilerVersion)) {
            string = "The Kotlin/JS standard library has a more recent version (" + stdlibVersion + ") than the compiler supports. The compiler version is " + compilerVersion + '.';
        } else {
            return null;
        }
        String rootCause = string;
        return rootCause + "\nPlease, make sure that the standard library has the version in the range [" + compilerVersion.toComparableVersionString() + " .. " + compilerVersion.toLanguageVersionString() + ".255]. Adjust your project's settings if necessary.";
    }
}

