/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.cell.JListCellReader;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;

final class JListSelectionValuesQuery {
    @Nonnull
    @RunsInEDT
    static List<String> selectionValues(final @Nonnull JList<?> list, final @Nonnull JListCellReader cellReader) {
        List<String> result = GuiActionRunner.execute(new GuiQuery<List<String>>(){

            @Override
            protected List<String> executeInEDT() {
                int[] selectedIndices;
                ArrayList<String> values = Lists.newArrayList();
                for (int index : selectedIndices = list.getSelectedIndices()) {
                    values.add(cellReader.valueAt(list, index));
                }
                return values;
            }
        });
        return Preconditions.checkNotNull(result);
    }

    private JListSelectionValuesQuery() {
    }
}

