/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import javax.swing.JComboBox;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.cell.JComboBoxCellReader;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.edt.GuiActionRunner;

final class JComboBoxContentQuery {
    @Nonnull
    @RunsInEDT
    static String[] contents(@Nonnull JComboBox<?> comboBox, @Nonnull JComboBoxCellReader cellReader) {
        String[] result = GuiActionRunner.execute(() -> {
            int itemCount = comboBox.getItemCount();
            String[] values = new String[itemCount];
            for (int i = 0; i < itemCount; ++i) {
                values[i] = cellReader.valueAt(comboBox, i);
            }
            return values;
        });
        return Preconditions.checkNotNull(result);
    }

    private JComboBoxContentQuery() {
    }
}

