/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.PatternTranslator;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0004H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u0019\u001a\u00020\u001a*\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/CatchTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "catches", "", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "psi", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "<init>", "(Ljava/util/List;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "getCatches", "()Ljava/util/List;", "getPsi", "()Lcom/intellij/psi/PsiElement;", "translate", "Lorg/jetbrains/kotlin/js/backend/ast/JsCatch;", "translateCatches", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "initialCatchParameterRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "", "translateCatchBody", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "catchClause", "isDynamic", "", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;)Z", "js.translator"})
@SourceDebugExtension(value={"SMAP\nCatchTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CatchTranslator.kt\norg/jetbrains/kotlin/js/translate/expression/CatchTranslator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
public final class CatchTranslator
extends AbstractTranslator {
    @NotNull
    private final List<KtCatchClause> catches;
    @NotNull
    private final PsiElement psi;

    public CatchTranslator(@NotNull List<? extends KtCatchClause> catches, @NotNull PsiElement psi, @NotNull TranslationContext context) {
        Intrinsics.checkNotNullParameter(catches, (String)"catches");
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.catches = catches;
        this.psi = psi;
    }

    @NotNull
    public final List<KtCatchClause> getCatches() {
        return this.catches;
    }

    @NotNull
    public final PsiElement getPsi() {
        return this.psi;
    }

    @Nullable
    public final JsCatch translate() {
        if (this.catches.isEmpty()) {
            return null;
        }
        KtCatchClause firstCatch = (KtCatchClause)CollectionsKt.first(this.catches);
        KtParameter catchParameter = firstCatch.getCatchParameter();
        BindingContext bindingContext = this.bindingContext();
        KtParameter ktParameter = catchParameter;
        Intrinsics.checkNotNull((Object)ktParameter);
        DeclarationDescriptor declarationDescriptor = BindingUtils.getDescriptorForElement(bindingContext, (PsiElement)ktParameter);
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getDescriptorForElement(...)");
        DeclarationDescriptor parameterDescriptor = declarationDescriptor;
        String string = this.context().getNameForDescriptor(parameterDescriptor).getIdent();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdent(...)");
        String parameterName = string;
        JsCatch jsCatch = new JsCatch(this.context().scope(), parameterName);
        JsNameRef jsNameRef = jsCatch.getParameter().getName().makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"makeRef(...)");
        JsNameRef parameterRef = jsNameRef;
        TranslationContext translationContext = this.context().innerContextWithAliased(parameterDescriptor, parameterRef);
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"innerContextWithAliased(...)");
        TranslationContext catchContext = translationContext;
        jsCatch.setBody(new JsBlock(this.translateCatches(catchContext, parameterRef, this.catches.iterator())));
        return jsCatch;
    }

    private final JsStatement translateCatches(TranslationContext context, JsNameRef initialCatchParameterRef, Iterator<? extends KtCatchClause> catches) {
        JsIf jsIf;
        JsNameRef jsNameRef;
        if (!catches.hasNext()) {
            JsThrow jsThrow;
            JsThrow $this$translateCatches_u24lambda_u240 = jsThrow = new JsThrow(initialCatchParameterRef);
            boolean bl = false;
            $this$translateCatches_u24lambda_u240.setSource(this.psi);
            return jsThrow;
        }
        TranslationContext nextContext = context;
        KtCatchClause ktCatchClause = catches.next();
        KtParameter ktParameter = ktCatchClause.getCatchParameter();
        Intrinsics.checkNotNull((Object)ktParameter);
        KtParameter param = ktParameter;
        BindingContext bindingContext = this.bindingContext();
        KtParameter ktParameter2 = ktCatchClause.getCatchParameter();
        Intrinsics.checkNotNull((Object)ktParameter2);
        DeclarationDescriptor declarationDescriptor = BindingUtils.getDescriptorForElement(bindingContext, (PsiElement)ktParameter2);
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getDescriptorForElement(...)");
        DeclarationDescriptor parameterDescriptor = declarationDescriptor;
        JsName jsName = this.context().getNameForDescriptor(parameterDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getNameForDescriptor(...)");
        JsName parameterName = jsName;
        KtTypeReference ktTypeReference = param.getTypeReference();
        Intrinsics.checkNotNull((Object)ktTypeReference);
        KtTypeReference paramType = ktTypeReference;
        List additionalStatements2 = new ArrayList();
        if (!Intrinsics.areEqual((Object)parameterName.getIdent(), (Object)initialCatchParameterRef.getIdent())) {
            JsNameRef ref;
            JsName jsName2 = JsScope.declareTemporaryName(parameterName.getIdent());
            Intrinsics.checkNotNullExpressionValue((Object)jsName2, (String)"declareTemporaryName(...)");
            JsName parameterAlias = jsName2;
            ((Collection)additionalStatements2).add(JsAstUtils.newVar(parameterAlias, initialCatchParameterRef));
            JsNameRef jsNameRef2 = JsAstUtils.pureFqn(parameterAlias, null);
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef2, (String)"pureFqn(...)");
            jsNameRef = ref = jsNameRef2;
        } else {
            jsNameRef = initialCatchParameterRef;
        }
        JsNameRef parameterRef = jsNameRef;
        nextContext = nextContext.innerContextWithAliased(parameterDescriptor, parameterRef);
        JsBlock thenBlock = this.translateCatchBody(nextContext, ktCatchClause);
        thenBlock.getStatements().addAll(0, additionalStatements2);
        if (this.isDynamic(paramType)) {
            return thenBlock;
        }
        PatternTranslator $this$translateCatches_u24lambda_u241 = Translation.patternTranslator(nextContext);
        boolean bl = false;
        JsExpression jsExpression = $this$translateCatches_u24lambda_u241.translateIsCheck(initialCatchParameterRef, paramType);
        Intrinsics.checkNotNull((Object)jsExpression);
        JsExpression typeCheck = jsExpression;
        JsStatement elseBlock = this.translateCatches(context, initialCatchParameterRef, catches);
        JsIf $this$translateCatches_u24lambda_u242 = jsIf = new JsIf(typeCheck.source(ktCatchClause), thenBlock, elseBlock);
        boolean bl2 = false;
        $this$translateCatches_u24lambda_u242.setSource(ktCatchClause);
        return jsIf;
    }

    private final JsBlock translateCatchBody(TranslationContext context, KtCatchClause catchClause) {
        KtExpression catchBody = catchClause.getCatchBody();
        JsStatement jsCatchBody = catchBody != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(catchBody, context) : JsAstUtils.asSyntheticStatement(new JsNullLiteral());
        JsBlock jsBlock = JsAstUtils.convertToBlock(jsCatchBody);
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"convertToBlock(...)");
        return jsBlock;
    }

    private final boolean isDynamic(KtTypeReference $this$isDynamic) {
        Object v = BindingContextUtils.getNotNull(this.bindingContext(), BindingContext.TYPE, $this$isDynamic);
        Intrinsics.checkNotNullExpressionValue(v, (String)"getNotNull(...)");
        return DynamicTypesKt.isDynamic((KotlinType)v);
    }
}

