/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoKt;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslatorKt;
import org.jetbrains.kotlin.js.translate.callTranslator.DefaultFunctionCallCase;
import org.jetbrains.kotlin.js.translate.callTranslator.ExplicitReceivers;
import org.jetbrains.kotlin.js.translate.callTranslator.VariableAccessInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.VariableCallCasesKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0007J*\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0005J2\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\t2\u0006\u0010\u000f\u001a\u00020\u00052\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0005J.\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/js/translate/callTranslator/CallTranslator;", "", "<init>", "()V", "translate", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "extensionOrDispatchReceiver", "translateGet", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "translateSet", "value", "buildCall", "functionDescriptor", "args", "", "dispatchReceiver", "js.translator"})
public final class CallTranslator {
    @NotNull
    public static final CallTranslator INSTANCE = new CallTranslator();

    private CallTranslator() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final JsExpression translate(@NotNull TranslationContext context, @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall2, @Nullable JsExpression extensionOrDispatchReceiver) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        JsExpression jsExpression = CallTranslatorKt.access$translateCall(context, resolvedCall2, new ExplicitReceivers(extensionOrDispatchReceiver, null, 2, null)).source(resolvedCall2.getCall().getCallElement());
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"source(...)");
        return jsExpression;
    }

    public static /* synthetic */ JsExpression translate$default(TranslationContext translationContext, ResolvedCall resolvedCall2, JsExpression jsExpression, int n, Object object) {
        if ((n & 4) != 0) {
            jsExpression = null;
        }
        return CallTranslator.translate(translationContext, resolvedCall2, jsExpression);
    }

    @NotNull
    public final JsExpression translateGet(@NotNull TranslationContext context, @NotNull ResolvedCall<? extends VariableDescriptor> resolvedCall2, @Nullable JsExpression extensionOrDispatchReceiver) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        VariableAccessInfo variableAccessInfo = new VariableAccessInfo(CallInfoKt.getCallInfo(context, resolvedCall2, extensionOrDispatchReceiver), null);
        JsExpression result = variableAccessInfo.constructSafeCallIfNeeded(VariableCallCasesKt.translateVariableAccess(variableAccessInfo)).source(resolvedCall2.getCall().getCallElement());
        Intrinsics.checkNotNull((Object)result);
        MetadataProperties.setType(result, TranslationUtils.getReturnTypeForCoercion(resolvedCall2.getResultingDescriptor().getOriginal()));
        return result;
    }

    public static /* synthetic */ JsExpression translateGet$default(CallTranslator callTranslator, TranslationContext translationContext, ResolvedCall resolvedCall2, JsExpression jsExpression, int n, Object object) {
        if ((n & 4) != 0) {
            jsExpression = null;
        }
        return callTranslator.translateGet(translationContext, resolvedCall2, jsExpression);
    }

    @NotNull
    public final JsExpression translateSet(@NotNull TranslationContext context, @NotNull ResolvedCall<? extends VariableDescriptor> resolvedCall2, @NotNull JsExpression value, @Nullable JsExpression extensionOrDispatchReceiver) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        KotlinType kotlinType = TranslationUtils.getReturnTypeForCoercion(resolvedCall2.getResultingDescriptor());
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getReturnTypeForCoercion(...)");
        KotlinType type = kotlinType;
        JsExpression jsExpression = TranslationUtils.coerce(context, value, type);
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"coerce(...)");
        JsExpression coerceValue = jsExpression;
        VariableAccessInfo variableAccessInfo = new VariableAccessInfo(CallInfoKt.getCallInfo(context, resolvedCall2, extensionOrDispatchReceiver), coerceValue);
        JsExpression result = variableAccessInfo.constructSafeCallIfNeeded(VariableCallCasesKt.translateVariableAccess(variableAccessInfo)).source(resolvedCall2.getCall().getCallElement());
        Intrinsics.checkNotNull((Object)result);
        MetadataProperties.setType(result, context.getCurrentModule().getBuiltIns().getUnitType());
        return result;
    }

    public static /* synthetic */ JsExpression translateSet$default(CallTranslator callTranslator, TranslationContext translationContext, ResolvedCall resolvedCall2, JsExpression jsExpression, JsExpression jsExpression2, int n, Object object) {
        if ((n & 8) != 0) {
            jsExpression2 = null;
        }
        return callTranslator.translateSet(translationContext, resolvedCall2, jsExpression, jsExpression2);
    }

    @NotNull
    public final JsExpression buildCall(@NotNull TranslationContext context, @NotNull FunctionDescriptor functionDescriptor, @NotNull List<? extends JsExpression> args, @Nullable JsExpression dispatchReceiver) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        CallArgumentTranslator.ArgumentsInfo argumentsInfo = new CallArgumentTranslator.ArgumentsInfo(args, false, null, null, 8, null);
        JsName jsName = context.getNameForDescriptor(functionDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getNameForDescriptor(...)");
        JsName functionName = jsName;
        boolean isNative = AnnotationsUtils.isNativeObject(functionDescriptor);
        boolean hasSpreadOperator = false;
        return dispatchReceiver != null ? DefaultFunctionCallCase.INSTANCE.buildDefaultCallWithDispatchReceiver(argumentsInfo, dispatchReceiver, functionName, isNative, hasSpreadOperator) : DefaultFunctionCallCase.INSTANCE.buildDefaultCallWithoutReceiver(context, argumentsInfo, functionDescriptor, isNative, hasSpreadOperator);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final JsExpression translate(@NotNull TranslationContext context, @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        return CallTranslator.translate$default(context, resolvedCall2, null, 4, null);
    }
}

