/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.functors;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.model.AbstractFunctor;
import org.jetbrains.kotlin.contracts.model.Computation;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESTypeSubstitution;
import org.jetbrains.kotlin.contracts.model.ESValue;
import org.jetbrains.kotlin.contracts.model.structure.ESConstants;
import org.jetbrains.kotlin.contracts.model.structure.ESIs;
import org.jetbrains.kotlin.contracts.model.structure.ESKotlinType;
import org.jetbrains.kotlin.contracts.model.structure.ESReturns;
import org.jetbrains.kotlin.contracts.model.structure.ESType;
import org.jetbrains.kotlin.contracts.model.visitors.Reducer;
import org.jetbrains.kotlin.types.UnwrappedType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/contracts/model/functors/IsFunctor;", "Lorg/jetbrains/kotlin/contracts/model/AbstractFunctor;", "type", "Lorg/jetbrains/kotlin/contracts/model/structure/ESType;", "isNegated", "", "<init>", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESType;Z)V", "getType", "()Lorg/jetbrains/kotlin/contracts/model/structure/ESType;", "()Z", "doInvocation", "", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "arguments", "Lorg/jetbrains/kotlin/contracts/model/Computation;", "typeSubstitution", "Lorg/jetbrains/kotlin/contracts/model/ESTypeSubstitution;", "reducer", "Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;", "invokeWithArguments", "arg", "invokeWithValue", "Lorg/jetbrains/kotlin/contracts/model/ConditionalEffect;", "value", "Lorg/jetbrains/kotlin/contracts/model/ESValue;", "resolution"})
@SourceDebugExtension(value={"SMAP\nIsFunctor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IsFunctor.kt\norg/jetbrains/kotlin/contracts/model/functors/IsFunctor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n1#2:50\n*E\n"})
public final class IsFunctor
extends AbstractFunctor {
    @NotNull
    private final ESType type;
    private final boolean isNegated;

    public IsFunctor(@NotNull ESType type, boolean isNegated) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.type = type;
        this.isNegated = isNegated;
    }

    @NotNull
    public final ESType getType() {
        return this.type;
    }

    public final boolean isNegated() {
        return this.isNegated;
    }

    @Override
    @NotNull
    protected List<ESEffect> doInvocation(@NotNull List<? extends Computation> arguments, @NotNull ESTypeSubstitution typeSubstitution, @NotNull Reducer reducer) {
        boolean bl;
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)typeSubstitution, (String)"typeSubstitution");
        Intrinsics.checkNotNullParameter((Object)reducer, (String)"reducer");
        boolean bl2 = bl = arguments.size() == 1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Wrong size of arguments list for Unary operator: expected 1, got " + arguments.size();
            throw new AssertionError((Object)string);
        }
        return this.invokeWithArguments(arguments.get(0), typeSubstitution);
    }

    @NotNull
    public final List<ESEffect> invokeWithArguments(@NotNull Computation arg, @NotNull ESTypeSubstitution typeSubstitution) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Intrinsics.checkNotNullParameter((Object)typeSubstitution, (String)"typeSubstitution");
        return arg instanceof ESValue ? this.invokeWithValue((ESValue)arg, typeSubstitution) : CollectionsKt.emptyList();
    }

    private final List<ConditionalEffect> invokeWithValue(ESValue value, ESTypeSubstitution typeSubstitution) {
        UnwrappedType substitutedKotlinType = typeSubstitution.getSubstitutor().safeSubstitute(this.type.toKotlinType(typeSubstitution.getBuiltIns()).unwrap());
        ESKotlinType substitutedType = new ESKotlinType(substitutedKotlinType);
        ESIs trueIs = new ESIs(value, new IsFunctor(substitutedType, this.isNegated));
        ESIs falseIs = new ESIs(value, new IsFunctor(substitutedType, !this.isNegated));
        ConditionalEffect trueResult = new ConditionalEffect(trueIs, new ESReturns(ESConstants.INSTANCE.getTrueValue()));
        ConditionalEffect falseResult = new ConditionalEffect(falseIs, new ESReturns(ESConstants.INSTANCE.getFalseValue()));
        Object[] objectArray = new ConditionalEffect[]{trueResult, falseResult};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

