/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.performancePlugin;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.jetbrains.performancePlugin.commands.PerformanceCommandCoroutineAdapter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.performancePlugin.dto.MavenGoalConfigurationDto;
import org.jetbrains.idea.maven.performancePlugin.utils.MavenConfigurationUtils;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0003H\u0014J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0094@\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/maven/performancePlugin/ValidateMavenGoalCommand;", "Lcom/jetbrains/performancePlugin/commands/PerformanceCommandCoroutineAdapter;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "getName", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nValidateMavenGoalCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValidateMavenGoalCommand.kt\norg/jetbrains/idea/maven/performancePlugin/ValidateMavenGoalCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n295#2,2:43\n*S KotlinDebug\n*F\n+ 1 ValidateMavenGoalCommand.kt\norg/jetbrains/idea/maven/performancePlugin/ValidateMavenGoalCommand\n*L\n32#1:43,2\n*E\n"})
public final class ValidateMavenGoalCommand
extends PerformanceCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "validateMavenGoal";
    @NotNull
    public static final String PREFIX = "%validateMavenGoal";

    public ValidateMavenGoalCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @NotNull
    protected String getName() {
        return NAME;
    }

    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context2, @NotNull Continuation<? super Unit> $completion) {
        String actualSettingsFile;
        Object v3;
        String configurationMame;
        MavenGoalConfigurationDto settings;
        block3: {
            Project project = context2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            settings = (MavenGoalConfigurationDto)this.deserializeOptionsFromJson(this.extractCommandArgument(PREFIX), MavenGoalConfigurationDto.class);
            RunManager runManager = RunManager.Companion.getInstance(project2);
            MavenRunConfigurationType mavenRunConfigurationType = MavenRunConfigurationType.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)mavenRunConfigurationType, (String)"getInstance(...)");
            List list = runManager.getConfigurationsList((ConfigurationType)mavenRunConfigurationType);
            Intrinsics.checkNotNull((Object)settings);
            configurationMame = MavenRunConfigurationType.generateName(project2, MavenConfigurationUtils.INSTANCE.createRunnerParams(project2, settings));
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RunConfiguration it = (RunConfiguration)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)configurationMame)) continue;
                v3 = element$iv;
                break block3;
            }
            v3 = null;
        }
        RunConfiguration configuration = v3;
        if (configuration == null) {
            throw new IllegalArgumentException("There is no configuration with name " + configurationMame);
        }
        MavenGeneralSettings mavenGeneralSettings = ((MavenRunConfiguration)configuration).getGeneralSettings();
        String string = actualSettingsFile = mavenGeneralSettings != null ? mavenGeneralSettings.getUserSettingsFile() : null;
        if (!Intrinsics.areEqual((Object)actualSettingsFile, (Object)settings.getSettingsFilePath())) {
            throw new IllegalArgumentException("User settings file " + settings.getSettingsFilePath() + " does not match configuration " + actualSettingsFile + ".");
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/maven/performancePlugin/ValidateMavenGoalCommand$Companion;", "", "<init>", "()V", "NAME", "", "PREFIX", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

