/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenModuleType;
import org.jetbrains.idea.maven.importing.MavenWorkspaceConfigurator;
import org.jetbrains.idea.maven.importing.MavenWorkspaceFacetConfiguratorKt;
import org.jetbrains.idea.maven.importing.StandardMavenModuleType;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsTree;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016JL\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0014\u0010\u0006\u001a\u00020\u00032\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u001cH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001d\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenWorkspaceFacetConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator;", "isApplicable", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "isFacetDetectionDisabled", "project", "Lcom/intellij/openapi/project/Project;", "preProcess", "", "storage", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "module", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "userDataHolder", "Lcom/intellij/openapi/util/UserDataHolderEx;", "process", "mavenTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "mavenProjectToModuleName", "", "", "context", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$Context;", "configureMavenProject", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$MutableMavenProjectContext;", "beforeModelApplied", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$MutableModelContext;", "intellij.maven"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nMavenWorkspaceFacetConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenWorkspaceFacetConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenWorkspaceFacetConfigurator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n693#2:110\n726#2,2:111\n729#2:127\n2341#3,14:113\n*S KotlinDebug\n*F\n+ 1 MavenWorkspaceFacetConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenWorkspaceFacetConfigurator\n*L\n84#1:110\n84#1:111,2\n84#1:127\n85#1:113,14\n*E\n"})
public interface MavenWorkspaceFacetConfigurator
extends MavenWorkspaceConfigurator {
    public boolean isApplicable(@NotNull MavenProject var1);

    public boolean isFacetDetectionDisabled(@NotNull Project var1);

    default public void preProcess(@NotNull MutableEntityStorage storage, @NotNull ModuleEntity module, @NotNull Project project, @NotNull MavenProject mavenProject, @NotNull UserDataHolderEx userDataHolder) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)userDataHolder, (String)"userDataHolder");
        this.preProcess(storage, module, project, mavenProject);
    }

    default public void preProcess(@NotNull MutableEntityStorage storage, @NotNull ModuleEntity module, @NotNull Project project, @NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
    }

    default public void process(@NotNull MutableEntityStorage storage, @NotNull ModuleEntity module, @NotNull Project project, @NotNull MavenProject mavenProject, @NotNull MavenProjectsTree mavenTree, @NotNull Map<MavenProject, String> mavenProjectToModuleName, @NotNull UserDataHolderEx userDataHolder) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)mavenTree, (String)"mavenTree");
        Intrinsics.checkNotNullParameter(mavenProjectToModuleName, (String)"mavenProjectToModuleName");
        Intrinsics.checkNotNullParameter((Object)userDataHolder, (String)"userDataHolder");
        this.process(storage, module, project, mavenProject);
    }

    default public void process(@NotNull MutableEntityStorage storage, @NotNull ModuleEntity module, @NotNull Project project, @NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
    }

    private boolean isFacetDetectionDisabled(MavenWorkspaceConfigurator.Context<?> context2) {
        context2.putUserDataIfAbsent(MavenWorkspaceFacetConfiguratorKt.access$getFACET_DETECTION_DISABLED_KEY$p(), new ConcurrentHashMap());
        Boolean bl = ((ConcurrentHashMap)MavenWorkspaceFacetConfiguratorKt.access$getFACET_DETECTION_DISABLED_KEY$p().get((UserDataHolder)context2)).computeIfAbsent(this, arg_0 -> MavenWorkspaceFacetConfigurator.isFacetDetectionDisabled$lambda$1(arg_0 -> MavenWorkspaceFacetConfigurator.isFacetDetectionDisabled$lambda$0(this, context2, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"computeIfAbsent(...)");
        return bl;
    }

    @Override
    default public void configureMavenProject(@NotNull MavenWorkspaceConfigurator.MutableMavenProjectContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.isFacetDetectionDisabled(context2)) {
            return;
        }
        Project project = context2.getProject();
        MavenWorkspaceConfigurator.MavenProjectWithModules<ModuleEntity> mavenProjectWithModules = context2.getMavenProjectWithModules();
        MavenProject mavenProject = mavenProjectWithModules.getMavenProject();
        if (!this.isApplicable(mavenProject)) {
            return;
        }
        List<MavenWorkspaceConfigurator.ModuleWithType<ModuleEntity>> modules = mavenProjectWithModules.getModules();
        for (MavenWorkspaceConfigurator.ModuleWithType<ModuleEntity> moduleWithType : modules) {
            MavenModuleType moduleType = moduleWithType.getType();
            if (!moduleType.getContainsCode()) continue;
            ModuleEntity module = moduleWithType.getModule();
            this.preProcess((MutableEntityStorage)context2.getStorage(), module, project, mavenProject, context2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    default public void beforeModelApplied(@NotNull MavenWorkspaceConfigurator.MutableModelContext context2) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.isFacetDetectionDisabled(context2)) {
            return;
        }
        Project project = context2.getProject();
        Sequence mavenProjectsWithModules = context2.getMavenProjectsWithModules();
        MutableEntityStorage storage = (MutableEntityStorage)context2.getStorage();
        MavenProjectsTree mavenTree = context2.getMavenProjectsTree();
        Sequence $this$associateBy$iv = mavenProjectsWithModules;
        boolean $i$f$associateBy = false;
        Sequence sequence = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Object v0;
            MavenWorkspaceConfigurator.MavenProjectWithModules mavenProjectWithModules = (MavenWorkspaceConfigurator.MavenProjectWithModules)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            MavenWorkspaceConfigurator.MavenProjectWithModules it = (MavenWorkspaceConfigurator.MavenProjectWithModules)element$iv$iv;
            MavenProject mavenProject = it.getMavenProject();
            boolean bl2 = false;
            Iterable $this$minByOrNull$iv = it.getModules();
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = minElem$iv;
                } else {
                    MavenWorkspaceConfigurator.ModuleWithType moduleWithType = (MavenWorkspaceConfigurator.ModuleWithType)minElem$iv;
                    boolean bl3 = false;
                    int minValue$iv = MavenWorkspaceFacetConfigurator.beforeModelApplied$mavenModuleTypeOrder(moduleWithType.getType());
                    do {
                        Object e$iv = iterator$iv.next();
                        MavenWorkspaceConfigurator.ModuleWithType moduleWithType2 = (MavenWorkspaceConfigurator.ModuleWithType)e$iv;
                        $i$a$-minByOrNull-MavenWorkspaceFacetConfigurator$beforeModelApplied$mavenProjectToModuleName$2$1 = false;
                        int v$iv = MavenWorkspaceFacetConfigurator.beforeModelApplied$mavenModuleTypeOrder(moduleWithType2.getType());
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = minElem$iv;
                }
            }
            Intrinsics.checkNotNull(v0);
            String string = ((ModuleEntity)((MavenWorkspaceConfigurator.ModuleWithType)v0).getModule()).getName();
            map.put(mavenProject, string);
        }
        Map mavenProjectToModuleName = destination$iv$iv;
        for (MavenWorkspaceConfigurator.MavenProjectWithModules mavenProjectWithModules : mavenProjectsWithModules) {
            MavenProject mavenProject = mavenProjectWithModules.getMavenProject();
            if (!this.isApplicable(mavenProject)) continue;
            List modules = mavenProjectWithModules.getModules();
            for (MavenWorkspaceConfigurator.ModuleWithType moduleWithType : modules) {
                MavenModuleType moduleType = moduleWithType.getType();
                if (!moduleType.getContainsCode()) continue;
                ModuleEntity module = (ModuleEntity)moduleWithType.getModule();
                this.process(storage, module, project, mavenProject, mavenTree, mavenProjectToModuleName, context2);
            }
        }
    }

    private static Boolean isFacetDetectionDisabled$lambda$0(MavenWorkspaceFacetConfigurator this$0, MavenWorkspaceConfigurator.Context $context, MavenWorkspaceFacetConfigurator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isFacetDetectionDisabled($context.getProject());
    }

    private static Boolean isFacetDetectionDisabled$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static int beforeModelApplied$mavenModuleTypeOrder(MavenModuleType type) {
        int n;
        MavenModuleType mavenModuleType = type;
        if (mavenModuleType == StandardMavenModuleType.SINGLE_MODULE) {
            n = 0;
        } else if (mavenModuleType == StandardMavenModuleType.MAIN_ONLY) {
            n = 1;
        } else if (mavenModuleType == StandardMavenModuleType.TEST_ONLY) {
            n = 2;
        } else if (mavenModuleType == StandardMavenModuleType.COMPOUND_MODULE) {
            n = 3;
        } else if (mavenModuleType == StandardMavenModuleType.AGGREGATOR) {
            n = 4;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }
}

