/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.pom.Navigatable;
import com.intellij.pom.java.LanguageLevel;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.buildtool.quickfix.OpenMavenRunnerSettingsQuickFix;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenParsingContext;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenSpyLoggedEventParser;
import org.jetbrains.idea.maven.externalSystemIntegration.output.parsers.MavenEventType;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.MavenRunConfigurationOpenQuickFix;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J2\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00110\u0010H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002JA\u0010\u0017\u001a\u00020\u00182\u000b\u0010\u0019\u001a\u00070\u000e\u00a2\u0006\u0002\b\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\r\u0010\u001d\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u001a2\u000b\u0010\u001e\u001a\u00070\u000e\u00a2\u0006\u0002\b\u001a2\u0006\u0010\u001f\u001a\u00020\u0016H\u0002J9\u0010 \u001a\u00020\u00182\u000b\u0010\u0019\u001a\u00070\u000e\u00a2\u0006\u0002\b\u001a2\r\u0010\u001d\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u001a2\u000b\u0010\u001e\u001a\u00070\u000e\u00a2\u0006\u0002\b\u001a2\u0006\u0010\u001f\u001a\u00020\u0016H\u0002J/\u0010!\u001a\u00020\u00182\u000b\u0010\u001e\u001a\u00070\u000e\u00a2\u0006\u0002\b\u001a2\n\u0010\"\u001a\u00060#j\u0002`$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002\u00a8\u0006("}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/InvalidTargetReleaseQuickFix;", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenSpyLoggedEventParser;", "<init>", "()V", "supportsType", "", "type", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/parsers/MavenEventType;", "processLogLine", "parentId", "", "parsingContext", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/MavenParsingContext;", "logLine", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "getRunnerSdkName", "project", "Lcom/intellij/openapi/project/Project;", "getLanguageLevelFromLog", "Lcom/intellij/pom/java/LanguageLevel;", "getBuildIssueForRunConfiguration", "Lcom/intellij/build/issue/BuildIssue;", "moduleName", "Lcom/intellij/openapi/util/NlsSafe;", "persistedRunConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "runnerSdkName", "errorMessage", "requiredLanguageLevel", "getBuildIssueForDefaultRunner", "buildIssue", "issueDescription", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "quickFixes", "", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nInvalidTargetReleaseQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvalidTargetReleaseQuickFix.kt\norg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/InvalidTargetReleaseQuickFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1#2:139\n*E\n"})
public final class InvalidTargetReleaseQuickFix
implements MavenSpyLoggedEventParser {
    @Override
    public boolean supportsType(@NotNull MavenEventType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return type == MavenEventType.MOJO_FAILED;
    }

    @Override
    public boolean processLogLine(@NotNull Object parentId, @NotNull MavenParsingContext parsingContext, @NotNull String logLine, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)parsingContext, (String)"parsingContext");
        Intrinsics.checkNotNullParameter((Object)logLine, (String)"logLine");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        if (StringsKt.contains$default((CharSequence)logLine, (CharSequence)"invalid target release:", (boolean)false, (int)2, null)) {
            BuildIssue buildIssue2;
            Object v0;
            block9: {
                String lastErrorProject = CollectionsKt.last((List)parsingContext.getStartedProjects()) + ":";
                Iterable iterable = parsingContext.getProjectsInReactor();
                for (Object t : iterable) {
                    String it = (String)t;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)lastErrorProject, (boolean)false, (int)2, null)) continue;
                    v0 = t;
                    break block9;
                }
                v0 = null;
            }
            String string = v0;
            if (string == null) {
                return false;
            }
            String failedProject = string;
            Project project = parsingContext.getIdeaProject();
            MavenProject mavenProject = MavenProjectsManager.getInstance(project).findProject(new MavenId(failedProject));
            if (mavenProject == null) {
                return false;
            }
            MavenProject mavenProject2 = mavenProject;
            if (mavenProject2.getMavenId().getArtifactId() == null) {
                return false;
            }
            ModuleManager moduleManager = ModuleManager.Companion.getInstance(project);
            String string2 = mavenProject2.getMavenId().getArtifactId();
            Intrinsics.checkNotNull((Object)string2);
            Module module = moduleManager.findModuleByName(string2);
            if (module == null) {
                return false;
            }
            Module module2 = module;
            String runnerSdkName = this.getRunnerSdkName(parsingContext, project);
            LanguageLevel languageLevel = this.getLanguageLevelFromLog(logLine);
            if (languageLevel == null) {
                return false;
            }
            LanguageLevel requiredLanguageLevel = languageLevel;
            RunManager runManager = RunManager.Companion.getInstance(project);
            ConfigurationType configurationType = parsingContext.getRunConfiguration().getType();
            Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"getType(...)");
            String string3 = parsingContext.getRunConfiguration().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            RunnerAndConfigurationSettings persistedRunConfiguration = runManager.findConfigurationByTypeAndName(configurationType, string3);
            if (persistedRunConfiguration == null || !(persistedRunConfiguration.getConfiguration() instanceof MavenRunConfiguration)) {
                String string4 = module2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                buildIssue2 = this.getBuildIssueForDefaultRunner(string4, runnerSdkName, logLine, requiredLanguageLevel);
            } else {
                String string5 = module2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
                buildIssue2 = this.getBuildIssueForRunConfiguration(string5, persistedRunConfiguration, runnerSdkName, logLine, requiredLanguageLevel);
            }
            BuildIssue buildIssue3 = buildIssue2;
            messageConsumer.accept((BuildEvent)new BuildIssueEventImpl(parentId, buildIssue3, MessageEvent.Kind.ERROR));
            return true;
        }
        return false;
    }

    private final String getRunnerSdkName(MavenParsingContext parsingContext, Project project) {
        String jreName;
        MavenRunnerSettings mavenRunnerSettings = parsingContext.getRunConfiguration().getRunnerSettings();
        String string = jreName = mavenRunnerSettings != null ? mavenRunnerSettings.getJreName() : null;
        if (jreName == null) {
            return ProjectRootManager.getInstance((Project)project).getProjectSdkName();
        }
        Sdk sdk = ExternalSystemJdkUtil.resolveJdkName((Sdk)ProjectRootManager.getInstance((Project)project).getProjectSdk(), (String)jreName);
        return sdk != null ? sdk.getName() : null;
    }

    private final LanguageLevel getLanguageLevelFromLog(String logLine) {
        String[] stringArray = new String[]{" "};
        String it = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)logLine, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        boolean bl = false;
        return LanguageLevel.parse((String)it);
    }

    private final BuildIssue getBuildIssueForRunConfiguration(String moduleName, RunnerAndConfigurationSettings persistedRunConfiguration, String runnerSdkName, String errorMessage, LanguageLevel requiredLanguageLevel) {
        MavenRunConfigurationOpenQuickFix setupRunConfigQuickFix = new MavenRunConfigurationOpenQuickFix(persistedRunConfiguration);
        List quickFixes = CollectionsKt.listOf((Object)setupRunConfigQuickFix);
        StringBuilder issueDescription = new StringBuilder(errorMessage);
        issueDescription.append("\n\n");
        if (runnerSdkName == null) {
            Object[] objectArray = new Object[]{moduleName, requiredLanguageLevel.toJavaVersion(), persistedRunConfiguration.getName(), setupRunConfigQuickFix.getId()};
            v0 = issueDescription.append(MavenProjectBundle.message("maven.quickfix.invalid.target.release.version.run.config.unknown.sdk", objectArray));
        } else {
            Object[] objectArray = new Object[]{runnerSdkName, moduleName, requiredLanguageLevel.toJavaVersion(), persistedRunConfiguration.getName(), setupRunConfigQuickFix.getId()};
            v0 = issueDescription.append(MavenProjectBundle.message("maven.quickfix.invalid.target.release.version.run.config", objectArray));
        }
        return this.buildIssue(errorMessage, issueDescription, quickFixes);
    }

    private final BuildIssue getBuildIssueForDefaultRunner(String moduleName, String runnerSdkName, String errorMessage, LanguageLevel requiredLanguageLevel) {
        OpenMavenRunnerSettingsQuickFix setupRunnerQuickFix = new OpenMavenRunnerSettingsQuickFix("JRE");
        List quickFixes = CollectionsKt.listOf((Object)setupRunnerQuickFix);
        StringBuilder issueDescription = new StringBuilder(errorMessage);
        issueDescription.append("\n\n");
        if (runnerSdkName == null) {
            Object[] objectArray = new Object[]{moduleName, requiredLanguageLevel.toJavaVersion(), setupRunnerQuickFix.getId()};
            v0 = issueDescription.append(MavenProjectBundle.message("maven.quickfix.invalid.target.release.version.unknown.sdk", objectArray));
        } else {
            Object[] objectArray = new Object[]{runnerSdkName, moduleName, requiredLanguageLevel.toJavaVersion(), setupRunnerQuickFix.getId()};
            v0 = issueDescription.append(MavenProjectBundle.message("maven.quickfix.invalid.target.release.version", objectArray));
        }
        return this.buildIssue(errorMessage, issueDescription, quickFixes);
    }

    private final BuildIssue buildIssue(String errorMessage, StringBuilder issueDescription, List<? extends BuildIssueQuickFix> quickFixes) {
        return new BuildIssue(errorMessage, issueDescription, quickFixes){
            private final String title;
            private final String description;
            private final List<BuildIssueQuickFix> quickFixes;
            {
                this.title = $errorMessage;
                String string = $issueDescription.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                this.description = string;
                this.quickFixes = $quickFixes;
            }

            public String getTitle() {
                return this.title;
            }

            public String getDescription() {
                return this.description;
            }

            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            public Navigatable getNavigatable(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return null;
            }
        };
    }
}

