/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomConfiguration;

public final class MavenXmlExtension
extends DefaultXmlExtension {
    public boolean isAvailable(PsiFile file) {
        return file instanceof XmlFile && MavenDomUtil.isMavenFile(file);
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(XmlTag tag, XmlTag contextTag, XmlElementDescriptor parentDescriptor) {
        MavenDomConfiguration configuration;
        DomElement domElement = DomManagerImpl.getDomManager((Project)tag.getProject()).getDomElement(contextTag);
        if (domElement != null && (configuration = (MavenDomConfiguration)DomUtil.getParentOfType((DomElement)domElement, MavenDomConfiguration.class, (boolean)false)) != null && configuration.getGenericInfo().getFixedChildrenDescriptions().isEmpty()) {
            return new AnyXmlElementDescriptor(null, null);
        }
        return super.getElementDescriptor(tag, contextTag, parentDescriptor);
    }
}

