/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.starter;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.FullLinePluginInfo;
import org.jetbrains.completion.full.line.UtilsKt;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupporter;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupporterEP;
import org.jetbrains.completion.full.line.settings.FullLineSettings;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\u0007J\u0006\u0010\n\u001a\u00020\u0007J\u0015\u0010\u000b\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0082\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineInfo;", "", "<init>", "()V", "init", "", "collect", "", "pluginDescriptor", "systemInfo", "languages", "times", "i", "", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nFullLineInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineInfo.kt\norg/jetbrains/completion/full/line/starter/FullLineInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n774#2:99\n865#2,2:100\n1863#2,2:102\n1#3:104\n*S KotlinDebug\n*F\n+ 1 FullLineInfo.kt\norg/jetbrains/completion/full/line/starter/FullLineInfo\n*L\n54#1:99\n54#1:100,2\n78#1:102,2\n*E\n"})
public final class FullLineInfo {
    @NotNull
    public static final FullLineInfo INSTANCE = new FullLineInfo();

    private FullLineInfo() {
    }

    private final void init() {
        FileTypeManager.getInstance();
    }

    @NotNull
    public final String collect() {
        StringBuilder stringBuilder;
        this.init();
        String system = this.systemInfo();
        String plugin = this.pluginDescriptor();
        String languages = this.languages();
        StringBuilder $this$collect_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$collect_u24lambda_u240.append(INSTANCE.times("=", 16) + "System info" + INSTANCE.times("=", 16));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder3 = $this$collect_u24lambda_u240.append(system);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder4 = $this$collect_u24lambda_u240.append(INSTANCE.times("=", 16) + "Plugin info" + INSTANCE.times("=", 16));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder5 = $this$collect_u24lambda_u240.append(plugin);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder6 = $this$collect_u24lambda_u240.append(INSTANCE.times("=", 16) + "Languages" + INSTANCE.times("=", 16));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder7 = $this$collect_u24lambda_u240.append(languages);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String pluginDescriptor() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        IdeaPluginDescriptor ideaPluginDescriptor = FullLinePluginInfo.INSTANCE.get();
        if (ideaPluginDescriptor == null) {
            return "not-found";
        }
        IdeaPluginDescriptor pluginDescriptor = ideaPluginDescriptor;
        boolean isBundled = pluginDescriptor.isBundled();
        boolean isEnabled = pluginDescriptor.isEnabled();
        StringBuilder output = new StringBuilder("Full Line plugin version ");
        UtilsKt.plusAssign(output, isEnabled ? "(enabled)" : "(disabled)");
        UtilsKt.plusAssign(output, ": ");
        UtilsKt.plusAssign(output, pluginDescriptor);
        UtilsKt.plusAssign(output, isBundled ? " (bundled)" : "");
        UtilsKt.plusAssign(output, "\nSettings: ");
        UtilsKt.plusAssign(output, FullLineSettings.Companion.getInstance().getSettingsState());
        UtilsKt.plusAssign(output, "\nRegistry keys: ");
        Iterable iterable = Registry.Companion.getAll();
        StringBuilder stringBuilder = output;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RegistryValue it = (RegistryValue)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it.getKey(), (String)"full.line", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        UtilsKt.plusAssign(stringBuilder, CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        String string = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String systemInfo() {
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        Calendar cal = appInfo.getBuildDate();
        StringBuilder output = new StringBuilder("Build version: ");
        String string = appInfo.getFullApplicationName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullApplicationName(...)");
        UtilsKt.plusAssign(output, string);
        String buildInfo = "Build: #" + appInfo.getBuild();
        Object buildDate = "";
        if (appInfo.getBuild().isSnapshot()) {
            buildDate = new SimpleDateFormat("HH:mm, ").format(cal.getTime());
        }
        buildDate = (String)buildDate + DateFormat.getDateInstance(1, Locale.US).format(cal.getTime());
        UtilsKt.plusAssign(output, " " + buildInfo + " " + (String)buildDate);
        String string2 = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public final String languages() {
        Object it;
        Iterable $this$forEach$iv = FullLineLanguageSupporterEP.Companion.getEP_NAME().getExtensionList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FullLineLanguageSupporterEP)((Object)element$iv);
            boolean bl = false;
            it.getInstance();
        }
        List<String> languages = FullLineLanguageSupporter.Companion.supportedLanguages();
        Iterator iterator2 = ((Iterable)languages).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        it = (String)iterator2.next();
        boolean bl = false;
        int n = ((String)it).length();
        while (iterator2.hasNext()) {
            String it2 = (String)iterator2.next();
            $i$a$-maxOf-FullLineInfo$languages$pad$1 = false;
            int n2 = it2.length();
            if (n >= n2) continue;
            n = n2;
        }
        int pad = n + 4;
        return CollectionsKt.joinToString$default((Iterable)languages, (CharSequence)"", (CharSequence)"Supported languages: ", null, (int)0, null, arg_0 -> FullLineInfo.languages$lambda$4(pad, arg_0), (int)28, null);
    }

    private final String times(String $this$times, int i) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        return StringsKt.repeat((CharSequence)$this$times, (int)i);
    }

    private static final CharSequence languages$lambda$4(int $pad, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Language language = Language.findLanguageByID((String)it);
        Intrinsics.checkNotNull((Object)language);
        Language language2 = language;
        Object[] objectArray = new String[2];
        objectArray[0] = FullLineSettings.Companion.getInstance().isEnabled(language2) ? "enabled" : "disabled";
        FullLineLanguageSupporter fullLineLanguageSupporter = FullLineLanguageSupporter.Companion.getInstance(language2);
        Intrinsics.checkNotNull((Object)fullLineLanguageSupporter);
        objectArray[1] = !fullLineLanguageSupporter.getShowInSettings() ? "experimental" : null;
        String labels = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null);
        String string = it.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return "\n\t-" + StringsKt.padEnd$default((String)string, (int)$pad, (char)'\u0000', (int)2, null) + labels;
    }
}

