/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.revisions;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.Paths;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ChangeRevision
extends Revision {
    private final LocalHistoryFacade myFacade;
    private final RootEntry myRoot;
    @NotNull
    private final String myEntryPath;
    private final long myTimestamp;
    private final Change myChangeToRevert;
    private final boolean myBefore;
    private final long myId;
    private final @NlsContexts.Label String myName;
    private final @NlsContexts.Label String myLabel;
    private final int myLabelColor;
    private final Pair<List<String>, Integer> myAffectedFiles;

    public ChangeRevision(LocalHistoryFacade facade, RootEntry r, @NotNull String entryPath, ChangeSet changeSet, boolean before) {
        if (entryPath == null) {
            ChangeRevision.$$$reportNull$$$0(0);
        }
        this.myFacade = facade;
        this.myRoot = r;
        this.myEntryPath = entryPath;
        this.myBefore = before;
        this.myTimestamp = changeSet.getTimestamp();
        this.myChangeToRevert = before ? changeSet.getFirstChange() : changeSet.getLastChange();
        this.myId = changeSet.getId();
        this.myLabel = changeSet.getLabel();
        this.myLabelColor = changeSet.getLabelColor();
        this.myName = changeSet.getName();
        List<String> allAffectedFiles = changeSet.getAffectedPaths();
        SmartList someAffectedFiles = new SmartList();
        for (String each : ContainerUtil.getFirstItems(allAffectedFiles, (int)3)) {
            someAffectedFiles.add(Paths.getNameOf(each));
        }
        this.myAffectedFiles = Pair.create((Object)someAffectedFiles, (Object)allAffectedFiles.size());
    }

    @Override
    public long getTimestamp() {
        return this.myTimestamp;
    }

    @Override
    public Entry findEntry() {
        RootEntry rootCopy = this.myRoot.copy();
        boolean revertThis = this.myBefore;
        String path = this.myFacade.revertUpToChange(rootCopy, this.myChangeToRevert.getId(), this.myEntryPath, revertThis, true);
        return rootCopy.findEntry(path);
    }

    @Override
    public RootEntry getRoot() {
        return this.myRoot;
    }

    @Override
    public String getLabel() {
        return this.myLabel;
    }

    @Override
    public int getLabelColor() {
        return this.myLabelColor;
    }

    @Override
    public Long getChangeSetId() {
        return this.myId;
    }

    @Override
    public String getChangeSetName() {
        return this.myName;
    }

    @Override
    public Pair<List<String>, Integer> getAffectedFileNames() {
        return this.myAffectedFiles;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.myChangeToRevert;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryPath", "com/intellij/history/core/revisions/ChangeRevision", "<init>"));
    }
}

