/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.ui.impl;

import com.intellij.debugger.streams.StreamDebuggerBundle;
import com.intellij.debugger.streams.ui.ChooserOption;
import com.intellij.debugger.streams.ui.ElementChooser;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.components.JBList;
import java.awt.Color;
import java.awt.Component;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ElementChooserImpl<T extends ChooserOption>
implements ElementChooser<T> {
    private static final int HIGHLIGHT_LAYER = 6001;
    private final Set<RangeHighlighter> myRangeHighlighters;
    private final Editor myEditor;
    private final TextAttributes myAttributes;

    public ElementChooserImpl(@NotNull Editor editor) {
        if (editor == null) {
            ElementChooserImpl.$$$reportNull$$$0(0);
        }
        this.myRangeHighlighters = new HashSet<RangeHighlighter>();
        this.myEditor = editor;
        TextAttributes searchResultAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        Color foreground = editor.getColorsScheme().getDefaultForeground();
        this.myAttributes = new TextAttributes(foreground, searchResultAttributes.getBackgroundColor(), null, searchResultAttributes.getEffectType(), searchResultAttributes.getFontType());
    }

    @Override
    public void show(@NotNull List<T> options, @NotNull ElementChooser.CallBack<T> callBack) {
        if (options == null) {
            ElementChooserImpl.$$$reportNull$$$0(1);
        }
        if (callBack == null) {
            ElementChooserImpl.$$$reportNull$$$0(2);
        }
        DefaultListModel<ChooserOption> model = new DefaultListModel<ChooserOption>();
        int maxOffset = -1;
        for (ChooserOption option : options) {
            model.addElement(option);
            maxOffset = Math.max(maxOffset, option.rangeStream().mapToInt(TextRange::getEndOffset).max().orElse(-1));
        }
        JBList list = new JBList(model);
        list.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                this.setText(((ChooserOption)value).getText());
                return this;
            }
        });
        list.addListSelectionListener(e -> {
            ChooserOption selectedValue = (ChooserOption)list.getSelectedValue();
            if (selectedValue == null) {
                return;
            }
            this.dropHighlighters();
            selectedValue.rangeStream().forEach(x -> {
                RangeHighlighter highlighter = this.myEditor.getMarkupModel().addRangeHighlighter(x.getStartOffset(), x.getEndOffset(), 6001, this.myAttributes, HighlighterTargetArea.EXACT_RANGE);
                this.myRangeHighlighters.add(highlighter);
            });
        });
        JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(StreamDebuggerBundle.message("multiple.chains.popup.title", new Object[0])).setMovable(true).setResizable(false).setRequestFocus(true).setItemChosenCallback(() -> callBack.chosen((ChooserOption)list.getSelectedValue())).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ElementChooserImpl.this.dropHighlighters();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/streams/ui/impl/ElementChooserImpl$2", "onClosed"));
            }
        }).createPopup();
        if (maxOffset != -1) {
            this.myEditor.getCaretModel().moveToOffset(maxOffset);
        }
        popup.showInBestPositionFor(this.myEditor);
    }

    private void dropHighlighters() {
        this.myRangeHighlighters.forEach(RangeMarker::dispose);
        this.myRangeHighlighters.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callBack";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/streams/ui/impl/ElementChooserImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

