/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl.handler.unified;

import com.intellij.debugger.streams.trace.dsl.CodeBlock;
import com.intellij.debugger.streams.trace.dsl.CodeContext;
import com.intellij.debugger.streams.trace.dsl.Dsl;
import com.intellij.debugger.streams.trace.dsl.Expression;
import com.intellij.debugger.streams.trace.dsl.Lambda;
import com.intellij.debugger.streams.trace.dsl.LambdaBody;
import com.intellij.debugger.streams.trace.dsl.MapVariable;
import com.intellij.debugger.streams.trace.dsl.VariableDeclaration;
import com.intellij.debugger.streams.trace.dsl.impl.TextExpression;
import com.intellij.debugger.streams.trace.impl.handler.type.GenericType;
import com.intellij.debugger.streams.trace.impl.handler.unified.HandlerBase;
import com.intellij.debugger.streams.wrapper.IntermediateStreamCall;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0014H\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0014H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/intellij/debugger/streams/trace/impl/handler/unified/PeekTraceHandler;", "Lcom/intellij/debugger/streams/trace/impl/handler/unified/HandlerBase$Intermediate;", "num", "", "callName", "", "myTypeBefore", "Lcom/intellij/debugger/streams/trace/impl/handler/type/GenericType;", "typeAfter", "dsl", "Lcom/intellij/debugger/streams/trace/dsl/Dsl;", "<init>", "(ILjava/lang/String;Lcom/intellij/debugger/streams/trace/impl/handler/type/GenericType;Lcom/intellij/debugger/streams/trace/impl/handler/type/GenericType;Lcom/intellij/debugger/streams/trace/dsl/Dsl;)V", "beforeMap", "Lcom/intellij/debugger/streams/trace/dsl/MapVariable;", "getBeforeMap", "()Lcom/intellij/debugger/streams/trace/dsl/MapVariable;", "afterMap", "getAfterMap", "additionalVariablesDeclaration", "", "Lcom/intellij/debugger/streams/trace/dsl/VariableDeclaration;", "prepareResult", "Lcom/intellij/debugger/streams/trace/dsl/CodeBlock;", "getResultExpression", "Lcom/intellij/debugger/streams/trace/dsl/Expression;", "additionalCallsBefore", "Lcom/intellij/debugger/streams/wrapper/IntermediateStreamCall;", "additionalCallsAfter", "intellij.java.debugger.streams"})
public class PeekTraceHandler
extends HandlerBase.Intermediate {
    @NotNull
    private final GenericType myTypeBefore;
    @NotNull
    private final MapVariable beforeMap;
    @NotNull
    private final MapVariable afterMap;

    public PeekTraceHandler(int num, @NotNull String callName, @NotNull GenericType myTypeBefore, @NotNull GenericType typeAfter, @NotNull Dsl dsl) {
        Intrinsics.checkNotNullParameter((Object)callName, (String)"callName");
        Intrinsics.checkNotNullParameter((Object)myTypeBefore, (String)"myTypeBefore");
        Intrinsics.checkNotNullParameter((Object)typeAfter, (String)"typeAfter");
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        super(dsl);
        this.myTypeBefore = myTypeBefore;
        this.beforeMap = dsl.linkedMap(dsl.getTypes().getINT(), this.myTypeBefore, callName + "Peek" + num + "Before");
        this.afterMap = dsl.linkedMap(dsl.getTypes().getINT(), typeAfter, callName + "Peek" + num + "After");
    }

    @NotNull
    public final MapVariable getBeforeMap() {
        return this.beforeMap;
    }

    @NotNull
    public final MapVariable getAfterMap() {
        return this.afterMap;
    }

    @Override
    @NotNull
    public List<VariableDeclaration> additionalVariablesDeclaration() {
        Object[] objectArray = new VariableDeclaration[]{MapVariable.defaultDeclaration$default(this.beforeMap, false, 1, null), MapVariable.defaultDeclaration$default(this.afterMap, false, 1, null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public CodeBlock prepareResult() {
        return this.getDsl().block((Function1<? super CodeContext, Unit>)((Function1)arg_0 -> PeekTraceHandler.prepareResult$lambda$0(this, arg_0)));
    }

    @Override
    @NotNull
    public Expression getResultExpression() {
        Expression[] expressionArray = new Expression[]{new TextExpression("beforeArray"), new TextExpression("afterArray")};
        return this.getDsl().newArray(this.getDsl().getTypes().getANY(), expressionArray);
    }

    @Override
    @NotNull
    public List<IntermediateStreamCall> additionalCallsBefore() {
        Lambda lambda = this.getDsl().lambda("x", (Function2<? super LambdaBody, ? super Expression, Unit>)((Function2)(arg_0, arg_1) -> PeekTraceHandler.additionalCallsBefore$lambda$1(this, arg_0, arg_1)));
        return CollectionsKt.listOf((Object)this.getDsl().createPeekCall(this.myTypeBefore, lambda));
    }

    @Override
    @NotNull
    public List<IntermediateStreamCall> additionalCallsAfter() {
        Lambda lambda = this.getDsl().lambda("x", (Function2<? super LambdaBody, ? super Expression, Unit>)((Function2)(arg_0, arg_1) -> PeekTraceHandler.additionalCallsAfter$lambda$2(this, arg_0, arg_1)));
        return CollectionsKt.listOf((Object)this.getDsl().createPeekCall(this.myTypeBefore, lambda));
    }

    private static final Unit prepareResult$lambda$0(PeekTraceHandler this$0, CodeContext $this$block) {
        Intrinsics.checkNotNullParameter((Object)$this$block, (String)"$this$block");
        $this$block.add(this$0.beforeMap.convertToArray($this$block, "beforeArray"));
        $this$block.add(this$0.afterMap.convertToArray($this$block, "afterArray"));
        return Unit.INSTANCE;
    }

    private static final Unit additionalCallsBefore$lambda$1(PeekTraceHandler this$0, LambdaBody $this$lambda, Expression it) {
        Intrinsics.checkNotNullParameter((Object)$this$lambda, (String)"$this$lambda");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$lambda.doReturn(this$0.beforeMap.set(this$0.getDsl().currentTime(), $this$lambda.getLambdaArg()));
        return Unit.INSTANCE;
    }

    private static final Unit additionalCallsAfter$lambda$2(PeekTraceHandler this$0, LambdaBody $this$lambda, Expression it) {
        Intrinsics.checkNotNullParameter((Object)$this$lambda, (String)"$this$lambda");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$lambda.doReturn(this$0.afterMap.set(this$0.getDsl().currentTime(), $this$lambda.getLambdaArg()));
        return Unit.INSTANCE;
    }
}

