/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.interfaces.NormalizedStringDistance;
import info.debatty.java.stringsimilarity.interfaces.NormalizedStringSimilarity;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public class RatcliffObershelp
implements NormalizedStringSimilarity,
NormalizedStringDistance {
    @Override
    public final double similarity(String s1, String s2) {
        if (s1 == null) {
            throw new NullPointerException("s1 must not be null");
        }
        if (s2 == null) {
            throw new NullPointerException("s2 must not be null");
        }
        if (s1.equals(s2)) {
            return 1.0;
        }
        List<String> matches = RatcliffObershelp.getMatchList(s1, s2);
        int sum_of_matches = 0;
        for (String match2 : matches) {
            sum_of_matches += match2.length();
        }
        return 2.0 * (double)sum_of_matches / (double)(s1.length() + s2.length());
    }

    @Override
    public final double distance(String s1, String s2) {
        return 1.0 - this.similarity(s1, s2);
    }

    private static List<String> getMatchList(String s1, String s2) {
        ArrayList<String> list2 = new ArrayList<String>();
        String match2 = RatcliffObershelp.frontMaxMatch(s1, s2);
        if (match2.length() > 0) {
            String frontsource = s1.substring(0, s1.indexOf(match2));
            String fronttarget = s2.substring(0, s2.indexOf(match2));
            List<String> frontqueue = RatcliffObershelp.getMatchList(frontsource, fronttarget);
            String endsource = s1.substring(s1.indexOf(match2) + match2.length());
            String endtarget = s2.substring(s2.indexOf(match2) + match2.length());
            List<String> endqueue = RatcliffObershelp.getMatchList(endsource, endtarget);
            list2.add(match2);
            list2.addAll(frontqueue);
            list2.addAll(endqueue);
        }
        return list2;
    }

    private static String frontMaxMatch(String s1, String s2) {
        int longest = 0;
        String longestsubstring = "";
        for (int i = 0; i < s1.length(); ++i) {
            for (int j = i + 1; j <= s1.length(); ++j) {
                String substring = s1.substring(i, j);
                if (!s2.contains(substring) || substring.length() <= longest) continue;
                longest = substring.length();
                longestsubstring = substring;
            }
        }
        return longestsubstring;
    }
}

