/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.events.DomEvent;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.ui.AbstractDomElementComponent;
import com.intellij.util.xml.ui.BasicDomElementComponent;
import com.intellij.util.xml.ui.CaptionComponent;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.CommittableUtil;
import com.intellij.util.xml.ui.CompositeCommittable;
import com.intellij.util.xml.ui.DomUIControl;
import com.intellij.util.xml.ui.DomUIFactory;
import com.intellij.util.xml.ui.DomUINavigationProvider;
import com.intellij.util.xml.ui.Highlightable;
import com.intellij.util.xml.ui.PerspectiveFileEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomFileEditor<T extends BasicDomElementComponent>
extends PerspectiveFileEditor
implements CommittablePanel,
Highlightable {
    @Nls
    private final String myName;
    private final Factory<? extends T> myComponentFactory;
    private T myComponent;

    public DomFileEditor(DomElement element, @Nls String name, T component) {
        this(element.getManager().getProject(), DomUtil.getFile(element).getVirtualFile(), name, component);
    }

    public DomFileEditor(Project project2, VirtualFile file, @Nls String name, T component) {
        this(project2, file, name, () -> component);
    }

    public DomFileEditor(Project project2, VirtualFile file, @Nls String name, Factory<? extends T> component) {
        super(project2, file);
        this.myComponentFactory = component;
        this.myName = name;
        DomElementAnnotationsManager.getInstance(project2).addHighlightingListener(new DomElementAnnotationsManager.DomHighlightingListener(){

            @Override
            public void highlightingFinished(@NotNull DomFileElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DomFileEditor.this.isInitialised() && DomFileEditor.this.getComponent().isShowing() && element.isValid()) {
                    DomFileEditor.this.updateHighlighting();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/ui/DomFileEditor$1", "highlightingFinished"));
            }
        }, this);
    }

    @Override
    public void updateHighlighting() {
        if (this.checkIsValid()) {
            CommittableUtil.updateHighlighting(this.myComponent);
        }
    }

    @Override
    public void commit() {
        if (this.checkIsValid() && this.isInitialised()) {
            this.setShowing(false);
            try {
                ((CommittableUtil)this.getProject().getService(CommittableUtil.class)).commit((Committable)this.myComponent);
            }
            finally {
                this.setShowing(true);
            }
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        this.ensureInitialized();
        return this.myComponent.getComponent();
    }

    protected final T getDomComponent() {
        return this.myComponent;
    }

    @Override
    @NotNull
    protected JComponent createCustomComponent() {
        MnemonicHelper.init((Component)this.getComponent());
        this.myComponent = (BasicDomElementComponent)this.myComponentFactory.create();
        DomUIFactory.getDomUIFactory().setupErrorOutdatingUserActivityWatcher(this, this.getDomElement());
        DomManager.getDomManager(this.getProject()).addDomEventListener(new DomEventListener(){

            @Override
            public void eventOccured(@NotNull DomEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                DomFileEditor.this.checkIsValid();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/xml/ui/DomFileEditor$2", "eventOccured"));
            }
        }, this);
        Disposer.register((Disposable)this, this.myComponent);
        JComponent jComponent = this.myComponent.getComponent();
        if (jComponent == null) {
            DomFileEditor.$$$reportNull$$$0(0);
        }
        return jComponent;
    }

    @NotNull
    public final String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            DomFileEditor.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    protected DomElement getSelectedDomElement() {
        if (this.myComponent == null) {
            return null;
        }
        return DomUINavigationProvider.findDomElement(this.myComponent);
    }

    @Override
    protected void setSelectedDomElement(DomElement domElement) {
        DomUIControl domControl = DomUINavigationProvider.findDomControl(this.myComponent, domElement);
        if (domControl != null) {
            domControl.navigate(domElement);
        }
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        this.ensureInitialized();
        return DomUIFactory.getDomUIFactory().createDomHighlighter(this.getProject(), this, this.getDomElement());
    }

    private DomElement getDomElement() {
        return ((AbstractDomElementComponent)this.myComponent).getDomElement();
    }

    @Override
    public boolean isValid() {
        return super.isValid() && (!this.isInitialised() || this.getDomElement().isValid());
    }

    @Override
    public void reset() {
        if (this.checkIsValid()) {
            ((CompositeCommittable)this.myComponent).reset();
        }
    }

    public static BasicDomElementComponent createComponentWithCaption(CommittablePanel committablePanel, CaptionComponent captionComponent, @Nullable DomElement element) {
        final JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)captionComponent, "North");
        panel.add((Component)(element != null && element.isValid() ? committablePanel.getComponent() : new JPanel()), "Center");
        BasicDomElementComponent component = new BasicDomElementComponent(element){

            @Override
            public JComponent getComponent() {
                return panel;
            }
        };
        component.addComponent(committablePanel);
        component.addComponent(captionComponent);
        return component;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/xml/ui/DomFileEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

