/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.project.ProjectKt;
import com.intellij.spellchecker.BundledDictionaryProvider;
import com.intellij.spellchecker.CustomDictFileListener;
import com.intellij.spellchecker.DictionaryLayer;
import com.intellij.spellchecker.FileLoader;
import com.intellij.spellchecker.ProjectDictionaryLayer;
import com.intellij.spellchecker.SpellCheckerManagerKt;
import com.intellij.spellchecker.dictionary.CustomDictionaryProvider;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.DictionaryChecker;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.ProjectDictionary;
import com.intellij.spellchecker.dictionary.RuntimeDictionaryProvider;
import com.intellij.spellchecker.dictionary.UserDictionary;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import com.intellij.spellchecker.engine.SuggestionProvider;
import com.intellij.spellchecker.grazie.GrazieSpellCheckerEngine;
import com.intellij.spellchecker.grazie.GrazieSuggestionProvider;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.state.AppDictionaryState;
import com.intellij.spellchecker.state.DictionaryStateListener;
import com.intellij.spellchecker.state.ProjectDictionaryState;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.util.EventDispatcher;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\n\b\u0007\u0018\u0000 I2\u00020\u0001:\u0001IB\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010 \u001a\u00020!H\u0003J\u0006\u0010\"\u001a\u00020!J\u0016\u0010#\u001a\u00020!2\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0%J\u0010\u0010*\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0010\u0010+\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0015\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b.J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u000fJ\u0010\u00102\u001a\u0002002\u0006\u00101\u001a\u00020\u000fH\u0002J\u0016\u00103\u001a\u00020!2\u0006\u00101\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003J1\u00103\u001a\u00020!2\u0006\u00101\u001a\u00020\u000f2\b\u00104\u001a\u0004\u0018\u0001052\u0006\u0010\u0002\u001a\u00020\u00032\b\u00106\u001a\u0004\u0018\u000107H\u0000\u00a2\u0006\u0002\b8J\u0018\u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020\r2\u0006\u00101\u001a\u00020\u000fH\u0002J\u0018\u0010;\u001a\u00020!2\u0006\u0010:\u001a\u00020\r2\u0006\u0010<\u001a\u00020\u000fH\u0002J\u0010\u0010=\u001a\u00020!2\u0006\u0010:\u001a\u00020\rH\u0002J\u0014\u0010>\u001a\u00020!2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u000f0@J\u0014\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000f0%2\u0006\u0010B\u001a\u00020\u000fJ\b\u0010C\u001a\u00020!H\u0016J\u000e\u0010D\u001a\u00020!2\u0006\u0010E\u001a\u00020\u000fJ\u0018\u0010F\u001a\u00020!2\u0006\u0010G\u001a\u00020\u00162\b\u0010H\u001a\u0004\u0018\u00010\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R!\u0010\u0014\u001a\u0015\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0015\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a8\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006J"}, d2={"Lcom/intellij/spellchecker/SpellCheckerManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectDictionary", "Lcom/intellij/spellchecker/dictionary/ProjectDictionary;", "appDictionary", "Lcom/intellij/spellchecker/dictionary/EditableDictionary;", "projectDictionaryPath", "", "getProjectDictionaryPath$intellij_spellchecker", "()Ljava/lang/String;", "appDictionaryPath", "getAppDictionaryPath$intellij_spellchecker", "userDictionaryListenerEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/spellchecker/state/DictionaryStateListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "value", "Lcom/intellij/spellchecker/engine/SpellCheckerEngine;", "spellChecker", "getSpellChecker", "()Lcom/intellij/spellchecker/engine/SpellCheckerEngine;", "suggestionProvider", "Lcom/intellij/spellchecker/engine/SuggestionProvider;", "ensureSpellerIsLoaded", "", "fullConfigurationReload", "updateBundledDictionaries", "removedDictionaries", "", "userDictionaryWords", "", "getUserDictionaryWords", "()Ljava/util/Set;", "fillEngineDictionary", "initUserDictionaries", "loadDictionary", "path", "loadDictionary$intellij_spellchecker", "hasProblem", "", "word", "isCorrectExtensionWord", "acceptWordAsCorrect", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "dictionaryLayer", "Lcom/intellij/spellchecker/DictionaryLayer;", "acceptWordAsCorrect$intellij_spellchecker", "addWordToDictionary", "dictionary", "removeWordFromDictionary", "transformed", "fireDictionaryChanged", "updateUserDictionary", "words", "", "getSuggestions", "text", "dispose", "openDictionaryInEditor", "dictPath", "addUserDictionaryChangedListener", "listener", "parentDisposable", "Companion", "intellij.spellchecker"})
@SourceDebugExtension(value={"SMAP\nSpellCheckerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpellCheckerManager.kt\ncom/intellij/spellchecker/SpellCheckerManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,460:1\n1#2:461\n31#3,2:462\n31#3,2:464\n1755#4,3:466\n*S KotlinDebug\n*F\n+ 1 SpellCheckerManager.kt\ncom/intellij/spellchecker/SpellCheckerManager\n*L\n128#1:462,2\n207#1:464,2\n232#1:466,3\n*E\n"})
public final class SpellCheckerManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @ApiStatus.Internal
    @NotNull
    private final Project project;
    @Nullable
    private ProjectDictionary projectDictionary;
    @Nullable
    private EditableDictionary appDictionary;
    @NotNull
    private final String projectDictionaryPath;
    @NotNull
    private final String appDictionaryPath;
    @NotNull
    private final EventDispatcher<DictionaryStateListener> userDictionaryListenerEventDispatcher;
    @ApiStatus.Internal
    @Nullable
    private SpellCheckerEngine spellChecker;
    @Nullable
    private SuggestionProvider suggestionProvider;
    private static final int MAX_METRICS = 1;
    @NotNull
    private static final String PROJECT_DICTIONARY_PATH;
    @NotNull
    private static final String CACHED_DICTIONARY_FILE = "spellchecker-dictionary.xml";

    @ApiStatus.Internal
    public SpellCheckerManager(@NotNull Project project2, @NotNull CoroutineScope coroutineScope) {
        VirtualFile projectStoreDir;
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project2;
        EventDispatcher eventDispatcher = EventDispatcher.create(DictionaryStateListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.userDictionaryListenerEventDispatcher = eventDispatcher;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.ensureSpellerIsLoaded();
        }
        this.fullConfigurationReload();
        VirtualFile virtualFile2 = this.project.getBaseDir();
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            virtualFile = ProjectKt.getProjectStoreDirectory((VirtualFile)it);
        } else {
            virtualFile = null;
        }
        VirtualFile virtualFile3 = projectStoreDir = virtualFile;
        this.projectDictionaryPath = virtualFile3 == null ? "" : virtualFile3.getPath() + File.separator + PROJECT_DICTIONARY_PATH;
        this.appDictionaryPath = PathManager.getOptionsPath() + File.separator + CACHED_DICTIONARY_FILE;
        LocalFileSystem.getInstance().addVirtualFileListener((VirtualFileListener)new CustomDictFileListener(this.project, this), (Disposable)this);
        SpellCheckerManagerKt.access$getBUNDLED_EP_NAME$p().addChangeListener(() -> SpellCheckerManager._init_$lambda$1(this), (Disposable)this);
        RuntimeDictionaryProvider.EP_NAME.addChangeListener(coroutineScope, () -> SpellCheckerManager._init_$lambda$2(this));
        CustomDictionaryProvider.EP_NAME.addChangeListener(coroutineScope, () -> SpellCheckerManager._init_$lambda$3(this));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getProjectDictionaryPath$intellij_spellchecker() {
        return this.projectDictionaryPath;
    }

    @NotNull
    public final String getAppDictionaryPath$intellij_spellchecker() {
        return this.appDictionaryPath;
    }

    @Nullable
    public final SpellCheckerEngine getSpellChecker() {
        return this.spellChecker;
    }

    @TestOnly
    private final void ensureSpellerIsLoaded() {
        boolean bl = ApplicationManager.getApplication().isUnitTestMode();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SpellCheckerManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$serviceAsync$iv = (ComponentManager)this.this$0.getProject();
                        $i$f$serviceAsync = false;
                        Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                        this.label = 1;
                        v0 = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(GrazieSpellCheckerEngine.class, (Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        $i$f$serviceAsync = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        this.label = 2;
                        v1 = ((GrazieSpellCheckerEngine)v0).waitForSpeller((Continuation<? super Unit>)((Continuation)this));
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl26
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl26:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public final void fullConfigurationReload() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GrazieSpellCheckerEngine> serviceClass$iv = GrazieSpellCheckerEngine.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GrazieSpellCheckerEngine spellChecker = (GrazieSpellCheckerEngine)object;
        this.spellChecker = spellChecker;
        this.suggestionProvider = new GrazieSuggestionProvider(spellChecker);
        this.fillEngineDictionary(spellChecker);
    }

    public final void updateBundledDictionaries(@NotNull List<String> removedDictionaries) {
        Intrinsics.checkNotNullParameter(removedDictionaries, (String)"removedDictionaries");
        SpellCheckerEngine spellCheckerEngine = this.spellChecker;
        Intrinsics.checkNotNull((Object)spellCheckerEngine);
        SpellCheckerEngine spellChecker = spellCheckerEngine;
        for (BundledDictionaryProvider provider : SpellCheckerManagerKt.access$getBUNDLED_EP_NAME$p().getExtensionList()) {
            Iterator iterator = ArrayIteratorKt.iterator((Object[])provider.getBundledDictionaries());
            while (iterator.hasNext()) {
                String dictionary = (String)iterator.next();
                if (spellChecker.isDictionaryLoad(dictionary)) continue;
                Intrinsics.checkNotNull((Object)dictionary);
                SpellCheckerManagerKt.access$loadBundledDictionary(provider, dictionary, spellChecker);
            }
        }
        SpellCheckerSettings spellCheckerSettings = SpellCheckerSettings.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)spellCheckerSettings, (String)"getInstance(...)");
        SpellCheckerSettings settings = spellCheckerSettings;
        for (RuntimeDictionaryProvider provider : RuntimeDictionaryProvider.EP_NAME.getExtensionList()) {
            Iterator iterator = ArrayIteratorKt.iterator((Object[])provider.getDictionaries());
            while (iterator.hasNext()) {
                Dictionary dictionary = (Dictionary)iterator.next();
                boolean dictionaryShouldBeLoad = !settings.getRuntimeDisabledDictionariesNames().contains(dictionary.getName());
                boolean dictionaryIsLoad = spellChecker.isDictionaryLoad(dictionary.getName());
                if (dictionaryIsLoad && !dictionaryShouldBeLoad) {
                    spellChecker.removeDictionary(dictionary.getName());
                    continue;
                }
                if (dictionaryIsLoad || !dictionaryShouldBeLoad) continue;
                spellChecker.addDictionary(dictionary);
            }
        }
        if (settings.getCustomDictionariesPaths() != null) {
            for (String dictionary : settings.getCustomDictionariesPaths()) {
                if (spellChecker.isDictionaryLoad(dictionary)) continue;
                Intrinsics.checkNotNull((Object)dictionary);
                this.loadDictionary$intellij_spellchecker(dictionary);
            }
        }
        if (!removedDictionaries.isEmpty()) {
            Iterator<Object> iterator = removedDictionaries.iterator();
            while (iterator.hasNext()) {
                String name;
                String string2 = name = (String)iterator.next();
                Intrinsics.checkNotNull((Object)string2);
                spellChecker.removeDictionary(string2);
            }
        }
        Companion.restartInspections();
    }

    @NotNull
    public final Set<String> getUserDictionaryWords() {
        ProjectDictionary projectDictionary = this.projectDictionary;
        Intrinsics.checkNotNull((Object)projectDictionary);
        Set<String> set = projectDictionary.getEditableWords();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getEditableWords(...)");
        EditableDictionary editableDictionary = this.appDictionary;
        Intrinsics.checkNotNull((Object)editableDictionary);
        Set<String> set2 = editableDictionary.getEditableWords();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"getEditableWords(...)");
        return SetsKt.plus(set, (Iterable)set2);
    }

    private final void fillEngineDictionary(SpellCheckerEngine spellChecker) {
        spellChecker.reset();
        SpellCheckerSettings spellCheckerSettings = SpellCheckerSettings.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)spellCheckerSettings, (String)"getInstance(...)");
        SpellCheckerSettings settings = spellCheckerSettings;
        SpellCheckerManagerKt.access$loadBundledDictionaries(spellChecker);
        for (RuntimeDictionaryProvider provider : RuntimeDictionaryProvider.EP_NAME.getExtensionList()) {
            Iterator iterator = ArrayIteratorKt.iterator((Object[])provider.getDictionaries());
            while (iterator.hasNext()) {
                Dictionary dictionary = (Dictionary)iterator.next();
                if (settings.getRuntimeDisabledDictionariesNames().contains(dictionary.getName())) continue;
                spellChecker.addDictionary(dictionary);
            }
        }
        if (settings.getCustomDictionariesPaths() != null) {
            for (String path : settings.getCustomDictionariesPaths()) {
                Intrinsics.checkNotNull((Object)path);
                this.loadDictionary$intellij_spellchecker(path);
            }
        }
        this.initUserDictionaries(spellChecker);
    }

    private final void initUserDictionaries(SpellCheckerEngine spellChecker) {
        AppDictionaryState appDictionaryState = AppDictionaryState.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)appDictionaryState, (String)"getInstance(...)");
        AppDictionaryState appDictionaryState2 = appDictionaryState;
        appDictionaryState2.addAppDictListener(SpellCheckerManager::initUserDictionaries$lambda$4, this);
        if (appDictionaryState2.getDictionary() == null) {
            appDictionaryState2.setDictionary(new UserDictionary("cached"));
        }
        EditableDictionary editableDictionary = this.appDictionary = appDictionaryState2.getDictionary();
        Intrinsics.checkNotNull((Object)editableDictionary);
        spellChecker.addModifiableDictionary(editableDictionary);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ProjectDictionaryState> serviceClass$iv = ProjectDictionaryState.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ProjectDictionaryState dictionaryState = (ProjectDictionaryState)object;
        dictionaryState.addProjectDictListener(SpellCheckerManager::initUserDictionaries$lambda$5);
        ProjectDictionary projectDictionary = this.projectDictionary = dictionaryState.getProjectDictionary();
        Intrinsics.checkNotNull((Object)projectDictionary);
        projectDictionary.setActiveName(System.getProperty("user.name"));
        ProjectDictionary projectDictionary2 = this.projectDictionary;
        Intrinsics.checkNotNull((Object)projectDictionary2);
        spellChecker.addModifiableDictionary(projectDictionary2);
    }

    public final void loadDictionary$intellij_spellchecker(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CustomDictionaryProvider dictionaryProvider = SpellCheckerManager.Companion.findApplicable(path);
        if (dictionaryProvider == null) {
            SpellCheckerEngine spellCheckerEngine = this.spellChecker;
            Intrinsics.checkNotNull((Object)spellCheckerEngine);
            spellCheckerEngine.loadDictionary(new FileLoader(path));
        } else {
            Dictionary dictionary = dictionaryProvider.get(path);
            if (dictionary != null) {
                SpellCheckerEngine spellCheckerEngine = this.spellChecker;
                Intrinsics.checkNotNull((Object)spellCheckerEngine);
                spellCheckerEngine.addDictionary(dictionary);
            }
        }
    }

    public final boolean hasProblem(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        SpellCheckerEngine spellCheckerEngine = this.spellChecker;
        Intrinsics.checkNotNull((Object)spellCheckerEngine);
        return !spellCheckerEngine.isCorrect(word) && !this.isCorrectExtensionWord(word);
    }

    private final boolean isCorrectExtensionWord(String word) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = DictionaryChecker.EP_NAME.getExtensionList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DictionaryChecker it = (DictionaryChecker)element$iv;
                    boolean bl2 = false;
                    if (!it.isCorrect(this.project, word)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void acceptWordAsCorrect(@NotNull String word, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.acceptWordAsCorrect$intellij_spellchecker(word, null, project2, new ProjectDictionaryLayer(project2));
    }

    public final void acceptWordAsCorrect$intellij_spellchecker(@NotNull String word, @Nullable VirtualFile file, @NotNull Project project2, @Nullable DictionaryLayer dictionaryLayer) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (dictionaryLayer == null) {
            return;
        }
        SpellCheckerEngine spellCheckerEngine = this.spellChecker;
        Intrinsics.checkNotNull((Object)spellCheckerEngine);
        String string2 = spellCheckerEngine.getTransformation().transform(word);
        if (string2 == null) {
            return;
        }
        String transformed = string2;
        EditableDictionary dictionary = dictionaryLayer.getDictionary();
        if (file != null) {
            WriteCommandAction.writeCommandAction((Project)project2).run(() -> SpellCheckerManager.acceptWordAsCorrect$lambda$7(project2, file, this, dictionary, transformed));
        }
        this.addWordToDictionary(dictionary, transformed);
    }

    private final void addWordToDictionary(EditableDictionary dictionary, String word) {
        dictionary.addToDictionary(word);
        this.fireDictionaryChanged(dictionary);
    }

    private final void removeWordFromDictionary(EditableDictionary dictionary, String transformed) {
        dictionary.removeFromDictionary(transformed);
        this.fireDictionaryChanged(dictionary);
    }

    private final void fireDictionaryChanged(EditableDictionary dictionary) {
        ((DictionaryStateListener)this.userDictionaryListenerEventDispatcher.getMulticaster()).dictChanged(dictionary);
        Companion.restartInspections();
        SaveAndSyncHandler.Companion.getInstance().scheduleProjectSave(this.project, true);
    }

    public final void updateUserDictionary(@NotNull Collection<String> words2) {
        Intrinsics.checkNotNullParameter(words2, (String)"words");
        List addedToProjectWords = CollectionsKt.minus((Iterable)words2, (Iterable)this.getUserDictionaryWords());
        ProjectDictionary projectDictionary = this.projectDictionary;
        Intrinsics.checkNotNull((Object)projectDictionary);
        ProjectDictionary projectDictionary2 = projectDictionary;
        for (String word : addedToProjectWords) {
            projectDictionary2.addToDictionary(word);
        }
        HashSet wordSet = CollectionsKt.toHashSet((Iterable)words2);
        Set<String> set = projectDictionary2.getEditableWords();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getEditableWords(...)");
        Set deletedFromProjectWords = SetsKt.minus(set, (Iterable)wordSet);
        for (String word : deletedFromProjectWords) {
            projectDictionary2.removeFromDictionary(word);
        }
        if (addedToProjectWords.size() + deletedFromProjectWords.size() > 0) {
            ((DictionaryStateListener)this.userDictionaryListenerEventDispatcher.getMulticaster()).dictChanged(projectDictionary2);
        }
        EditableDictionary editableDictionary = this.appDictionary;
        Intrinsics.checkNotNull((Object)editableDictionary);
        Set<String> set2 = editableDictionary.getEditableWords();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"getEditableWords(...)");
        Set deletedFromApplicationWords = SetsKt.minus(set2, (Iterable)wordSet);
        for (String word : deletedFromApplicationWords) {
            EditableDictionary editableDictionary2 = this.appDictionary;
            Intrinsics.checkNotNull((Object)editableDictionary2);
            editableDictionary2.removeFromDictionary(word);
        }
        if (!deletedFromApplicationWords.isEmpty()) {
            ((DictionaryStateListener)this.userDictionaryListenerEventDispatcher.getMulticaster()).dictChanged(this.appDictionary);
        }
        Companion.restartInspections();
    }

    @NotNull
    public final List<String> getSuggestions(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        int correctionLimit = Registry.Companion.intValue("spellchecker.corrections.limit", 5);
        SuggestionProvider suggestionProvider = this.suggestionProvider;
        Intrinsics.checkNotNull((Object)suggestionProvider);
        List<String> list2 = suggestionProvider.getSuggestions(text2, correctionLimit, 1);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getSuggestions(...)");
        return list2;
    }

    public void dispose() {
    }

    public final void openDictionaryInEditor(@NotNull String dictPath) {
        block1: {
            VirtualFile file;
            Intrinsics.checkNotNullParameter((Object)dictPath, (String)"dictPath");
            VirtualFile virtualFile = file = ((CharSequence)dictPath).length() == 0 ? null : LocalFileSystem.getInstance().refreshAndFindFileByPath(dictPath);
            if (file == null) {
                String title = SpellCheckerBundle.message("dictionary.not.found.title", new Object[0]);
                Object[] objectArray = new Object[]{dictPath};
                String message = SpellCheckerBundle.message("dictionary.not.found", objectArray);
                Messages.showMessageDialog((Project)this.project, (String)message, (String)title, (Icon)Messages.getWarningIcon());
                return;
            }
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
            if (fileEditorManager == null) break block1;
            fileEditorManager.openFile(file, true);
        }
    }

    public final void addUserDictionaryChangedListener(@NotNull DictionaryStateListener listener2, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.userDictionaryListenerEventDispatcher.addListener((EventListener)listener2);
        Disposable disposable = parentDisposable;
        Intrinsics.checkNotNull((Object)disposable);
        Disposer.register((Disposable)disposable, () -> SpellCheckerManager.addUserDictionaryChangedListener$lambda$8(this, listener2));
    }

    private static final void _init_$lambda$1(SpellCheckerManager this$0) {
        SpellCheckerEngine spellCheckerEngine = this$0.spellChecker;
        Intrinsics.checkNotNull((Object)spellCheckerEngine);
        this$0.fillEngineDictionary(spellCheckerEngine);
    }

    private static final void _init_$lambda$2(SpellCheckerManager this$0) {
        SpellCheckerEngine spellCheckerEngine = this$0.spellChecker;
        Intrinsics.checkNotNull((Object)spellCheckerEngine);
        this$0.fillEngineDictionary(spellCheckerEngine);
    }

    private static final void _init_$lambda$3(SpellCheckerManager this$0) {
        SpellCheckerEngine spellCheckerEngine = this$0.spellChecker;
        Intrinsics.checkNotNull((Object)spellCheckerEngine);
        this$0.fillEngineDictionary(spellCheckerEngine);
    }

    private static final void initUserDictionaries$lambda$4(EditableDictionary it) {
        Companion.restartInspections();
    }

    private static final void initUserDictionaries$lambda$5(EditableDictionary it) {
        Companion.restartInspections();
    }

    private static final void acceptWordAsCorrect$lambda$7(Project $project, VirtualFile $file, SpellCheckerManager this$0, EditableDictionary $dictionary, String $transformed) {
        VirtualFile[] virtualFileArray = new VirtualFile[]{$file};
        VirtualFile[] virtualFileArray2 = virtualFileArray;
        UndoManager.getInstance((Project)$project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(this$0, $dictionary, $transformed, virtualFileArray2){
            final /* synthetic */ SpellCheckerManager this$0;
            final /* synthetic */ EditableDictionary $dictionary;
            final /* synthetic */ String $transformed;
            {
                this.this$0 = $receiver;
                this.$dictionary = $dictionary;
                this.$transformed = $transformed;
                super($super_call_param$1);
            }

            public void undo() {
                SpellCheckerManager.access$removeWordFromDictionary(this.this$0, this.$dictionary, this.$transformed);
            }

            public void redo() {
                SpellCheckerManager.access$addWordToDictionary(this.this$0, this.$dictionary, this.$transformed);
            }
        });
    }

    private static final void addUserDictionaryChangedListener$lambda$8(SpellCheckerManager this$0, DictionaryStateListener $listener) {
        this$0.userDictionaryListenerEventDispatcher.removeListener((EventListener)$listener);
    }

    @JvmStatic
    @NotNull
    public static final SpellCheckerManager getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @NotNull
    public static final List<String> getBundledDictionaries() {
        return Companion.getBundledDictionaries();
    }

    @NotNull
    public static final List<Dictionary> getRuntimeDictionaries() {
        return Companion.getRuntimeDictionaries();
    }

    public static final /* synthetic */ void access$removeWordFromDictionary(SpellCheckerManager $this, EditableDictionary dictionary, String transformed) {
        $this.removeWordFromDictionary(dictionary, transformed);
    }

    public static final /* synthetic */ void access$addWordToDictionary(SpellCheckerManager $this, EditableDictionary dictionary, String word) {
        $this.addWordToDictionary(dictionary, word);
    }

    static {
        String string2 = System.getProperty("user.name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        PROJECT_DICTIONARY_PATH = "dictionaries" + File.separator + StringsKt.replace$default((String)string2, (char)'.', (char)'_', (boolean)false, (int)4, null) + ".xml";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0003\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\u0003\u001a\u0004\b\u0015\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/intellij/spellchecker/SpellCheckerManager$Companion;", "", "<init>", "()V", "MAX_METRICS", "", "PROJECT_DICTIONARY_PATH", "", "CACHED_DICTIONARY_FILE", "getInstance", "Lcom/intellij/spellchecker/SpellCheckerManager;", "project", "Lcom/intellij/openapi/project/Project;", "bundledDictionaries", "", "getBundledDictionaries$annotations", "getBundledDictionaries", "()Ljava/util/List;", "runtimeDictionaries", "Lcom/intellij/spellchecker/dictionary/Dictionary;", "getRuntimeDictionaries$annotations", "getRuntimeDictionaries", "restartInspections", "", "findApplicable", "Lcom/intellij/spellchecker/dictionary/CustomDictionaryProvider;", "path", "intellij.spellchecker"})
    @SourceDebugExtension(value={"SMAP\nSpellCheckerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpellCheckerManager.kt\ncom/intellij/spellchecker/SpellCheckerManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,460:1\n31#2,2:461\n1381#3:463\n1469#3,5:464\n1381#3:469\n1469#3,5:470\n295#3,2:475\n*S KotlinDebug\n*F\n+ 1 SpellCheckerManager.kt\ncom/intellij/spellchecker/SpellCheckerManager$Companion\n*L\n101#1:461,2\n105#1:463\n105#1:464,5\n109#1:469\n109#1:470,5\n123#1:475,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SpellCheckerManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<SpellCheckerManager> serviceClass$iv = SpellCheckerManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (SpellCheckerManager)object;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getBundledDictionaries() {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = SpellCheckerManagerKt.access$getBUNDLED_EP_NAME$p().getExtensionList();
            boolean $i$f$flatMapSequence = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapSequenceTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                BundledDictionaryProvider it = (BundledDictionaryProvider)element$iv$iv;
                boolean bl = false;
                String[] stringArray = it.getBundledDictionaries();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getBundledDictionaries(...)");
                Sequence list$iv$iv = ArraysKt.asSequence((Object[])stringArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        public static /* synthetic */ void getBundledDictionaries$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Dictionary> getRuntimeDictionaries() {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = RuntimeDictionaryProvider.EP_NAME.getExtensionList();
            boolean $i$f$flatMapSequence = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapSequenceTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                RuntimeDictionaryProvider it = (RuntimeDictionaryProvider)element$iv$iv;
                boolean bl = false;
                Dictionary[] dictionaryArray = it.getDictionaries();
                Intrinsics.checkNotNullExpressionValue((Object)dictionaryArray, (String)"getDictionaries(...)");
                Sequence list$iv$iv = ArraysKt.asSequence((Object[])dictionaryArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        public static /* synthetic */ void getRuntimeDictionaries$annotations() {
        }

        public final void restartInspections() {
            ApplicationManager.getApplication().invokeLater(Companion::restartInspections$lambda$2);
        }

        private final CustomDictionaryProvider findApplicable(String path) {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = CustomDictionaryProvider.EP_NAME.getExtensionList();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    CustomDictionaryProvider it = (CustomDictionaryProvider)element$iv;
                    boolean bl = false;
                    if (!it.isApplicable(path)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private static final void restartInspections$lambda$2() {
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            for (Project project2 : projectArray) {
                Intrinsics.checkNotNull((Object)project2);
                Project project3 = project2;
                if (!project3.isInitialized() || !project3.isOpen()) continue;
                DaemonCodeAnalyzer.getInstance((Project)project3).restart();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

