/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsException
extends Exception {
    public static final VcsException[] EMPTY_ARRAY = new VcsException[0];
    private VirtualFile myVirtualFile;
    private Collection<@Nls String> myMessages;
    private boolean isWarning;

    public VcsException(@Nls String message) {
        super(message);
        this.isWarning = false;
        this.initMessage(message);
    }

    private void initMessage(@Nullable @Nls String message) {
        this.myMessages = Collections.singleton(VcsException.prepareMessage(message));
    }

    @Nls
    @NotNull
    private static String prepareMessage(@Nullable @Nls String message) {
        String string2 = message != null ? message : VcsBundle.message("exception.text.unknown.error", new Object[0]);
        if (string2 == null) {
            VcsException.$$$reportNull$$$0(0);
        }
        return string2;
    }

    public VcsException(Throwable throwable, boolean isWarning) {
        this(VcsException.getMessage(throwable), throwable);
        this.isWarning = isWarning;
    }

    public VcsException(Throwable throwable) {
        this(throwable, false);
    }

    public VcsException(@Nls String message, Throwable cause) {
        super(message, cause);
        this.isWarning = false;
        this.initMessage(message);
    }

    public VcsException(@Nls String message, boolean isWarning) {
        this(message);
        this.isWarning = isWarning;
    }

    public VcsException(@NotNull Collection<@Nls String> messages) {
        if (messages == null) {
            VcsException.$$$reportNull$$$0(1);
        }
        this.isWarning = false;
        this.myMessages = ContainerUtil.map(messages, VcsException::prepareMessage);
    }

    public void setVirtualFile(VirtualFile virtualFile) {
        this.myVirtualFile = virtualFile;
    }

    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    public @Nls String @NotNull [] getMessages() {
        String[] stringArray = ArrayUtilRt.toStringArray(this.myMessages);
        if (stringArray == null) {
            VcsException.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    public VcsException setIsWarning(boolean warning) {
        this.isWarning = warning;
        return this;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    @Override
    @Nls
    @NotNull
    public String getMessage() {
        String string2 = StringUtil.join(this.myMessages, (String)", ");
        if (string2 == null) {
            VcsException.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NlsSafe
    @Nullable
    public static String getMessage(@Nullable Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        String message = throwable.getMessage();
        if (message != null) {
            return message;
        }
        return throwable.getLocalizedMessage();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/VcsException";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/VcsException";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1 -> new IllegalArgumentException(string2);
        };
    }
}

