/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.XmlCodeFoldingSettings;
import com.intellij.lang.folding.CompositeFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.html.HtmlEmbeddedContentImpl;
import com.intellij.psi.impl.source.xml.XmlEntityRefImpl;
import com.intellij.psi.impl.source.xml.XmlTokenImpl;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.IXmlAttributeElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlConditionalSection;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlCodeFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    private static final TokenSet XML_ATTRIBUTE_SET = TokenSet.forAllMatching(el -> el instanceof IXmlAttributeElementType);
    private static final int MIN_TEXT_RANGE_LENGTH = 3;

    public void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> foldings, @NotNull PsiElement psiElement, @NotNull Document document, boolean quick) {
        PsiMetaOwner rootTag;
        XmlDocument xmlDocument;
        if (foldings == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (psiElement == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(2);
        }
        if (psiElement instanceof XmlFile) {
            XmlFile file = (XmlFile)psiElement;
            xmlDocument = file.getDocument();
        } else {
            xmlDocument = psiElement instanceof XmlDocument ? (XmlDocument)psiElement : (XmlDocument)PsiTreeUtil.getChildOfType((PsiElement)psiElement, XmlDocument.class);
        }
        XmlTag xmlTag = rootTag = xmlDocument == null ? null : xmlDocument.getRootTag();
        if (rootTag == null) {
            rootTag = xmlDocument;
        }
        if (rootTag != null) {
            this.doAddForChildren(xmlDocument, foldings, document);
        }
    }

    protected void addElementsToFold(List<FoldingDescriptor> foldings, XmlElement tag, Document document) {
        this.addToFold(foldings, tag, document);
        this.doAddForChildren(tag, foldings, document);
    }

    protected void doAddForChildren(XmlElement tag, List<FoldingDescriptor> foldings, Document document) {
        PsiElement[] children;
        for (PsiElement child : children = tag.getChildren()) {
            FoldingBuilder foldingBuilder;
            ProgressManager.checkCanceled();
            if (child instanceof XmlTag || child instanceof XmlConditionalSection) {
                this.addElementsToFold(foldings, (XmlElement)child, document);
                continue;
            }
            if (child instanceof XmlComment) {
                this.addToFold(foldings, child, document);
                continue;
            }
            if (child instanceof XmlText || child instanceof XmlProlog) {
                PsiElement[] grandChildren;
                for (PsiElement grandChild : grandChildren = child.getChildren()) {
                    ProgressManager.checkCanceled();
                    if (!(grandChild instanceof XmlComment) && !XmlCodeFoldingBuilder.isEntity(grandChild)) continue;
                    this.addToFold(foldings, grandChild, document);
                }
                continue;
            }
            if (XmlCodeFoldingBuilder.isEntity(child) || child instanceof XmlAttribute && XmlCodeFoldingBuilder.isAttributeShouldBeFolded((XmlAttribute)child)) {
                this.addToFold(foldings, child, document);
                continue;
            }
            Language language = child.getLanguage();
            if ((language instanceof XMLLanguage || language == Language.ANY) && !(child instanceof HtmlEmbeddedContentImpl) || (foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language)) == null) continue;
            Object[] foldingDescriptors = foldingBuilder.buildFoldRegions(child.getNode(), document);
            ContainerUtil.addAll(foldings, (Object[])foldingDescriptors);
        }
    }

    @Nullable
    public TextRange getRangeToFold(PsiElement element) {
        if (element instanceof XmlTag) {
            ASTNode tagNode = element.getNode();
            XmlToken tagNameElement = XmlTagUtil.getStartTagNameElement((XmlTag)element);
            if (tagNameElement == null) {
                return null;
            }
            int nameEnd = tagNameElement.getTextRange().getEndOffset();
            int end = tagNode.getLastChildNode().getTextRange().getEndOffset() - 1;
            ASTNode[] attributes = tagNode.getChildren(XML_ATTRIBUTE_SET);
            if (attributes.length > 0) {
                ASTNode lastAttribute = attributes[attributes.length - 1];
                ASTNode lastAttributeBeforeCR = null;
                for (ASTNode child = tagNode.getFirstChildNode(); child != lastAttribute.getTreeNext(); child = child.getTreeNext()) {
                    if (child.getElementType() == XmlElementType.XML_ATTRIBUTE) {
                        lastAttributeBeforeCR = child;
                        continue;
                    }
                    if (child.getPsi() instanceof PsiWhiteSpace && child.textContains('\n')) break;
                }
                if (lastAttributeBeforeCR != null) {
                    int attributeEnd = lastAttributeBeforeCR.getTextRange().getEndOffset();
                    return new UnfairTextRange(attributeEnd, end);
                }
            }
            return new UnfairTextRange(nameEnd, end);
        }
        if (element instanceof XmlComment) {
            XmlComment xmlComment = (XmlComment)element;
            TextRange textRange = element.getTextRange();
            int commentStartOffset = this.getCommentStartOffset(xmlComment);
            int commentEndOffset = this.getCommentStartEnd(xmlComment);
            if (textRange.getEndOffset() - textRange.getStartOffset() > commentStartOffset + commentEndOffset) {
                return new TextRange(textRange.getStartOffset() + commentStartOffset, textRange.getEndOffset() - commentEndOffset);
            }
            return null;
        }
        if (element instanceof XmlConditionalSection) {
            XmlConditionalSection conditionalSection = (XmlConditionalSection)element;
            TextRange textRange = element.getTextRange();
            PsiElement bodyStart = conditionalSection.getBodyStart();
            int startOffset = bodyStart != null ? bodyStart.getStartOffsetInParent() : 3;
            int endOffset = 3;
            if (textRange.getEndOffset() - textRange.getStartOffset() > startOffset + endOffset) {
                return new TextRange(textRange.getStartOffset() + startOffset, textRange.getEndOffset() - endOffset);
            }
            return null;
        }
        if (element instanceof XmlAttribute) {
            XmlAttributeValue valueElement = ((XmlAttribute)element).getValueElement();
            return valueElement != null ? valueElement.getValueTextRange() : null;
        }
        if (XmlCodeFoldingBuilder.isEntity(element)) {
            return element.getTextRange();
        }
        return null;
    }

    protected int getCommentStartOffset(XmlComment element) {
        return 4;
    }

    protected int getCommentStartEnd(XmlComment element) {
        return 3;
    }

    protected boolean addToFold(List<? super FoldingDescriptor> foldings, PsiElement elementToFold, Document document) {
        PsiUtilCore.ensureValid((PsiElement)elementToFold);
        TextRange range = this.getRangeToFold(elementToFold);
        if (range == null) {
            return false;
        }
        if (range.getStartOffset() >= 0 && range.getEndOffset() <= elementToFold.getContainingFile().getTextRange().getEndOffset() && range.getEndOffset() <= document.getTextLength()) {
            int startLine = document.getLineNumber(range.getStartOffset());
            int endLine = document.getLineNumber(range.getEndOffset() - 1);
            boolean entity = XmlCodeFoldingBuilder.isEntity(elementToFold);
            if ((startLine < endLine || elementToFold instanceof XmlAttribute || entity) && (range.getStartOffset() + 3 < range.getEndOffset() || entity)) {
                ASTNode node = elementToFold.getNode();
                String placeholder = this.getLanguagePlaceholderText(node, range);
                foldings.add((FoldingDescriptor)(placeholder != null ? new FoldingDescriptor(node, range, null, placeholder) : new FoldingDescriptor(node, range)));
                return true;
            }
        }
        return false;
    }

    public String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        PsiElement psi;
        FoldingBuilder foldingBuilder;
        if (node == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (range == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(4);
        }
        if ((foldingBuilder = LanguageFolding.INSTANCE.forLanguage((psi = node.getPsi()).getLanguage())) == this || foldingBuilder instanceof CompositeFoldingBuilder) {
            String value;
            if (psi instanceof XmlAttribute && "src".equalsIgnoreCase(((XmlAttribute)psi).getName())) {
                return "data:";
            }
            if (psi instanceof XmlTag || psi instanceof XmlComment || psi instanceof XmlAttribute || psi instanceof XmlConditionalSection) {
                return "...";
            }
            if (XmlCodeFoldingBuilder.isEntity(psi) && (value = XmlCodeFoldingBuilder.getEntityPlaceholder(psi)) != null) {
                return value;
            }
            return null;
        }
        return foldingBuilder instanceof CustomFoldingBuilder ? ((CustomFoldingBuilder)foldingBuilder).getPlaceholderText(node, range) : null;
    }

    @Nullable
    private static String getEntityPlaceholder(@NotNull PsiElement psi) {
        if (psi == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(5);
        }
        try {
            String text2 = psi.getText();
            String fastPath = StringUtil.unescapeXmlEntities((String)text2);
            if (!StringUtil.equals((CharSequence)fastPath, (CharSequence)text2)) {
                return fastPath;
            }
            if (psi.isValid()) {
                XmlAttributeValue value;
                XmlEntityDecl resolve = XmlEntityRefImpl.resolveEntity((XmlElement)psi, text2, psi.getContainingFile());
                XmlAttributeValue xmlAttributeValue = value = resolve != null ? resolve.getValueElement() : null;
                if (value != null) {
                    return XmlCodeFoldingBuilder.getEntityValue(value.getValue());
                }
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public static String getEntityValue(@Nullable String value) {
        int i;
        int n = i = value != null ? value.indexOf(35) : -1;
        if (i > 0) {
            int radix = 10;
            String number = value.substring(i + 1);
            if (StringUtil.startsWithIgnoreCase((String)number, (String)"x")) {
                radix = 16;
                number = number.substring(1);
            }
            try {
                int charNum = Integer.parseInt(StringUtil.trimEnd((String)number, (String)";"), radix);
                return String.valueOf((char)charNum);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        PsiElement psi;
        FoldingBuilder foldingBuilder;
        if (node == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(6);
        }
        if ((foldingBuilder = LanguageFolding.INSTANCE.forLanguage((psi = node.getPsi()).getLanguage())) == this || foldingBuilder instanceof CompositeFoldingBuilder) {
            return this.isPsiElementCollapsedByDefault(psi);
        }
        return foldingBuilder.isCollapsedByDefault(node);
    }

    private boolean isPsiElementCollapsedByDefault(PsiElement psi) {
        XmlCodeFoldingSettings foldingSettings = this.getFoldingSettings();
        return psi instanceof XmlTag && foldingSettings.isCollapseXmlTags() || psi instanceof XmlAttribute && (XmlCodeFoldingBuilder.foldStyle((XmlAttribute)psi, foldingSettings) || XmlCodeFoldingBuilder.foldSrc((XmlAttribute)psi, foldingSettings)) || XmlCodeFoldingBuilder.isEntity(psi) && foldingSettings.isCollapseEntities() && XmlCodeFoldingBuilder.hasEntityPlaceholder(psi);
    }

    public boolean isRegionCollapsedByDefault(@NotNull FoldingDescriptor foldingDescriptor) {
        PsiElement psi;
        FoldingBuilder foldingBuilder;
        if (foldingDescriptor == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(7);
        }
        if ((foldingBuilder = LanguageFolding.INSTANCE.forLanguage((psi = foldingDescriptor.getElement().getPsi()).getLanguage())) == this || foldingBuilder instanceof CompositeFoldingBuilder) {
            return this.isPsiElementCollapsedByDefault(psi);
        }
        return foldingBuilder.isCollapsedByDefault(foldingDescriptor);
    }

    private static boolean hasEntityPlaceholder(PsiElement psi) {
        return XmlCodeFoldingBuilder.getEntityPlaceholder(psi) != null;
    }

    private static boolean foldSrc(XmlAttribute psi, XmlCodeFoldingSettings settings) {
        return settings.isCollapseDataUri() && "src".equals(psi.getName());
    }

    private static boolean foldStyle(XmlAttribute psi, XmlCodeFoldingSettings settings) {
        return settings.isCollapseHtmlStyleAttribute() && "style".equalsIgnoreCase(psi.getName());
    }

    private static boolean isEntity(PsiElement psi) {
        return psi instanceof XmlEntityRef || psi instanceof XmlTokenImpl && ((XmlTokenImpl)psi).getElementType() == XmlTokenType.XML_CHAR_ENTITY_REF;
    }

    private static boolean isAttributeShouldBeFolded(XmlAttribute child) {
        return HtmlUtil.isHtmlFile((PsiElement)child.getContainingFile()) && ("style".equalsIgnoreCase(child.getName()) || "src".equals(child.getName()) && child.getValue() != null && URLUtil.isDataUri((String)child.getValue()));
    }

    protected abstract XmlCodeFoldingSettings getFoldingSettings();

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        if (node == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(8);
        }
        return node.getElementType() == XmlElementType.XML_TAG;
    }

    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        if (node == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(9);
        }
        return node.getElementType() == XmlTokenType.XML_COMMENT_CHARACTERS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingDescriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/XmlCodeFoldingBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagePlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getEntityPlaceholder";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomFoldingRoot";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomFoldingCandidate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

