/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.RearrangeCodeProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RearrangeAttributesIntention
implements IntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string2 = this.getFamilyName();
        if (string2 == null) {
            RearrangeAttributesIntention.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string2 = XmlBundle.message("rearrange.tag.attributes", new Object[0]);
        if (string2 == null) {
            RearrangeAttributesIntention.$$$reportNull$$$0(1);
        }
        return string2;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        XmlTag tag;
        if (project2 == null) {
            RearrangeAttributesIntention.$$$reportNull$$$0(2);
        }
        if ((tag = RearrangeAttributesIntention.getTag(editor, file)) == null) {
            return false;
        }
        if (tag.getAttributes().length <= 1) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        ASTNode startEnd = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
        return startEnd == null || offset <= startEnd.getTextRange().getEndOffset();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
        XmlTag tag;
        if (project2 == null) {
            RearrangeAttributesIntention.$$$reportNull$$$0(3);
        }
        if ((tag = RearrangeAttributesIntention.getTag(editor, file)) == null) {
            return;
        }
        TextRange range = tag.getTextRange();
        ASTNode startEnd = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
        ASTNode name = XmlChildRole.START_TAG_NAME_FINDER.findChild(tag.getNode());
        TextRange reformatRange = new TextRange(name != null ? name.getTextRange().getEndOffset() + 1 : range.getStartOffset() + 1, startEnd != null ? startEnd.getTextRange().getEndOffset() - 1 : range.getEndOffset());
        final RangeMarker marker = editor.getDocument().createRangeMarker(reformatRange);
        new RearrangeCodeProcessor((AbstractLayoutCodeProcessor)new ReformatCodeProcessor(project2, file, reformatRange, false)){

            public Collection<TextRange> getRangesToFormat(@NotNull PsiFile file, boolean processChangedTextOnly) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return Collections.singleton(marker.getTextRange());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/RearrangeAttributesIntention$1", "getRangesToFormat"));
            }
        }.run();
        editor.getCaretModel().moveToOffset(reformatRange.getStartOffset());
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static XmlTag getTag(@Nullable Editor editor, PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (parent != null) {
            return parent;
        }
        element = file.findElementAt(offset - 1);
        parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (parent != null) {
            return parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/RearrangeAttributesIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/RearrangeAttributesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3 -> new IllegalArgumentException(string2);
        };
    }
}

