/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.ide.impl.TrustedProjects;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.json.JsonBundle;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.util.ObjectUtils;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonPointerReferenceProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.light.legacy.JsonSchemaObjectReadingUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaDocumentationProvider
implements DocumentationProvider {
    @Nullable
    @Nls
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return JsonSchemaDocumentationProvider.findSchemaAndGenerateDoc(element, originalElement, true, null);
    }

    @Nullable
    @Nls
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        String forcedPropName = null;
        if (element instanceof FakeDocElement) {
            forcedPropName = ((FakeDocElement)element).myAltName;
            element = ((FakeDocElement)element).myContextElement;
        }
        return JsonSchemaDocumentationProvider.findSchemaAndGenerateDoc(element, originalElement, false, forcedPropName);
    }

    @Nullable
    @Nls
    public static String findSchemaAndGenerateDoc(PsiElement element, @Nullable PsiElement originalElement, boolean preferShort, @Nullable String forcedPropName) {
        VirtualFile virtualFile;
        if (element instanceof FakePsiElement) {
            return null;
        }
        PsiElement psiElement = element = JsonSchemaDocumentationProvider.isWhitespaceOrComment(originalElement) ? element : (PsiElement)ObjectUtils.coalesce((Object)originalElement, (Object)element);
        if (originalElement != null && JsonSchemaDocumentationProvider.hasFileOrPointerReferences(originalElement.getReferences())) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        JsonSchemaService service = JsonSchemaService.Impl.get(element.getProject());
        if (!service.isApplicableToFile(virtualFile = containingFile.getViewProvider().getVirtualFile())) {
            return null;
        }
        JsonSchemaObject rootSchema = service.getSchemaObject(containingFile);
        if (rootSchema == null) {
            return null;
        }
        return JsonSchemaDocumentationProvider.generateDoc(element, rootSchema, preferShort, forcedPropName);
    }

    private static boolean hasFileOrPointerReferences(PsiReference[] references) {
        for (PsiReference reference : references) {
            if (!(reference instanceof PsiFileReference) && !(reference instanceof JsonPointerReferenceProvider.JsonSchemaIdReference) && !(reference instanceof JsonPointerReferenceProvider.JsonPointerReference)) continue;
            return true;
        }
        return false;
    }

    private static boolean isWhitespaceOrComment(@Nullable PsiElement originalElement) {
        return originalElement instanceof PsiWhiteSpace || originalElement instanceof PsiComment;
    }

    @Nullable
    @Nls
    public static String generateDoc(@NotNull PsiElement element, @NotNull JsonSchemaObject rootSchema, boolean preferShort, @Nullable String forcedPropName) {
        JsonLikePsiWalker walker;
        if (element == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (rootSchema == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(1);
        }
        if ((walker = JsonLikePsiWalker.getWalker(element, rootSchema)) == null) {
            return null;
        }
        PsiElement checkable = walker.findElementToCheck(element);
        if (checkable == null) {
            return null;
        }
        JsonPointerPosition position = walker.findPosition(checkable, true);
        if (position == null) {
            return null;
        }
        if (forcedPropName != null) {
            if (JsonSchemaDocumentationProvider.isWhitespaceOrComment(element)) {
                position.addFollowingStep(forcedPropName);
            } else {
                if (position.isEmpty()) {
                    return null;
                }
                if (position.isArray(position.size() - 1)) {
                    return null;
                }
                position.replaceStep(position.size() - 1, forcedPropName);
            }
        }
        Collection<JsonSchemaObject> schemas = new JsonSchemaResolver(element.getProject(), rootSchema, position, walker.createValueAdapter(element)).resolve();
        Object htmlDescription = null;
        boolean deprecated = false;
        ArrayList<JsonSchemaType> possibleTypes = new ArrayList<JsonSchemaType>();
        for (JsonSchemaObject schema : schemas) {
            if (htmlDescription == null) {
                htmlDescription = JsonSchemaDocumentationProvider.getBestDocumentation(preferShort, schema);
                String message = schema.getDeprecationMessage();
                if (message != null) {
                    htmlDescription = htmlDescription == null ? message : message + "<br/>" + (String)htmlDescription;
                    deprecated = true;
                }
            }
            if (schema.getType() != null && schema.getType() != JsonSchemaType._any) {
                possibleTypes.add(schema.getType());
                continue;
            }
            if (schema.getTypeVariants() != null) {
                possibleTypes.addAll(schema.getTypeVariants());
                continue;
            }
            JsonSchemaType guessedType = JsonSchemaObjectReadingUtils.guessType(schema);
            if (guessedType == null) continue;
            possibleTypes.add(guessedType);
        }
        return JsonSchemaDocumentationProvider.appendNameTypeAndApi(position, JsonSchemaDocumentationProvider.getThirdPartyApiInfo(element, rootSchema), possibleTypes, htmlDescription, deprecated, preferShort);
    }

    @Nullable
    @NlsSafe
    private static String appendNameTypeAndApi(@NotNull JsonPointerPosition position, @NotNull String apiInfo, @NotNull List<JsonSchemaType> possibleTypes, @Nullable String htmlDescription, boolean deprecated, boolean preferShort) {
        String deprecationComment;
        if (position == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (apiInfo == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(3);
        }
        if (possibleTypes == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (position.size() == 0) {
            return htmlDescription;
        }
        String name = position.getLastName();
        if (name == null) {
            return htmlDescription;
        }
        Object type = "";
        String schemaType = JsonSchemaObjectReadingUtils.getTypesDescription(false, possibleTypes);
        if (schemaType != null) {
            type = ": " + schemaType;
        }
        String string = deprecationComment = deprecated ? JsonBundle.message((String)"schema.documentation.deprecated.postfix", (Object[])new Object[0]) : "";
        htmlDescription = preferShort ? "<b>" + name + "</b>" + (String)type + apiInfo + deprecationComment + (String)(htmlDescription == null ? "" : "<br/>" + (String)htmlDescription) : "<div class='definition'><pre>" + name + (String)type + apiInfo + deprecationComment + "</pre></div>" + (String)(htmlDescription == null ? "" : "<div class='content'>" + (String)htmlDescription + "</div>");
        return htmlDescription;
    }

    @NotNull
    private static String getThirdPartyApiInfo(@NotNull PsiElement element, @NotNull JsonSchemaObject rootSchema) {
        String information;
        if (element == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(5);
        }
        if (rootSchema == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(6);
        }
        JsonSchemaService service = JsonSchemaService.Impl.get(element.getProject());
        Object apiInfo = "";
        JsonSchemaFileProvider provider = service.getSchemaProvider(rootSchema);
        if (provider != null && (information = provider.getThirdPartyApiInformation()) != null) {
            apiInfo = "&nbsp;&nbsp;<i>(" + information + ")</i>";
        }
        String string = apiInfo;
        if (string == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public static String getBestDocumentation(boolean preferShort, @NotNull JsonSchemaObject schema) {
        String htmlDescription;
        if (schema == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(8);
        }
        if ((htmlDescription = schema.getHtmlDescription()) != null && JsonSchemaDocumentationProvider.hasNonTrustedProjects()) {
            htmlDescription = StringUtil.escapeXmlEntities((String)htmlDescription);
        }
        String description = schema.getDescription();
        String title = schema.getTitle();
        if (preferShort && !StringUtil.isEmptyOrSpaces((String)title)) {
            return JsonSchemaDocumentationProvider.plainTextPostProcess(title);
        }
        if (!StringUtil.isEmptyOrSpaces((String)htmlDescription)) {
            Object desc = htmlDescription;
            if (!StringUtil.isEmptyOrSpaces((String)title)) {
                desc = JsonSchemaDocumentationProvider.plainTextPostProcess(title) + "<br/>" + (String)desc;
            }
            return desc;
        }
        if (!StringUtil.isEmptyOrSpaces((String)description)) {
            Object desc = JsonSchemaDocumentationProvider.plainTextPostProcess(description);
            if (!StringUtil.isEmptyOrSpaces((String)title)) {
                desc = JsonSchemaDocumentationProvider.plainTextPostProcess(title) + "<br/>" + (String)desc;
            }
            return desc;
        }
        return null;
    }

    private static boolean hasNonTrustedProjects() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (TrustedProjects.isTrusted((Project)project)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String plainTextPostProcess(@NotNull String text) {
        if (text == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(9);
        }
        String string = StringUtil.escapeXmlEntities((String)text).replace("\\n", "<br/>");
        if (string == null) {
            JsonSchemaDocumentationProvider.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if ((element instanceof JsonProperty || JsonSchemaDocumentationProvider.isWhitespaceOrComment(element) && element.getParent() instanceof JsonObject) && object instanceof String) {
            return new FakeDocElement((PsiElement)(element instanceof JsonProperty ? ((JsonProperty)element).getNameElement() : element), StringUtil.unquoteString((String)((String)object)));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSchema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apiInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleTypes";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaDocumentationProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaDocumentationProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getThirdPartyApiInfo";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "plainTextPostProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateDoc";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendNameTypeAndApi";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getThirdPartyApiInfo";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBestDocumentation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "plainTextPostProcess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10 -> new IllegalStateException(string);
        };
    }

    private static final class FakeDocElement
    extends FakePsiElement {
        private final PsiElement myContextElement;
        private final String myAltName;

        private FakeDocElement(PsiElement context, @NotNull String name) {
            if (name == null) {
                FakeDocElement.$$$reportNull$$$0(0);
            }
            this.myContextElement = context;
            this.myAltName = name;
        }

        public PsiElement getParent() {
            return this.myContextElement;
        }

        @NotNull
        public TextRange getTextRangeInParent() {
            TextRange textRange = this.myContextElement.getTextRange().shiftLeft(this.myContextElement.getTextOffset());
            if (textRange == null) {
                FakeDocElement.$$$reportNull$$$0(1);
            }
            return textRange;
        }

        @NotNull
        public ItemPresentation getPresentation() {
            return new PresentationData(this.myAltName, null, null, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaDocumentationProvider$FakeDocElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaDocumentationProvider$FakeDocElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRangeInParent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

