/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.cloneDialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractListModel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.ui.cloneDialog.GHRepositoryListItem;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0010J\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0007J\u0016\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cJ$\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0!J\u001e\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0007H\u0002R6\u0010\u0005\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\n\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bj\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/github/ui/cloneDialog/GHCloneDialogRepositoryListModel;", "Ljavax/swing/AbstractListModel;", "Lorg/jetbrains/plugins/github/ui/cloneDialog/GHRepositoryListItem;", "<init>", "()V", "itemsByAccount", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "", "Lkotlin/collections/LinkedHashMap;", "repositoriesByAccount", "Ljava/util/HashMap;", "", "Lorg/jetbrains/plugins/github/api/data/GithubRepo;", "Lkotlin/collections/HashMap;", "getSize", "", "getElementAt", "index", "getItemAt", "Lkotlin/Pair;", "indexOf", "account", "item", "clear", "", "setError", "error", "", "addRepositories", "details", "Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;", "repos", "", "findAccountOffsets", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHCloneDialogRepositoryListModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHCloneDialogRepositoryListModel.kt\norg/jetbrains/plugins/github/ui/cloneDialog/GHCloneDialogRepositoryListModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,113:1\n1#2:114\n381#3,7:115\n381#3,7:122\n381#3,7:129\n*S KotlinDebug\n*F\n+ 1 GHCloneDialogRepositoryListModel.kt\norg/jetbrains/plugins/github/ui/cloneDialog/GHCloneDialogRepositoryListModel\n*L\n64#1:115,7\n78#1:122,7\n79#1:129,7\n*E\n"})
public final class GHCloneDialogRepositoryListModel
extends AbstractListModel<GHRepositoryListItem> {
    @NotNull
    private final LinkedHashMap<GithubAccount, List<GHRepositoryListItem>> itemsByAccount = new LinkedHashMap();
    @NotNull
    private final HashMap<GithubAccount, Set<GithubRepo>> repositoriesByAccount = new HashMap();

    /*
     * WARNING - void declaration
     */
    @Override
    public int getSize() {
        Collection<List<GHRepositoryListItem>> collection = this.itemsByAccount.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable iterable = collection;
        int n = 0;
        for (Object t : iterable) {
            void it;
            List list = (List)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.size();
            n = n2 + n3;
        }
        return n;
    }

    @Override
    @NotNull
    public GHRepositoryListItem getElementAt(int index) {
        int offset = 0;
        Iterator iterator = ((Map)this.itemsByAccount).entrySet().iterator();
        while (iterator.hasNext()) {
            List items2 = (List)iterator.next().getValue();
            if (index >= offset + items2.size()) {
                offset += items2.size();
                continue;
            }
            return (GHRepositoryListItem)items2.get(index - offset);
        }
        throw new IndexOutOfBoundsException(index);
    }

    @NotNull
    public final Pair<GithubAccount, GHRepositoryListItem> getItemAt(int index) {
        int offset = 0;
        for (Map.Entry entry : ((Map)this.itemsByAccount).entrySet()) {
            GithubAccount account = (GithubAccount)((Object)entry.getKey());
            List items2 = (List)entry.getValue();
            if (index >= offset + items2.size()) {
                offset += items2.size();
                continue;
            }
            return TuplesKt.to((Object)((Object)account), items2.get(index - offset));
        }
        throw new IndexOutOfBoundsException(index);
    }

    public final int indexOf(@NotNull GithubAccount account, @NotNull GHRepositoryListItem item) {
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (!this.itemsByAccount.containsKey((Object)account)) {
            return -1;
        }
        int startOffset = 0;
        for (Map.Entry entry : ((Map)this.itemsByAccount).entrySet()) {
            GithubAccount _account = (GithubAccount)((Object)entry.getKey());
            List items2 = (List)entry.getValue();
            if (Intrinsics.areEqual((Object)((Object)_account), (Object)((Object)account))) {
                int idx = items2.indexOf(item);
                if (idx < 0) {
                    return -1;
                }
                return startOffset + idx;
            }
            startOffset += items2.size();
        }
        return -1;
    }

    public final void clear(@NotNull GithubAccount account) {
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        this.repositoriesByAccount.remove((Object)account);
        Pair<Integer, Integer> pair = this.findAccountOffsets(account);
        if (pair == null) {
            return;
        }
        Pair<Integer, Integer> pair2 = pair;
        int startOffset = ((Number)pair2.component1()).intValue();
        int endOffset = ((Number)pair2.component2()).intValue();
        this.itemsByAccount.remove((Object)account);
        this.fireIntervalRemoved(this, startOffset, endOffset);
    }

    public final void setError(@NotNull GithubAccount account, @NotNull Throwable error) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Map $this$getOrPut$iv = this.itemsByAccount;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get((Object)account);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(account, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        List accountItems = (List)object;
        Pair<Integer, Integer> pair = this.findAccountOffsets(account);
        if (pair == null) {
            return;
        }
        Pair<Integer, Integer> pair2 = pair;
        int startOffset = ((Number)pair2.component1()).intValue();
        int endOffset = ((Number)pair2.component2()).intValue();
        GHRepositoryListItem.Error errorItem = new GHRepositoryListItem.Error(account, error);
        accountItems.add(0, errorItem);
        this.fireIntervalAdded(this, endOffset, endOffset + 1);
        this.fireContentsChanged(this, startOffset, endOffset + 1);
    }

    public final void addRepositories(@NotNull GithubAccount account, @NotNull GithubAuthenticatedUser details2, @NotNull List<? extends GithubRepo> repos) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        Intrinsics.checkNotNullParameter((Object)details2, (String)"details");
        Intrinsics.checkNotNullParameter(repos, (String)"repos");
        Map $this$getOrPut$iv = this.repositoriesByAccount;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get((Object)account);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(account, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        Set repoSet = (Set)object2;
        Map $this$getOrPut$iv2 = this.itemsByAccount;
        boolean $i$f$getOrPut2 = false;
        Object value$iv2 = $this$getOrPut$iv2.get((Object)account);
        if (value$iv2 == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv2.put(account, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv2;
        }
        List items2 = (List)object;
        Pair<Integer, Integer> pair = this.findAccountOffsets(account);
        if (pair == null) {
            return;
        }
        Pair<Integer, Integer> pair2 = pair;
        int startOffset = ((Number)pair2.component1()).intValue();
        int endOffset = ((Number)pair2.component2()).intValue();
        List toAdd = new ArrayList();
        for (GithubRepo githubRepo : repos) {
            GHRepositoryListItem.Repo item = new GHRepositoryListItem.Repo(account, details2, githubRepo);
            boolean isNew = repoSet.add(githubRepo);
            if (!isNew) {
                int idx = items2.indexOf(item);
                items2.remove(idx);
                this.fireIntervalRemoved(this, startOffset + idx, startOffset + idx);
                --endOffset;
            }
            toAdd.add(item);
        }
        items2.addAll(toAdd);
        this.fireIntervalAdded(this, endOffset, endOffset + toAdd.size());
    }

    private final Pair<Integer, Integer> findAccountOffsets(GithubAccount account) {
        if (!this.itemsByAccount.containsKey((Object)account)) {
            return null;
        }
        int startOffset = 0;
        int endOffset = 0;
        for (Map.Entry entry : ((Map)this.itemsByAccount).entrySet()) {
            GithubAccount _account = (GithubAccount)((Object)entry.getKey());
            List items2 = (List)entry.getValue();
            endOffset = startOffset + items2.size();
            if (Intrinsics.areEqual((Object)((Object)_account), (Object)((Object)account))) break;
            startOffset += items2.size();
        }
        return TuplesKt.to((Object)startOffset, (Object)endOffset);
    }
}

