/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.api.httpclient;

import com.intellij.collaboration.api.httpclient.HttpClientFactory;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.util.io.HttpRequests;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/collaboration/api/httpclient/HttpClientFactoryBase;", "Lcom/intellij/collaboration/api/httpclient/HttpClientFactory;", "<init>", "()V", "useProxy", "", "getUseProxy", "()Z", "connectionTimeoutMillis", "", "getConnectionTimeoutMillis", "()J", "createClient", "Ljava/net/http/HttpClient;", "intellij.platform.collaborationTools"})
public class HttpClientFactoryBase
implements HttpClientFactory {
    private final boolean useProxy;
    private final long connectionTimeoutMillis = HttpRequests.CONNECTION_TIMEOUT;

    public HttpClientFactoryBase() {
        this.useProxy = true;
    }

    protected boolean getUseProxy() {
        return this.useProxy;
    }

    protected long getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    @Override
    @NotNull
    public HttpClient createClient() {
        HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.NORMAL).proxy(this.getUseProxy() ? ProxySelector.getDefault() : HttpClient.Builder.NO_PROXY).connectTimeout(Duration.ofMillis(this.getConnectionTimeoutMillis())).executor(ProcessIOExecutorService.INSTANCE).build();
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"build(...)");
        return httpClient;
    }
}

