/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.core.InputModifiers;
import org.assertj.swing.core.KeyPressInfo;
import org.assertj.swing.core.TestTerminator;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.util.ToolkitProvider;

public class EmergencyAbortListener
implements AWTEventListener {
    private static final long EVENT_MASK = 8L;
    private final Toolkit toolkit;
    private final TestTerminator testTerminator;
    private int keyCode = 65;
    private int modifiers = InputModifiers.unify(2, 1);

    public static EmergencyAbortListener registerInToolkit() {
        EmergencyAbortListener listener2 = new EmergencyAbortListener(ToolkitProvider.instance().defaultToolkit());
        listener2.register();
        return listener2;
    }

    @VisibleForTesting
    EmergencyAbortListener(@Nonnull Toolkit toolkit) {
        this(toolkit, new TestTerminator());
    }

    @VisibleForTesting
    EmergencyAbortListener(@Nonnull Toolkit toolkit, @Nonnull TestTerminator testTerminator) {
        this.testTerminator = testTerminator;
        this.toolkit = toolkit;
    }

    @VisibleForTesting
    void register() {
        this.removePrevious();
        this.toolkit.addAWTEventListener(this, 8L);
    }

    private void removePrevious() {
        AWTEventListener[] listeners;
        for (AWTEventListener listener2 : listeners = this.toolkit.getAWTEventListeners(8L)) {
            if (!(listener2 instanceof EmergencyAbortListener)) continue;
            this.toolkit.removeAWTEventListener(listener2);
        }
    }

    public EmergencyAbortListener keyCombination(@Nonnull KeyPressInfo keyPressInfo) {
        Preconditions.checkNotNull(keyPressInfo);
        this.keyCode = keyPressInfo.keyCode();
        this.modifiers = InputModifiers.unify(Preconditions.checkNotNull(keyPressInfo.modifiers()));
        return this;
    }

    public void unregister() {
        this.toolkit.removeAWTEventListener(this);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event.getID() != 401) {
            return;
        }
        if (!(event instanceof KeyEvent)) {
            return;
        }
        KeyEvent e = (KeyEvent)event;
        if (e.getKeyCode() != this.keyCode) {
            return;
        }
        if (!InputModifiers.modifiersMatch(e, this.modifiers)) {
            return;
        }
        this.testTerminator.terminateTests();
    }

    @VisibleForTesting
    int keyCode() {
        return this.keyCode;
    }

    @VisibleForTesting
    int modifiers() {
        return this.modifiers;
    }
}

