/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import javax.tools.StandardJavaFileManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.compiler.rt.OutputItem;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.Builder;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ExternalProcessUtil;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.groovy.CompilingGroovycRunner;
import org.jetbrains.jps.incremental.groovy.DefaultOutputConsumer;
import org.jetbrains.jps.incremental.groovy.EclipseOutputParser;
import org.jetbrains.jps.incremental.groovy.ForkedGroovyc;
import org.jetbrains.jps.incremental.groovy.GreclipseJpsCompilerSettings;
import org.jetbrains.jps.incremental.groovy.GreclipseMain;
import org.jetbrains.jps.incremental.groovy.GreclipseSettings;
import org.jetbrains.jps.incremental.groovy.GroovyBuilder;
import org.jetbrains.jps.incremental.groovy.GroovyJpsBundle;
import org.jetbrains.jps.incremental.groovy.JpsGroovycRunner;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.service.SharedThreadPool;

public final class GreclipseBuilder
extends ModuleLevelBuilder {
    private static final Logger LOG = Logger.getInstance(GreclipseBuilder.class);
    private static final Key<Boolean> COMPILER_VERSION_INFO = Key.create((String)"_greclipse_compiler_info_");
    @NlsSafe
    public static final String ID = "Groovy-Eclipse";
    private static final Object ourGlobalEnvironmentLock = new String("GreclipseBuilder lock");
    private String myGreclipseJar;
    private ClassLoader myGreclipseLoader;
    private final CompilingGroovycRunner myHelper = new CompilingGroovycRunner(true){

        @Override
        protected boolean acceptsFileType(String path) {
            return super.acceptsFileType(path) || path.endsWith(".java");
        }
    };

    GreclipseBuilder() {
        super(BuilderCategory.TRANSLATOR);
    }

    @Nullable
    private ClassLoader createGreclipseLoader(@Nullable String jar) {
        if (StringUtil.isEmpty((String)jar)) {
            return null;
        }
        if (jar.equals(this.myGreclipseJar)) {
            return this.myGreclipseLoader;
        }
        try {
            URL[] urls = new URL[]{new File(jar).toURI().toURL(), Objects.requireNonNull(PathManager.getJarForClass(GreclipseMain.class)).toUri().toURL()};
            URLClassLoader loader = new URLClassLoader(urls, StandardJavaFileManager.class.getClassLoader());
            Class.forName("org.eclipse.jdt.internal.compiler.batch.Main", false, loader);
            this.myGreclipseJar = jar;
            this.myGreclipseLoader = loader;
            return loader;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    public List<String> getCompilableFileExtensions() {
        List<String> list = Arrays.asList("groovy", "java");
        if (list == null) {
            GreclipseBuilder.$$$reportNull$$$0(0);
        }
        return list;
    }

    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException {
        if (!GreclipseBuilder.useGreclipse(context)) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        try {
            Boolean notified;
            List<File> toCompile = this.myHelper.collectChangedFiles(context, dirtyFilesHolder, false, (Ref<Boolean>)Ref.create((Object)false));
            if (toCompile.isEmpty()) {
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            Map<ModuleBuildTarget, String> outputDirs = GroovyBuilder.getCanonicalModuleOutputs(context, chunk, (Builder)this);
            if (outputDirs == null) {
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            JpsProject project = context.getProjectDescriptor().getProject();
            GreclipseSettings greclipseSettings = GreclipseJpsCompilerSettings.getSettings(project);
            if (greclipseSettings == null) {
                String message = GroovyJpsBundle.message("greclipse.not.initialized.for.project.0", project);
                LOG.error(message);
                context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, message));
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            ClassLoader loader = this.createGreclipseLoader(greclipseSettings.greclipsePath);
            if (loader == null) {
                context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, GroovyJpsBundle.message("greclipse.invalid.jar.path.0", greclipseSettings.greclipsePath)));
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            Set modules = chunk.getModules();
            ProcessorConfigProfile profile = null;
            if (modules.size() == 1) {
                JpsJavaCompilerConfiguration compilerConfig = JpsJavaExtensionService.getInstance().getCompilerConfiguration(project);
                assert (compilerConfig != null);
                profile = compilerConfig.getAnnotationProcessingProfile((JpsModule)modules.iterator().next());
            } else {
                String message = JavaBuilder.validateCycle((CompileContext)context, (ModuleChunk)chunk);
                if (message != null) {
                    context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, message));
                    return ModuleLevelBuilder.ExitCode.ABORT;
                }
            }
            String mainOutputDir = outputDirs.get(chunk.representativeTarget());
            List<String> args = GreclipseBuilder.createCommandLine(context, chunk, toCompile, mainOutputDir, profile, greclipseSettings);
            List<String> vmOptions = GreclipseBuilder.discoverVmOptions(chunk, greclipseSettings.cmdLineParams, greclipseSettings.vmOptions);
            if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
                LOG.debug("Compiling with args: " + args);
            }
            if ((notified = (Boolean)COMPILER_VERSION_INFO.get((UserDataHolder)context)) != Boolean.TRUE) {
                context.processMessage((BuildMessage)new CompilerMessage("", BuildMessage.Kind.INFO, GroovyJpsBundle.message("greclipse.info", new Object[0])));
                COMPILER_VERSION_INFO.set((UserDataHolder)context, (Object)Boolean.TRUE);
            }
            context.processMessage((BuildMessage)new ProgressMessage(GroovyJpsBundle.message("greclipse.compiling.chunk.0", chunk.getPresentableShortName())));
            StringWriter out = new StringWriter();
            StringWriter err = new StringWriter();
            HashMap<String, List<String>> outputMap = new HashMap<String, List<String>>();
            boolean success = this.performCompilation(vmOptions, args, out, err, outputMap, context, chunk);
            ArrayList<OutputItem> items = new ArrayList<OutputItem>();
            for (String src : outputMap.keySet()) {
                for (String classFile : outputMap.get(src)) {
                    items.add(new OutputItem(FileUtil.toSystemIndependentName((String)(mainOutputDir + classFile)), FileUtil.toSystemIndependentName((String)src)));
                }
            }
            MultiMap<ModuleBuildTarget, OutputItem> successfullyCompiled = this.myHelper.processCompiledFiles(context, chunk, outputDirs, mainOutputDir, items);
            EclipseOutputParser parser = new EclipseOutputParser(this.getPresentableName(), chunk);
            List messages = ContainerUtil.concat(parser.parseMessages(out.toString()), parser.parseMessages(err.toString()));
            boolean hasError = false;
            for (CompilerMessage message : messages) {
                if (message.getKind() == BuildMessage.Kind.ERROR) {
                    hasError = true;
                }
                context.processMessage((BuildMessage)message);
            }
            if (!success && !hasError) {
                context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, GroovyJpsBundle.message("greclipse.compilation.failed", new Object[0])));
            }
            this.myHelper.updateDependencies(context, toCompile, successfullyCompiled, new DefaultOutputConsumer(outputConsumer), (Builder)this);
            return ModuleLevelBuilder.ExitCode.OK;
        }
        catch (Exception e) {
            throw new ProjectBuildException((Throwable)e);
        }
    }

    static boolean useGreclipse(CompileContext context) {
        JpsProject project = context.getProjectDescriptor().getProject();
        return ID.equals(JpsJavaExtensionService.getInstance().getCompilerConfiguration(project).getJavaCompilerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performCompilation(List<String> vmOptions, List<String> args, StringWriter out, StringWriter err, Map<String, List<String>> outputs, CompileContext context, ModuleChunk chunk) {
        String bytecodeTarget = JpsGroovycRunner.getBytecodeTarget(context, chunk);
        if (bytecodeTarget != null && System.getProperty("groovy.target.bytecode") == null) {
            Object object = ourGlobalEnvironmentLock;
            synchronized (object) {
                boolean bl;
                try {
                    System.setProperty("groovy.target.bytecode", bytecodeTarget);
                    bl = this.performCompilationInner(vmOptions, args, out, err, outputs, context, chunk);
                }
                catch (Throwable throwable) {
                    System.clearProperty("groovy.target.bytecode");
                    throw throwable;
                }
                System.clearProperty("groovy.target.bytecode");
                return bl;
            }
        }
        return this.performCompilationInner(vmOptions, args, out, err, outputs, context, chunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performCompilationInner(List<String> vmOptions, List<String> args, final StringWriter out, final StringWriter err, Map<String, List<String>> outputs, CompileContext context, ModuleChunk chunk) {
        ClassLoader jpsLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.myGreclipseLoader);
            if (vmOptions.isEmpty()) {
                Class<?> mainClass = Class.forName(GreclipseMain.class.getName(), true, this.myGreclipseLoader);
                Constructor<?> constructor = mainClass.getConstructor(PrintWriter.class, PrintWriter.class, Map.class);
                Method compileMethod = mainClass.getMethod("compile", String[].class);
                Object main = constructor.newInstance(new PrintWriter(out), new PrintWriter(err), outputs);
                boolean bl = (Boolean)compileMethod.invoke(main, new Object[]{ArrayUtilRt.toStringArray(args)});
                return bl;
            }
            List cmd = ExternalProcessUtil.buildJavaCommandLine((String)ForkedGroovyc.getJavaExecutable(chunk), (String)"org.jetbrains.jps.incremental.groovy.GreclipseMain", Collections.emptyList(), Arrays.asList(this.myGreclipseJar, Objects.requireNonNull(PathManager.getJarForClass(GreclipseMain.class)).toAbsolutePath().toString()), vmOptions, args);
            Process process = Runtime.getRuntime().exec(ArrayUtilRt.toStringArray((Collection)cmd));
            BaseOSProcessHandler handler = new BaseOSProcessHandler(process, StringUtil.join((Collection)cmd, (String)" "), null){

                @NotNull
                public Future<?> executeTask(@NotNull Runnable task) {
                    if (task == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    Future future = SharedThreadPool.getInstance().submit(task);
                    if (future == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return future;
                }

                public void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
                    if (text == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (outputType == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    if (outputType == ProcessOutputType.STDERR) {
                        err.append(text);
                    }
                    if (outputType == ProcessOutputType.STDOUT) {
                        out.append(text);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "task";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/jps/incremental/groovy/GreclipseBuilder$2";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "text";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/jps/incremental/groovy/GreclipseBuilder$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "executeTask";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "executeTask";
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "notifyTextAvailable";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            handler.startNotify();
            handler.waitFor();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            context.processMessage((BuildMessage)CompilerMessage.createInternalBuilderError((String)this.getPresentableName(), (Throwable)e));
            boolean bl = false;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(jpsLoader);
        }
    }

    private static List<String> createCommandLine(CompileContext context, ModuleChunk chunk, List<File> srcFiles, String mainOutputDir, @Nullable ProcessorConfigProfile profile, GreclipseSettings settings) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-cp");
        args.add(GreclipseBuilder.getClasspathString(chunk));
        JavaBuilder.addCompilationOptions(args, (CompileContext)context, (ModuleChunk)chunk, (ProcessorConfigProfile)profile);
        args.add("-d");
        args.add(mainOutputDir);
        List params = ParametersListUtil.parse((String)settings.cmdLineParams);
        Iterator iterator = params.iterator();
        while (iterator.hasNext()) {
            String option = (String)iterator.next();
            if ("-javaAgentClass".equals(option)) {
                iterator.next();
                continue;
            }
            if ("-target".equals(option)) {
                iterator.next();
                continue;
            }
            if (option.isEmpty() || "-g".equals(option) || "-verbose".equals(option)) continue;
            args.add(option);
        }
        if (settings.debugInfo) {
            args.add("-g");
        }
        for (File file : srcFiles) {
            args.add(file.getPath());
        }
        return args;
    }

    private static List<String> discoverVmOptions(ModuleChunk chunk, String args, String rawVmOptions) {
        List params = ParametersListUtil.parse((String)args);
        ArrayList<String> vmOptions = new ArrayList<String>(ParametersListUtil.parse((String)rawVmOptions));
        Iterator iterator = params.iterator();
        while (iterator.hasNext()) {
            String option = (String)iterator.next();
            if (!"-javaAgentClass".equals(option)) continue;
            String agentClass = (String)iterator.next();
            vmOptions.add("-javaagent:" + GreclipseBuilder.locateAgentJar(chunk, agentClass));
        }
        return vmOptions;
    }

    private static String locateAgentJar(ModuleChunk chunk, String agentClassName) {
        String string;
        Collection files = ProjectPaths.getCompilationClasspathFiles((ModuleChunk)chunk, (boolean)chunk.containsTests(), (boolean)false, (boolean)false);
        URL[] urls = new URL[files.size()];
        int i = 0;
        for (File file : files) {
            try {
                urls[i] = file.toURI().toURL();
                ++i;
            }
            catch (MalformedURLException e) {
                LOG.warn("Malformed dependency: " + file);
            }
        }
        URLClassLoader dependenciesLoader = new URLClassLoader(urls, StandardJavaFileManager.class.getClassLoader());
        try {
            Class<?> agentClass = Class.forName(agentClassName, false, dependenciesLoader);
            URL agentUrl = agentClass.getProtectionDomain().getCodeSource().getLocation();
            File agentClassFile = new File(URLDecoder.decode(agentUrl.getPath(), StandardCharsets.UTF_8));
            string = agentClassFile.getAbsolutePath();
        }
        catch (Throwable throwable) {
            try {
                try {
                    dependenciesLoader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        dependenciesLoader.close();
        return string;
    }

    private static String getClasspathString(ModuleChunk chunk) {
        LinkedHashSet<String> cp = new LinkedHashSet<String>();
        for (File file : ProjectPaths.getCompilationClasspathFiles((ModuleChunk)chunk, (boolean)chunk.containsTests(), (boolean)false, (boolean)false)) {
            if (!file.exists()) continue;
            cp.add(FileUtil.toCanonicalPath((String)file.getPath()));
        }
        return StringUtil.join(cp, (String)File.pathSeparator);
    }

    @NotNull
    public String getPresentableName() {
        String string = GroovyJpsBundle.message("compiler.name.greclipse", new Object[0]);
        if (string == null) {
            GreclipseBuilder.$$$reportNull$$$0(1);
        }
        return string;
    }

    public long getExpectedBuildTime() {
        return 100L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/incremental/groovy/GreclipseBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilableFileExtensions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

