/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.execution.Location;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleTaskLocation;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.gradle.settings.GradleExtensionsSettings;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public final class GradleGroovyRunnerUtil {
    @NotNull
    public static List<String> getTasksTarget(@NotNull PsiElement element, @Nullable Module module) {
        GrMethodCallExpression methodCallExpression;
        if (element == null) {
            GradleGroovyRunnerUtil.$$$reportNull$$$0(0);
        }
        PsiElement parent = element;
        while (parent.getParent() != null && !(parent.getParent() instanceof PsiFile)) {
            parent = parent.getParent();
        }
        if (parent instanceof GrMethodCallExpression) {
            GrMethodCallExpression methodCall = (GrMethodCallExpression)parent;
            String taskName = GradleGroovyRunnerUtil.getTaskNameIfMethodDeclaresIt(methodCall);
            if (taskName != null) {
                List<String> list = Collections.singletonList(taskName);
                if (list == null) {
                    GradleGroovyRunnerUtil.$$$reportNull$$$0(1);
                }
                return list;
            }
        } else if (parent instanceof GrApplicationStatement) {
            PsiElement shiftExpression = parent.getChildren()[1].getChildren()[0];
            if (GradleResolverUtil.isLShiftElement(shiftExpression)) {
                PsiElement shiftiesChild = shiftExpression.getChildren()[0];
                if (shiftiesChild instanceof GrReferenceExpression) {
                    List<String> list = Collections.singletonList(shiftiesChild.getText());
                    if (list == null) {
                        GradleGroovyRunnerUtil.$$$reportNull$$$0(2);
                    }
                    return list;
                }
                if (shiftiesChild instanceof GrMethodCallExpression) {
                    List<String> list = Collections.singletonList(shiftiesChild.getChildren()[0].getText());
                    if (list == null) {
                        GradleGroovyRunnerUtil.$$$reportNull$$$0(3);
                    }
                    return list;
                }
            } else if (shiftExpression instanceof GrMethodCallExpression) {
                List<String> list = Collections.singletonList(shiftExpression.getChildren()[0].getText());
                if (list == null) {
                    GradleGroovyRunnerUtil.$$$reportNull$$$0(4);
                }
                return list;
            }
        }
        if ((methodCallExpression = (GrMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, GrMethodCallExpression.class)) != null) {
            GradleExtensionsSettings.GradleTask gradleTask;
            GradleExtensionsSettings.GradleExtensionsData extensionsData;
            String taskNameCandidate = methodCallExpression.getChildren()[0].getText();
            Project project = element.getProject();
            if (module == null) {
                module = GradleGroovyRunnerUtil.getModule(element, project);
            }
            if ((extensionsData = GradleExtensionsSettings.getInstance((Project)project).getExtensionsFor(module)) != null && (gradleTask = (GradleExtensionsSettings.GradleTask)extensionsData.tasksMap.get(taskNameCandidate)) != null) {
                List<String> list = Collections.singletonList(taskNameCandidate);
                if (list == null) {
                    GradleGroovyRunnerUtil.$$$reportNull$$$0(5);
                }
                return list;
            }
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            GradleGroovyRunnerUtil.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    private static String getTaskNameIfMethodDeclaresIt(GrMethodCallExpression methodCall) {
        String taskNameCandidate = GradleGroovyRunnerUtil.getStringValueFromFirstArg(methodCall);
        if (taskNameCandidate == null) {
            return null;
        }
        PsiMethod resolvedMethod = methodCall.resolveMethod();
        if (resolvedMethod == null) {
            return null;
        }
        PsiClass containingClass = resolvedMethod.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        String methodName = resolvedMethod.getName();
        if (GradleGroovyRunnerUtil.declaresTaskFromTaskContainer(methodName, containingClass) || GradleGroovyRunnerUtil.declaresTaskFromTaskCollection(methodName, containingClass) || GradleGroovyRunnerUtil.declaresTaskFromProject(methodName, containingClass)) {
            return taskNameCandidate;
        }
        return null;
    }

    private static boolean declaresTaskFromTaskContainer(String methodName, PsiClass containingClass) {
        return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.gradle.api.tasks.TaskContainer") && ("create".equals(methodName) || "register".equals(methodName));
    }

    private static boolean declaresTaskFromTaskCollection(String methodName, PsiClass containingClass) {
        return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.gradle.api.tasks.TaskCollection") && "named".equals(methodName);
    }

    private static boolean declaresTaskFromProject(String methodName, PsiClass containingClass) {
        return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.gradle.api.Project") && "task".equals(methodName);
    }

    private static String getStringValueFromFirstArg(GrMethodCallExpression methodCall) {
        GrLiteral literalArg;
        Object object;
        GrExpression[] arguments = methodCall.getExpressionArguments();
        if (arguments.length > 0 && (object = arguments[0]) instanceof GrLiteral && (object = (literalArg = (GrLiteral)object).getValue()) instanceof String) {
            String stringArg = (String)object;
            return stringArg;
        }
        return null;
    }

    @Nullable
    private static Module getModule(@NotNull PsiElement element, @NotNull Project project) {
        VirtualFile virtualFile;
        PsiFile containingFile;
        if (element == null) {
            GradleGroovyRunnerUtil.$$$reportNull$$$0(7);
        }
        if (project == null) {
            GradleGroovyRunnerUtil.$$$reportNull$$$0(8);
        }
        if ((containingFile = element.getContainingFile()) != null && (virtualFile = containingFile.getVirtualFile()) != null) {
            return ProjectFileIndex.getInstance((Project)project).getModuleForFile(virtualFile);
        }
        return null;
    }

    @NotNull
    public static List<String> getTasksTarget(@Nullable Location location) {
        if (location == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GradleGroovyRunnerUtil.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (location instanceof GradleTaskLocation) {
            List list = ((GradleTaskLocation)location).getTasks();
            if (list == null) {
                GradleGroovyRunnerUtil.$$$reportNull$$$0(10);
            }
            return list;
        }
        Module module = location.getModule();
        return GradleGroovyRunnerUtil.getTasksTarget(location.getPsiElement(), module);
    }

    @NotNull
    public static List<String> getTasksTarget(@NotNull PsiElement element) {
        if (element == null) {
            GradleGroovyRunnerUtil.$$$reportNull$$$0(11);
        }
        return GradleGroovyRunnerUtil.getTasksTarget(element, null);
    }

    @Nullable
    static String getTaskNameIfContains(PsiElement element) {
        String taskNameCandidate = GradleGroovyRunnerUtil.getTaskNameCandidate(element);
        if (Strings.isEmpty((String)taskNameCandidate)) {
            return null;
        }
        List<String> tasks = GradleGroovyRunnerUtil.getTasksTarget(element);
        if (!tasks.isEmpty() && tasks.contains(taskNameCandidate)) {
            return taskNameCandidate;
        }
        return null;
    }

    @Nullable
    private static String getTaskNameCandidate(PsiElement element) {
        LeafElement leaf;
        block6: {
            block5: {
                if (!(element instanceof LeafElement)) break block5;
                leaf = (LeafElement)element;
                if (!(element instanceof PsiWhiteSpace) && !(element instanceof PsiComment)) break block6;
            }
            return null;
        }
        if (GradleGroovyRunnerUtil.parentIsReferenceInMethodCall(element)) {
            return element.getText().trim();
        }
        if (GradleGroovyRunnerUtil.isLiteralArgumentOfMethodCall(element) && (leaf.getElementType() == GroovyElementTypes.STRING_SQ || leaf.getElementType() == GroovyElementTypes.STRING_DQ)) {
            return leaf.getText().substring(1, leaf.getText().length() - 1);
        }
        return null;
    }

    private static boolean parentIsReferenceInMethodCall(@NotNull PsiElement element) {
        if (element == null) {
            GradleGroovyRunnerUtil.$$$reportNull$$$0(12);
        }
        return element.getParent() instanceof GrReferenceExpression && element.getParent().getParent() instanceof GrMethodCallExpression;
    }

    private static boolean isLiteralArgumentOfMethodCall(@NotNull PsiElement element) {
        GrArgumentList argumentList;
        GrLiteral literal;
        PsiElement psiElement;
        if (element == null) {
            GradleGroovyRunnerUtil.$$$reportNull$$$0(13);
        }
        return (psiElement = element.getParent()) instanceof GrLiteral && (psiElement = (literal = (GrLiteral)psiElement).getParent()) instanceof GrArgumentList && (argumentList = (GrArgumentList)psiElement).getParent() instanceof GrMethodCallExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/GradleGroovyRunnerUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/GradleGroovyRunnerUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasksTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTasksTarget";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parentIsReferenceInMethodCall";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isLiteralArgumentOfMethodCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 9, 10 -> new IllegalStateException(string);
        };
    }
}

