/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemTelemetryUtil;
import com.intellij.openapi.externalSystem.util.OutputWrapper;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.lang.JavaVersion;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.logging.LogLevel;
import org.gradle.process.internal.JvmOptions;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.GradleConnectorService;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.properties.GradleProperties;
import org.jetbrains.plugins.gradle.properties.GradlePropertiesFile;
import org.jetbrains.plugins.gradle.properties.models.Property;
import org.jetbrains.plugins.gradle.service.execution.GradleCommandLineUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleProgressListener;
import org.jetbrains.plugins.gradle.service.execution.SystemPropertiesAdjuster;
import org.jetbrains.plugins.gradle.service.execution.cmd.GradleCommandLineOptionsProvider;
import org.jetbrains.plugins.gradle.service.project.GradleOperationHelperExtension;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLine;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineOption;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineTask;

public class GradleExecutionHelper {
    private static final Logger LOG = Logger.getInstance(GradleExecutionHelper.class);

    @NotNull
    public BuildLauncher getBuildLauncher(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId id, @NotNull List<String> tasksAndArguments, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(0);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(1);
        }
        if (tasksAndArguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(3);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(4);
        }
        BuildLauncher operation = connection.newBuild();
        GradleExecutionHelper.prepare(connection, (LongRunningOperation)operation, id, tasksAndArguments, settings, listener2);
        BuildLauncher buildLauncher = operation;
        if (buildLauncher == null) {
            GradleExecutionHelper.$$$reportNull$$$0(5);
        }
        return buildLauncher;
    }

    @NotNull
    public TestLauncher getTestLauncher(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId id, @NotNull List<String> tasksAndArguments, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(6);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(7);
        }
        if (tasksAndArguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(9);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(10);
        }
        TestLauncher operation = connection.newTestLauncher();
        GradleExecutionHelper.prepare(connection, (LongRunningOperation)operation, id, tasksAndArguments, settings, listener2);
        TestLauncher testLauncher = operation;
        if (testLauncher == null) {
            GradleExecutionHelper.$$$reportNull$$$0(11);
        }
        return testLauncher;
    }

    public <T> T execute(@NotNull String projectPath, @Nullable GradleExecutionSettings settings, @NotNull Function<? super ProjectConnection, ? extends T> f) {
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(12);
        }
        if (f == null) {
            GradleExecutionHelper.$$$reportNull$$$0(13);
        }
        return this.execute(projectPath, settings, null, null, null, f);
    }

    public <T> T execute(@NotNull String projectPath, @Nullable GradleExecutionSettings settings, @Nullable ExternalSystemTaskId taskId, @Nullable ExternalSystemTaskNotificationListener listener2, @Nullable CancellationToken cancellationToken, @NotNull Function<? super ProjectConnection, ? extends T> f) {
        String projectDir;
        File projectPathFile;
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(14);
        }
        if (f == null) {
            GradleExecutionHelper.$$$reportNull$$$0(15);
        }
        if ((projectPathFile = new File(projectPath)).isFile() && projectPath.endsWith("gradle") && projectPathFile.getParent() != null) {
            List arguments;
            projectDir = projectPathFile.getParent();
            if (settings != null && !(arguments = settings.getArguments()).contains("-b") && !arguments.contains("--build-file")) {
                settings.withArguments(new String[]{"-b", projectPath});
            }
        } else {
            projectDir = projectPath;
        }
        return (T)GradleConnectorService.withGradleConnection(projectDir, taskId, settings, listener2, cancellationToken, connection -> {
            try {
                return SystemPropertiesAdjuster.executeAdjusted(projectDir, () -> f.fun(connection));
            }
            catch (ExternalSystemException | ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.warn("Gradle execution error", e);
                Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
                ExternalSystemException externalSystemException = new ExternalSystemException(ExceptionUtil.getMessage((Throwable)rootCause), e, new String[0]);
                externalSystemException.initCause(e);
                throw externalSystemException;
            }
        });
    }

    public static void prepare(@NotNull ProjectConnection connection, @NotNull LongRunningOperation operation, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(16);
        }
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(17);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(18);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(19);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(20);
        }
        GradleExecutionHelper.prepare(connection, operation, id, Collections.emptyList(), settings, listener2);
    }

    private static void prepare(@NotNull ProjectConnection connection, @NotNull LongRunningOperation operation, @NotNull ExternalSystemTaskId id, @NotNull List<String> tasksAndArguments, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(21);
        }
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(22);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(23);
        }
        if (tasksAndArguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(24);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(25);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(26);
        }
        GradleExecutionHelper.clearSystemProperties(operation);
        GradleExecutionHelper.applyIdeaParameters(settings);
        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, id, listener2, null, settings);
        GradleExecutionHelper.setupJvmArguments(operation, settings, buildEnvironment);
        GradleExecutionHelper.setupLogging(settings, buildEnvironment);
        GradleExecutionHelper.setupArguments(operation, tasksAndArguments, settings);
        GradleExecutionHelper.setupEnvironment(operation, settings);
        GradleExecutionHelper.setupJavaHome(operation, settings);
        GradleExecutionHelper.setupProgressListeners(operation, settings, id, listener2, buildEnvironment);
        GradleExecutionHelper.setupStandardIO(operation, settings, id, listener2);
        GradleOperationHelperExtension.EP_NAME.forEachExtensionSafe(proc -> proc.prepareForExecution(id, operation, settings, buildEnvironment));
    }

    private static void clearSystemProperties(LongRunningOperation operation) {
        operation.withSystemProperties(Collections.emptyMap());
    }

    private static void applyIdeaParameters(@NotNull GradleExecutionSettings settings) {
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(27);
        }
        if (settings.isOfflineWork()) {
            settings.withArgument("--offline");
        }
        settings.withArgument("-Didea.active=true");
        settings.withArgument("-Didea.version=" + GradleExecutionHelper.getIdeaVersion());
        settings.withArgument("-Didea.vendor.name=" + ApplicationInfo.getInstance().getShortCompanyName());
    }

    private static void setupProgressListeners(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable BuildEnvironment buildEnvironment) {
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(28);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(29);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(30);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(31);
        }
        String buildRootDir = GradleExecutionHelper.getBuildRoot(buildEnvironment);
        GradleProgressListener progressListener = new GradleProgressListener(listener2, id, buildRootDir);
        operation.addProgressListener((org.gradle.tooling.ProgressListener)progressListener);
        operation.addProgressListener((ProgressListener)progressListener, new OperationType[]{OperationType.TASK, OperationType.FILE_DOWNLOAD});
        if (settings.isRunAsTest() && settings.isBuiltInTestEventsUsed()) {
            operation.addProgressListener((ProgressListener)progressListener, new OperationType[]{OperationType.TEST, OperationType.TEST_OUTPUT, OperationType.TASK});
        }
    }

    private static void setupStandardIO(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(32);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(33);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(34);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(35);
        }
        operation.setStandardOutput((OutputStream)new OutputWrapper(listener2, id, true));
        operation.setStandardError((OutputStream)new OutputWrapper(listener2, id, false));
        InputStream inputStream = (InputStream)settings.getUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY);
        if (inputStream != null) {
            operation.setStandardInput(inputStream);
        }
    }

    private static void setupJvmArguments(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings, @Nullable BuildEnvironment buildEnvironment) {
        List<String> jvmArgs;
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(36);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(37);
        }
        if (!(jvmArgs = settings.getJvmArguments()).isEmpty()) {
            List<String> merged;
            if (buildEnvironment != null) {
                BuildIdentifier buildIdentifier = GradleExecutionHelper.getBuildIdentifier(buildEnvironment);
                List buildJvmArguments = buildIdentifier == null || "buildSrc".equals(buildIdentifier.getRootDir().getName()) ? ContainerUtil.emptyList() : buildEnvironment.getJava().getJvmArguments();
                merged = GradleExecutionHelper.mergeBuildJvmArguments(buildJvmArguments, jvmArgs);
            } else {
                merged = jvmArgs;
            }
            List filteredArgs = ContainerUtil.mapNotNull((Collection)merged, s -> StringUtil.isEmpty((String)s) ? null : s);
            operation.setJvmArguments(ArrayUtilRt.toStringArray((Collection)filteredArgs));
        }
    }

    private static void setupJavaHome(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings) {
        String javaHome;
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(38);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(39);
        }
        if ((javaHome = settings.getJavaHome()) != null && new File(javaHome).isDirectory()) {
            LOG.debug("Java home to set for Gradle operation: " + javaHome);
            operation.setJavaHome(new File(javaHome));
        }
    }

    private static void setupArguments(@NotNull LongRunningOperation operation, @NotNull List<String> tasksAndArguments, @NotNull GradleExecutionSettings settings) {
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(40);
        }
        if (tasksAndArguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(41);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(42);
        }
        GradleCommandLine commandLine = GradleCommandLineUtil.parseCommandLine(tasksAndArguments, settings.getArguments());
        commandLine = GradleExecutionHelper.fixUpGradleCommandLine(commandLine);
        LOG.info("Passing command-line to Gradle Tooling API: " + StringUtil.join(GradleExecutionHelper.obfuscatePasswordParameters(commandLine.getTokens()), (String)" "));
        if (operation instanceof TestLauncher) {
            TestLauncher testLauncher = (TestLauncher)operation;
            GradleExecutionHelper.setupTestLauncherArguments(testLauncher, commandLine);
        } else if (operation instanceof BuildLauncher) {
            BuildLauncher buildLauncher = (BuildLauncher)operation;
            GradleExecutionHelper.setupBuildLauncherArguments(buildLauncher, commandLine, settings);
        } else {
            operation.withArguments(commandLine.getTokens());
        }
    }

    @NotNull
    private static GradleCommandLine fixUpGradleCommandLine(@NotNull GradleCommandLine commandLine) {
        if (commandLine == null) {
            GradleExecutionHelper.$$$reportNull$$$0(43);
        }
        ArrayList<GradleCommandLineTask> tasks2 = new ArrayList<GradleCommandLineTask>();
        for (GradleCommandLineTask task2 : commandLine.getTasks()) {
            String name = task2.getName();
            List options = ContainerUtil.filter((Collection)task2.getOptions(), it -> !GradleExecutionHelper.isWildcardTestPattern(it));
            tasks2.add(new GradleCommandLineTask(name, options));
        }
        return new GradleCommandLine(tasks2, (List<? extends GradleCommandLineOption>)commandLine.getOptions());
    }

    private static boolean isWildcardTestPattern(@NotNull GradleCommandLineOption option) {
        if (option == null) {
            GradleExecutionHelper.$$$reportNull$$$0(44);
        }
        return option.getName().equals("--tests") && option.getValues().size() == 1 && (option.getValues().get(0).equals("*") || option.getValues().get(0).equals("'*'") || option.getValues().get(0).equals("\"*\""));
    }

    private static void setupTestLauncherArguments(@NotNull TestLauncher testLauncher, @NotNull GradleCommandLine commandLine) {
        if (testLauncher == null) {
            GradleExecutionHelper.$$$reportNull$$$0(45);
        }
        if (commandLine == null) {
            GradleExecutionHelper.$$$reportNull$$$0(46);
        }
        for (GradleCommandLineTask task2 : commandLine.getTasks()) {
            Set<String> patterns = GradleCommandLineUtil.getTestPatterns(task2);
            if (!patterns.isEmpty()) {
                testLauncher.withTestsFor(it -> it.forTaskPath(task2.getName()).includePatterns((Collection)patterns));
                continue;
            }
            testLauncher.forTasks(ArrayUtil.toStringArray(task2.getTokens()));
        }
        testLauncher.withArguments(commandLine.getOptions().getTokens());
    }

    private static void setupBuildLauncherArguments(@NotNull BuildLauncher buildLauncher, @NotNull GradleCommandLine commandLine, @NotNull GradleExecutionSettings settings) {
        if (buildLauncher == null) {
            GradleExecutionHelper.$$$reportNull$$$0(47);
        }
        if (commandLine == null) {
            GradleExecutionHelper.$$$reportNull$$$0(48);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(49);
        }
        buildLauncher.forTasks(ArrayUtil.toStringArray(commandLine.getTasks().getTokens()));
        buildLauncher.withArguments(commandLine.getOptions().getTokens());
        if (settings.isTestTaskRerun()) {
            Path initScript = GradleInitScriptUtil.createTestInitScript();
            buildLauncher.addArguments(new String[]{"--init-script", initScript.toString()});
        }
    }

    private static void setupLogging(@NotNull GradleExecutionSettings settings, @Nullable BuildEnvironment buildEnvironment) {
        Application application;
        String gradleLogLevel;
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(50);
        }
        List arguments = settings.getArguments();
        Collection options = GradleCommandLineOptionsProvider.LOGGING_OPTIONS.getOptions();
        List<String> optionsNames = GradleCommandLineOptionsProvider.getAllOptionsNames(options);
        if (buildEnvironment == null || !GradleExecutionHelper.isRootDirAvailable(buildEnvironment)) {
            return;
        }
        GradleProperties properties = GradlePropertiesFile.INSTANCE.getProperties(settings.getServiceDirectory(), buildEnvironment.getBuildIdentifier().getRootDir().toPath());
        Property<String> loggingLevelProperty = properties.getGradleLoggingLevel();
        String string = gradleLogLevel = loggingLevelProperty != null ? loggingLevelProperty.getValue() : null;
        if (!ContainerUtil.exists(optionsNames, it -> arguments.contains(it)) && gradleLogLevel != null) {
            try {
                LogLevel logLevel = LogLevel.valueOf((String)gradleLogLevel.toUpperCase());
                switch (logLevel) {
                    case DEBUG: {
                        settings.withArgument("-d");
                        break;
                    }
                    case INFO: {
                        settings.withArgument("-i");
                        break;
                    }
                    case WARN: {
                        settings.withArgument("-w");
                        break;
                    }
                    case QUIET: {
                        settings.withArgument("-q");
                    }
                }
            }
            catch (IllegalArgumentException e) {
                LOG.warn("org.gradle.logging.level must be one of quiet, warn, lifecycle, info, or debug");
            }
        }
        if ((application = ApplicationManager.getApplication()) != null && application.isUnitTestMode() && !ContainerUtil.exists(optionsNames, it -> arguments.contains(it))) {
            settings.withArgument("--info");
        }
    }

    private static boolean isRootDirAvailable(@NotNull BuildEnvironment environment) {
        if (environment == null) {
            GradleExecutionHelper.$$$reportNull$$$0(51);
        }
        try {
            environment.getBuildIdentifier().getRootDir();
        }
        catch (UnsupportedMethodException e) {
            return false;
        }
        return true;
    }

    @Nullable
    private static BuildIdentifier getBuildIdentifier(@NotNull BuildEnvironment buildEnvironment) {
        if (buildEnvironment == null) {
            GradleExecutionHelper.$$$reportNull$$$0(52);
        }
        try {
            return buildEnvironment.getBuildIdentifier();
        }
        catch (UnsupportedMethodException unsupportedMethodException) {
            return null;
        }
    }

    @Nullable
    public static String getBuildRoot(@Nullable BuildEnvironment buildEnvironment) {
        if (buildEnvironment == null) {
            return null;
        }
        BuildIdentifier buildIdentifier = GradleExecutionHelper.getBuildIdentifier(buildEnvironment);
        return buildIdentifier == null ? null : buildIdentifier.getRootDir().getPath();
    }

    private static void setupEnvironment(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings) {
        TargetEnvironmentConfigurationProvider environmentConfigurationProvider;
        TargetEnvironmentConfiguration environmentConfiguration;
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(53);
        }
        if (settings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(54);
        }
        if ((environmentConfiguration = (TargetEnvironmentConfiguration)ObjectUtils.doIfNotNull((Object)(environmentConfigurationProvider = ExternalSystemExecutionAware.getEnvironmentConfigurationProvider((ExternalSystemExecutionSettings)settings)), it -> it.getEnvironmentConfiguration())) != null && !"local".equals(environmentConfiguration.getTypeId())) {
            if (settings.isPassParentEnvs()) {
                LOG.warn("Host system environment variables will not be passed for the target run.");
            }
            operation.setEnvironmentVariables(settings.getEnv());
            return;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withEnvironment(settings.getEnv());
        commandLine.withParentEnvironmentType(settings.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        Map effectiveEnvironment = commandLine.getEffectiveEnvironment();
        operation.setEnvironmentVariables(effectiveEnvironment);
    }

    @ApiStatus.Internal
    @VisibleForTesting
    static List<String> mergeBuildJvmArguments(@NotNull List<String> jvmArgs, @NotNull List<String> jvmArgsFromIdeSettings) {
        if (jvmArgs == null) {
            GradleExecutionHelper.$$$reportNull$$$0(55);
        }
        if (jvmArgsFromIdeSettings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(56);
        }
        List<String> mergedJvmArgs = GradleExecutionHelper.mergeJvmArgs(jvmArgs, jvmArgsFromIdeSettings);
        JvmOptions jvmOptions = new JvmOptions(null);
        jvmOptions.setAllJvmArgs(mergedJvmArgs);
        return jvmOptions.getAllJvmArgs();
    }

    @ApiStatus.Internal
    @VisibleForTesting
    static List<String> mergeJvmArgs(@NotNull List<String> jvmArgs, @NotNull List<String> jvmArgsFromIdeSettings) {
        if (jvmArgs == null) {
            GradleExecutionHelper.$$$reportNull$$$0(57);
        }
        if (jvmArgsFromIdeSettings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(58);
        }
        List mergedJvmArgs = ContainerUtil.concat(jvmArgs, jvmArgsFromIdeSettings);
        MultiMap<String, String> argumentsMap = GradleExecutionHelper.parseJvmArgs(mergedJvmArgs);
        LinkedHashMap<String, String> mergedKeys = new LinkedHashMap<String, String>();
        LinkedHashSet argKeySet = new LinkedHashSet(argumentsMap.keySet());
        for (String argKey : argKeySet) {
            Collection values = argumentsMap.getModifiable((Object)argKey);
            if (values.size() == 1 && ((String)values.iterator().next()).isEmpty()) {
                Couple<String> couple = GradleExecutionHelper.splitArg(argKey);
                mergedKeys.put((String)couple.first, (String)couple.second);
                continue;
            }
            mergedKeys.put(argKey, "");
            LinkedHashMap<String, String> mergedArgs = new LinkedHashMap<String, String>();
            for (String jvmArg : values) {
                if (jvmArg.isEmpty()) continue;
                Couple<String> couple = GradleExecutionHelper.splitArg(jvmArg);
                mergedArgs.put((String)couple.first, (String)couple.second);
            }
            values.clear();
            mergedArgs.forEach((key, value) -> values.add(key + value));
        }
        SmartList mergedArgs = new SmartList();
        mergedKeys.forEach((arg_0, arg_1) -> GradleExecutionHelper.lambda$mergeJvmArgs$10((List)mergedArgs, arg_0, arg_1));
        argKeySet.stream().filter(arg_0 -> GradleExecutionHelper.lambda$mergeJvmArgs$11((List)mergedArgs, arg_0)).forEach(arg_0 -> argumentsMap.remove(arg_0));
        argumentsMap.remove((Object)"--add-opens");
        SmartList result = new SmartList();
        argumentsMap.keySet().forEach(arg_0 -> GradleExecutionHelper.lambda$mergeJvmArgs$13(argumentsMap, (List)result, arg_0));
        return result;
    }

    @NotNull
    private static @NotNull MultiMap<@NotNull String, @NotNull String> parseJvmArgs(@NotNull @NotNull List<@NotNull String> args) {
        if (args == null) {
            GradleExecutionHelper.$$$reportNull$$$0(59);
        }
        MultiMap result = MultiMap.createLinkedSet();
        String lastKey = null;
        for (String jvmArg : args) {
            if (jvmArg.startsWith("-")) {
                result.putValue((Object)jvmArg, (Object)"");
                lastKey = jvmArg;
                continue;
            }
            if (lastKey != null) {
                result.putValue((Object)lastKey, (Object)jvmArg);
                lastKey = null;
                continue;
            }
            result.putValue((Object)jvmArg, (Object)"");
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            GradleExecutionHelper.$$$reportNull$$$0(60);
        }
        return multiMap;
    }

    private static Couple<String> splitArg(String arg) {
        int i = arg.indexOf(61);
        return i <= 0 ? Couple.of((Object)arg, (Object)"") : Couple.of((Object)arg.substring(0, i), (Object)arg.substring(i));
    }

    @Nullable
    public static BuildEnvironment getBuildEnvironment(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable CancellationToken cancellationToken, @Nullable GradleExecutionSettings settings) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(61);
        }
        if (taskId == null) {
            GradleExecutionHelper.$$$reportNull$$$0(62);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(63);
        }
        Span span = ExternalSystemTelemetryUtil.getTracer((ProjectSystemId)GradleConstants.SYSTEM_ID).spanBuilder("GetBuildEnvironment").startSpan();
        try {
            BuildEnvironment buildEnvironment;
            block17: {
                Scope ignore = span.makeCurrent();
                try {
                    BuildEnvironment buildEnvironment2 = null;
                    try {
                        String javaHome;
                        ModelBuilder modelBuilder = connection.model(BuildEnvironment.class);
                        if (cancellationToken != null) {
                            modelBuilder.withCancellationToken(cancellationToken);
                        }
                        if (settings != null && (javaHome = settings.getJavaHome()) != null && new File(javaHome).isDirectory()) {
                            modelBuilder.setJavaHome(new File(javaHome));
                        }
                        GradleProgressListener gradleProgressListener = new GradleProgressListener(listener2, taskId);
                        modelBuilder.addProgressListener((org.gradle.tooling.ProgressListener)gradleProgressListener);
                        modelBuilder.addProgressListener((ProgressListener)gradleProgressListener);
                        modelBuilder.setStandardOutput((OutputStream)new OutputWrapper(listener2, taskId, true));
                        modelBuilder.setStandardError((OutputStream)new OutputWrapper(listener2, taskId, false));
                        buildEnvironment2 = (BuildEnvironment)modelBuilder.get();
                    }
                    catch (Throwable t) {
                        span.recordException(t);
                        span.setStatus(StatusCode.ERROR);
                        LOG.warn("Failed to obtain build environment from Gradle daemon.", t);
                    }
                    if (buildEnvironment2 != null) {
                        GradleExecutionHelper.checkThatGradleBuildEnvironmentIsSupportedByIdea(buildEnvironment2);
                    }
                    buildEnvironment = buildEnvironment2;
                    if (ignore == null) break block17;
                }
                catch (Throwable throwable) {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignore.close();
            }
            return buildEnvironment;
        }
        finally {
            span.end();
        }
    }

    private static void checkThatGradleBuildEnvironmentIsSupportedByIdea(@NotNull BuildEnvironment buildEnvironment) {
        if (buildEnvironment == null) {
            GradleExecutionHelper.$$$reportNull$$$0(64);
        }
        GradleVersion gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        LOG.debug("Gradle version: " + gradleVersion);
        if (!GradleJvmSupportMatrix.isGradleSupportedByIdea(gradleVersion)) {
            throw new UnsupportedGradleVersionByIdeaException(gradleVersion);
        }
        File javaHome = buildEnvironment.getJava().getJavaHome();
        List jvmArguments = buildEnvironment.getJava().getJvmArguments();
        LOG.debug("Gradle java home: " + javaHome);
        LOG.debug("Gradle jvm arguments: " + jvmArguments);
        JavaVersion javaVersion = ExternalSystemJdkUtil.getJavaVersion((String)javaHome.getPath());
        if (javaVersion != null && !GradleJvmSupportMatrix.isJavaSupportedByIdea(javaVersion)) {
            throw new UnsupportedGradleJvmByIdeaException(gradleVersion, javaVersion);
        }
    }

    @NotNull
    @VisibleForTesting
    static List<String> obfuscatePasswordParameters(@NotNull List<String> commandLineArguments) {
        if (commandLineArguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(65);
        }
        ArrayList<String> replaced = new ArrayList<String>(commandLineArguments.size());
        String PASSWORD_PARAMETER_IDENTIFIER = ".password=";
        for (String option : commandLineArguments) {
            int index = option.indexOf(".password=");
            if (index == -1) {
                replaced.add(option);
                continue;
            }
            replaced.add(option.substring(0, index + ".password=".length()) + "*********");
        }
        ArrayList<String> arrayList = replaced;
        if (arrayList == null) {
            GradleExecutionHelper.$$$reportNull$$$0(66);
        }
        return arrayList;
    }

    private static String getIdeaVersion() {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        return appInfo.getMajorVersion() + "." + appInfo.getMinorVersion();
    }

    private static /* synthetic */ void lambda$mergeJvmArgs$13(MultiMap argumentsMap, List result, String key) {
        argumentsMap.get((Object)key).forEach(val -> {
            result.add(key);
            if (StringUtil.isNotEmpty((String)val)) {
                result.add(val);
            }
        });
    }

    private static /* synthetic */ boolean lambda$mergeJvmArgs$11(List mergedArgs, String argKey) {
        return !mergedArgs.contains(argKey);
    }

    private static /* synthetic */ void lambda$mergeJvmArgs$10(List mergedArgs, String s1, String s2) {
        mergedArgs.add(s1 + s2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 11, 60, 66 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: 
            case 7: 
            case 18: 
            case 23: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 8: 
            case 24: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksAndArguments";
                break;
            }
            case 3: 
            case 9: 
            case 19: 
            case 25: 
            case 27: 
            case 29: 
            case 33: 
            case 37: 
            case 39: 
            case 42: 
            case 49: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 10: 
            case 20: 
            case 26: 
            case 31: 
            case 35: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 11: 
            case 60: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 17: 
            case 22: 
            case 28: 
            case 32: 
            case 36: 
            case 38: 
            case 40: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 43: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testLauncher";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildLauncher";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 52: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildEnvironment";
                break;
            }
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmArgs";
                break;
            }
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmArgsFromIdeSettings";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildLauncher";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestLauncher";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "parseJvmArgs";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "obfuscatePasswordParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBuildLauncher";
                break;
            }
            case 5: 
            case 11: 
            case 60: 
            case 66: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTestLauncher";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "applyIdeaParameters";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setupProgressListeners";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setupStandardIO";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setupJvmArguments";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setupJavaHome";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setupArguments";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "fixUpGradleCommandLine";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isWildcardTestPattern";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "setupTestLauncherArguments";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "setupBuildLauncherArguments";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "setupLogging";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isRootDirAvailable";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getBuildIdentifier";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "setupEnvironment";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "mergeBuildJvmArguments";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "mergeJvmArgs";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "parseJvmArgs";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getBuildEnvironment";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "checkThatGradleBuildEnvironmentIsSupportedByIdea";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "obfuscatePasswordParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 11, 60, 66 -> new IllegalStateException(string);
        };
    }

    public static class UnsupportedGradleVersionByIdeaException
    extends RuntimeException {
        @NotNull
        private final GradleVersion myGradleVersion;

        public UnsupportedGradleVersionByIdeaException(@NotNull GradleVersion gradleVersion) {
            if (gradleVersion == null) {
                UnsupportedGradleVersionByIdeaException.$$$reportNull$$$0(0);
            }
            super("Unsupported Gradle version");
            this.myGradleVersion = gradleVersion;
        }

        @NotNull
        public GradleVersion getGradleVersion() {
            GradleVersion gradleVersion = this.myGradleVersion;
            if (gradleVersion == null) {
                UnsupportedGradleVersionByIdeaException.$$$reportNull$$$0(1);
            }
            return gradleVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleVersion";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper$UnsupportedGradleVersionByIdeaException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper$UnsupportedGradleVersionByIdeaException";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGradleVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class UnsupportedGradleJvmByIdeaException
    extends RuntimeException {
        @NotNull
        private final GradleVersion myGradleVersion;
        @Nullable
        private final JavaVersion myJavaVersion;

        public UnsupportedGradleJvmByIdeaException(@NotNull GradleVersion gradleVersion, @Nullable JavaVersion javaVersion) {
            if (gradleVersion == null) {
                UnsupportedGradleJvmByIdeaException.$$$reportNull$$$0(0);
            }
            super("Unsupported Gradle JVM version");
            this.myGradleVersion = gradleVersion;
            this.myJavaVersion = javaVersion;
        }

        @NotNull
        public GradleVersion getGradleVersion() {
            GradleVersion gradleVersion = this.myGradleVersion;
            if (gradleVersion == null) {
                UnsupportedGradleJvmByIdeaException.$$$reportNull$$$0(1);
            }
            return gradleVersion;
        }

        @Nullable
        public JavaVersion getJavaVersion() {
            return this.myJavaVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleVersion";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper$UnsupportedGradleJvmByIdeaException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper$UnsupportedGradleJvmByIdeaException";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGradleVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

