/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.properties;

import com.intellij.openapi.externalSystem.util.environment.Environment;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.properties.GradleProperties;
import org.jetbrains.plugins.gradle.properties.GradlePropertiesImpl;
import org.jetbrains.plugins.gradle.properties.models.Property;
import org.jetbrains.plugins.gradle.properties.models.PropertyKt;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010\u0011\u001a\u0004\u0018\u00010\tJ\u001d\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\t0\t2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/gradle/properties/GradlePropertiesFile;", "", "<init>", "()V", "getProperties", "Lorg/jetbrains/plugins/gradle/properties/GradleProperties;", "project", "Lcom/intellij/openapi/project/Project;", "projectPath", "Ljava/nio/file/Path;", "serviceDirectoryStr", "", "findAndMergeProperties", "possiblePropertiesFiles", "", "getPossiblePropertiesFiles", "getGradleServiceDirectoryPath", "getGradleHomePropertiesPath", "getGradleProjectPropertiesPath", "kotlin.jvm.PlatformType", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;", "loadGradleProperties", "propertiesPath", "mergeGradleProperties", "most", "other", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradlePropertiesFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradlePropertiesFile.kt\norg/jetbrains/plugins/gradle/properties/GradlePropertiesFile\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n2210#2,7:106\n1#3:113\n*S KotlinDebug\n*F\n+ 1 GradlePropertiesFile.kt\norg/jetbrains/plugins/gradle/properties/GradlePropertiesFile\n*L\n38#1:106,7\n*E\n"})
public final class GradlePropertiesFile {
    @NotNull
    public static final GradlePropertiesFile INSTANCE = new GradlePropertiesFile();

    private GradlePropertiesFile() {
    }

    @JvmStatic
    @NotNull
    public static final GradleProperties getProperties(@NotNull Project project2, @NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return INSTANCE.findAndMergeProperties(INSTANCE.getPossiblePropertiesFiles(project2, projectPath));
    }

    @NotNull
    public final GradleProperties getProperties(@Nullable String serviceDirectoryStr, @NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return this.findAndMergeProperties(this.getPossiblePropertiesFiles(serviceDirectoryStr, projectPath));
    }

    /*
     * WARNING - void declaration
     */
    private final GradleProperties findAndMergeProperties(List<? extends Path> possiblePropertiesFiles) {
        Sequence $this$reduce$iv = SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)possiblePropertiesFiles), GradlePropertiesFile::findAndMergeProperties$lambda$0), (Function1)((Function1)new Function1<Path, GradleProperties>((Object)this){

            public final GradleProperties invoke(Path p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return GradlePropertiesFile.access$loadGradleProperties((GradlePropertiesFile)this.receiver, p0);
            }
        }));
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty sequence can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p1;
            GradleProperties gradleProperties = (GradleProperties)iterator$iv.next();
            GradleProperties p0 = (GradleProperties)accumulator$iv;
            boolean $i$f$findAndMergeProperties$stub_for_inlining = false;
            boolean bl = false;
            accumulator$iv = this.mergeGradleProperties(p0, (GradleProperties)p1);
        }
        return (GradleProperties)accumulator$iv;
    }

    private final List<Path> getPossiblePropertiesFiles(Project project2, Path projectPath) {
        Object[] objectArray = new Path[]{this.getGradleServiceDirectoryPath(project2), this.getGradleHomePropertiesPath(), this.getGradleProjectPropertiesPath(projectPath)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final List<Path> getPossiblePropertiesFiles(String serviceDirectoryStr, Path projectPath) {
        Object[] objectArray = new Path[]{this.getGradleServiceDirectoryPath(serviceDirectoryStr), this.getGradleHomePropertiesPath(), this.getGradleProjectPropertiesPath(projectPath)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final Path getGradleServiceDirectoryPath(Project project2) {
        String string = GradleLocalSettings.getInstance(project2).getGradleUserHome();
        if (string == null) {
            return null;
        }
        String gradleUserHome = string;
        String[] stringArray = new String[]{"gradle.properties"};
        return Paths.get(gradleUserHome, stringArray);
    }

    private final Path getGradleServiceDirectoryPath(String serviceDirectoryStr) {
        Path path;
        String string = serviceDirectoryStr;
        if (string != null) {
            String it = string;
            boolean bl = false;
            String[] stringArray = new String[]{"gradle.properties"};
            path = Paths.get(serviceDirectoryStr, stringArray);
        } else {
            path = null;
        }
        return path;
    }

    @Nullable
    public final Path getGradleHomePropertiesPath() {
        String gradleUserHome = Environment.Companion.getVariable("GRADLE_USER_HOME");
        if (gradleUserHome != null) {
            String[] stringArray = new String[]{"gradle.properties"};
            return Paths.get(gradleUserHome, stringArray);
        }
        String userHome = Environment.Companion.getProperty("user.home");
        if (userHome != null) {
            String[] stringArray = new String[]{".gradle", "gradle.properties"};
            return Paths.get(userHome, stringArray);
        }
        return null;
    }

    private final Path getGradleProjectPropertiesPath(Path projectPath) {
        return projectPath.resolve("gradle.properties");
    }

    private final GradleProperties loadGradleProperties(Path propertiesPath) {
        Properties properties = GradleUtil.readGradleProperties(propertiesPath);
        if (properties == null) {
            return GradleProperties.EMPTY.INSTANCE;
        }
        Properties properties2 = properties;
        return new GradlePropertiesImpl(PropertyKt.getStringProperty(properties2, "org.gradle.java.home", propertiesPath), PropertyKt.getStringProperty(properties2, "org.gradle.logging.level", propertiesPath), PropertyKt.getBooleanProperty(properties2, "org.gradle.parallel", propertiesPath), PropertyKt.getBooleanProperty(properties2, "org.gradle.unsafe.isolated-projects", propertiesPath), PropertyKt.getStringProperty(properties2, "org.gradle.jvmargs", propertiesPath));
    }

    private final GradleProperties mergeGradleProperties(GradleProperties most, GradleProperties other) {
        GradleProperties gradleProperties;
        if (most instanceof GradleProperties.EMPTY) {
            gradleProperties = other;
        } else if (other instanceof GradleProperties.EMPTY) {
            gradleProperties = most;
        } else {
            Property<String> property;
            Property<Boolean> property2;
            Property<Boolean> property3;
            Property<String> property4;
            Property<String> property5 = most.getJavaHomeProperty();
            if (property5 == null) {
                property5 = other.getJavaHomeProperty();
            }
            if ((property4 = most.getGradleLoggingLevel()) == null) {
                property4 = other.getGradleLoggingLevel();
            }
            if ((property3 = most.getParallel()) == null) {
                property3 = other.getParallel();
            }
            if ((property2 = most.getIsolatedProjects()) == null) {
                property2 = other.getIsolatedProjects();
            }
            if ((property = most.getJvmOptions()) == null) {
                property = other.getJvmOptions();
            }
            gradleProperties = new GradlePropertiesImpl(property5, property4, property3, property2, property);
        }
        return gradleProperties;
    }

    private static final Path findAndMergeProperties$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toAbsolutePath().normalize();
    }

    public static final /* synthetic */ GradleProperties access$loadGradleProperties(GradlePropertiesFile $this, Path propertiesPath) {
        return $this.loadGradleProperties(propertiesPath);
    }
}

