/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.ReferencesKt;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImports;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyStarImport;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassProcessor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/ReferenceExpressionClassProcessor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/ClassProcessor;", "name", "", "place", "Lcom/intellij/psi/PsiElement;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "isVanilla", "", "isImportedViaStarImport", "state", "Lcom/intellij/psi/ResolveState;", "skip", "result", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "element", "intellij.groovy.psi"})
public final class ReferenceExpressionClassProcessor
extends ClassProcessor {
    private final boolean isVanilla;

    public ReferenceExpressionClassProcessor(@NotNull String name, @NotNull PsiElement place) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        super(name, place, null, false, 12, null);
        this.isVanilla = ReferencesKt.isVanillaClassName(name);
    }

    private final boolean isImportedViaStarImport(ResolveState state) {
        return state.get(GroovyImports.getImportKey()) instanceof GroovyStarImport;
    }

    private final boolean skip(ResolveState state) {
        return !this.isVanilla && this.isImportedViaStarImport(state);
    }

    @Override
    @Nullable
    protected GroovyResolveResult result(@NotNull PsiElement element, @NotNull ResolveState state) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.skip(state) ? null : super.result(element, state);
    }
}

