/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.imports;

import com.intellij.psi.PsiElementVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyFileImports;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImports;
import org.jetbrains.plugins.groovy.lang.resolve.imports.ReferencedImportsSearcher;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"unusedImports", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/toplevel/imports/GrImportStatement;", "file", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFile;", "usedImports", "intellij.groovy.psi"})
@JvmName(name="GroovyUnusedImportUtil")
public final class GroovyUnusedImportUtil {
    @NotNull
    public static final Set<GrImportStatement> unusedImports(@NotNull GroovyFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Set result2 = CollectionsKt.toMutableSet((Iterable)GroovyImports.getValidImportStatements(file));
        CollectionsKt.removeAll((Collection)result2, (Iterable)GroovyUnusedImportUtil.usedImports(file));
        return result2;
    }

    @NotNull
    public static final Set<GrImportStatement> usedImports(@NotNull GroovyFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GroovyFileImports groovyFileImports = file.getImports();
        Intrinsics.checkNotNullExpressionValue((Object)groovyFileImports, (String)"getImports(...)");
        GroovyFileImports imports2 = groovyFileImports;
        boolean bl = false;
        ReferencedImportsSearcher searcher = new ReferencedImportsSearcher();
        file.accept((PsiElementVisitor)searcher);
        Pair<Set<GrImportStatement>, Set<String>> pair = searcher.getResults();
        Set referencedStatements = (Set)pair.component1();
        Set unresolvedReferenceNames = (Set)pair.component2();
        HashSet usedStatements = new HashSet(referencedStatements);
        CollectionsKt.removeAll((Collection)usedStatements, (Iterable)imports2.findUnnecessaryStatements());
        CollectionsKt.addAll((Collection)usedStatements, (Iterable)imports2.findUnresolvedStatements(unresolvedReferenceNames));
        return usedStatements;
    }
}

