/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypeConstants;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrCharConverter;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J*\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrPrimitiveCastConverter;", "Lorg/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter;", "<init>", "()V", "isApplicableTo", "", "position", "Lorg/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter$Position;", "isConvertible", "Lorg/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/ConversionResult;", "lType", "Lcom/intellij/psi/PsiType;", "rType", "context", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElement;", "Companion", "intellij.groovy.psi"})
public final class GrPrimitiveCastConverter
extends GrTypeConverter {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Integer[] numericRanks;

    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.Position position) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        return position == GrTypeConverter.Position.EXPLICIT_CAST;
    }

    @Override
    @Nullable
    public ConversionResult isConvertible(@NotNull PsiType lType, @NotNull PsiType rType, @NotNull GrTypeConverter.Position position, @NotNull GroovyPsiElement context) {
        Intrinsics.checkNotNullParameter((Object)lType, (String)"lType");
        Intrinsics.checkNotNullParameter((Object)rType, (String)"rType");
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)Companion.unbox(lType), (Object)rType)) {
            return ConversionResult.OK;
        }
        if (Intrinsics.areEqual((Object)Companion.unbox(rType), (Object)lType)) {
            return ConversionResult.OK;
        }
        if (Intrinsics.areEqual((Object)rType, (Object)PsiTypes.voidType())) {
            return ConversionResult.ERROR;
        }
        if (lType.equalsToText("java.lang.Object") || rType.equalsToText("java.lang.Object")) {
            return ConversionResult.OK;
        }
        if (Intrinsics.areEqual((Object)lType, (Object)PsiTypes.voidType())) {
            return ConversionResult.ERROR;
        }
        if (Intrinsics.areEqual((Object)rType, (Object)PsiTypes.nullType())) {
            if (Intrinsics.areEqual((Object)lType, (Object)PsiTypes.booleanType()) || !(lType instanceof PsiPrimitiveType)) {
                return ConversionResult.OK;
            }
            return ConversionResult.ERROR;
        }
        if (Intrinsics.areEqual((Object)Companion.unbox(lType), (Object)PsiTypes.voidType()) || Intrinsics.areEqual((Object)Companion.unbox(rType), (Object)PsiTypes.voidType())) {
            return ConversionResult.ERROR;
        }
        if (Intrinsics.areEqual((Object)lType, (Object)PsiTypes.booleanType()) || Intrinsics.areEqual((Object)Companion.unbox(lType), (Object)PsiTypes.booleanType()) || Intrinsics.areEqual((Object)rType, (Object)PsiTypes.booleanType()) || Intrinsics.areEqual((Object)Companion.unbox(rType), (Object)PsiTypes.booleanType())) {
            return ConversionResult.ERROR;
        }
        if (Intrinsics.areEqual((Object)Companion.unbox(lType), (Object)PsiTypes.charType()) || Intrinsics.areEqual((Object)Companion.unbox(rType), (Object)PsiTypes.charType())) {
            return ConversionResult.ERROR;
        }
        int lRank = TypeConstants.getTypeRank(lType);
        if (Intrinsics.areEqual((Object)rType, (Object)PsiTypes.charType())) {
            return ArraysKt.contains((Object[])numericRanks, (Object)lRank) ? ConversionResult.OK : ConversionResult.ERROR;
        }
        int rRank = TypeConstants.getTypeRank(rType);
        if (Intrinsics.areEqual((Object)lType, (Object)PsiTypes.charType())) {
            return GrCharConverter.checkSingleSymbolLiteral(context) || rType instanceof PsiPrimitiveType && ArraysKt.contains((Object[])numericRanks, (Object)rRank) ? ConversionResult.OK : ConversionResult.ERROR;
        }
        return ArraysKt.contains((Object[])numericRanks, (Object)lRank) && ArraysKt.contains((Object[])numericRanks, (Object)rRank) ? ConversionResult.OK : null;
    }

    static {
        Integer[] integerArray = new Integer[]{1, 3, 4, 5, 6, 7, 8, 9};
        numericRanks = integerArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006*\u00020\u0007R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrPrimitiveCastConverter$Companion;", "", "<init>", "()V", "unbox", "Lcom/intellij/psi/PsiPrimitiveType;", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/psi/PsiType;", "numericRanks", "", "", "getNumericRanks", "()[Ljava/lang/Integer;", "[Ljava/lang/Integer;", "intellij.groovy.psi"})
    private static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PsiPrimitiveType unbox(@NotNull PsiType $this$unbox) {
            Intrinsics.checkNotNullParameter((Object)$this$unbox, (String)"<this>");
            return PsiPrimitiveType.getUnboxedType((PsiType)$this$unbox);
        }

        @NotNull
        public final Integer[] getNumericRanks() {
            return numericRanks;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

