/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.GrUnresolvedAccessInspection;
import org.jetbrains.plugins.groovy.highlighter.GroovySyntaxHighlighter;
import org.jetbrains.plugins.groovy.highlighting.HighlightSink;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J9\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J3\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\b\b\u0001\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/UnresolvedReferenceInspectionSink;", "Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "registerProblem", "", "highlightElement", "Lcom/intellij/psi/PsiElement;", "highlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "message", "", "fixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/codeInspection/ProblemHighlightType;Ljava/lang/String;[Lcom/intellij/codeInspection/LocalQuickFix;)V", "handleSpecial", "", "element", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/codeInspection/LocalQuickFix;)Z", "intellij.groovy.psi"})
public final class UnresolvedReferenceInspectionSink
implements HighlightSink {
    @NotNull
    private final ProblemsHolder problemsHolder;

    public UnresolvedReferenceInspectionSink(@NotNull ProblemsHolder problemsHolder) {
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        this.problemsHolder = problemsHolder;
    }

    @Override
    public void registerProblem(@NotNull PsiElement highlightElement, @NotNull ProblemHighlightType highlightType, @NotNull String message, LocalQuickFix ... fixes) {
        Intrinsics.checkNotNullParameter((Object)highlightElement, (String)"highlightElement");
        Intrinsics.checkNotNullParameter((Object)highlightType, (String)"highlightType");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
        if (this.problemsHolder.isOnTheFly() && highlightType == ProblemHighlightType.LIKE_UNKNOWN_SYMBOL && this.handleSpecial(highlightElement, message, Arrays.copyOf(fixes, fixes.length))) {
            return;
        }
        this.problemsHolder.registerProblem(highlightElement, message, highlightType, Arrays.copyOf(fixes, fixes.length));
    }

    private final boolean handleSpecial(PsiElement element, @InspectionMessage String message, LocalQuickFix ... fixes) {
        HighlightDisplayLevel highlightDisplayLevel = GrUnresolvedAccessInspection.Companion.getHighlightDisplayLevel(element);
        if (Intrinsics.areEqual((Object)highlightDisplayLevel, (Object)HighlightDisplayLevel.ERROR)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)highlightDisplayLevel, (Object)HighlightDisplayLevel.WEAK_WARNING)) {
            ProblemHighlightType newHighlightType = ApplicationManager.getApplication().isUnitTestMode() ? ProblemHighlightType.WARNING : ProblemHighlightType.INFORMATION;
            ProblemDescriptor problemDescriptor = this.problemsHolder.getManager().createProblemDescriptor(element, message, this.problemsHolder.isOnTheFly(), fixes, newHighlightType);
            Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
            ProblemDescriptor descriptor = problemDescriptor;
            descriptor.setTextAttributes(GroovySyntaxHighlighter.UNRESOLVED_ACCESS);
            this.problemsHolder.registerProblem(descriptor);
            return true;
        }
        this.problemsHolder.registerProblem(element, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf(fixes, fixes.length));
        return true;
    }
}

