/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.elements;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmValue;
import com.intellij.lang.jvm.actions.ActionRequest;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.CreateFieldRequest;
import com.intellij.lang.jvm.actions.CreateMethodRequest;
import com.intellij.lang.jvm.actions.CreatePropertyActionGroup;
import com.intellij.lang.jvm.actions.CreateReadOnlyPropertyActionGroup;
import com.intellij.lang.jvm.actions.ExpectedParameter;
import com.intellij.lang.jvm.actions.ExpectedType;
import com.intellij.lang.jvm.actions.JvmActionGroup;
import com.intellij.lang.jvm.actions.JvmGroupIntentionAction;
import com.intellij.lang.jvm.types.JvmSubstitutor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JvmPsiConversionHelper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateFieldAction;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.CreateMemberAction;
import org.jetbrains.plugins.groovy.annotator.intentions.elements.JvmPsiUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PropertyUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001'B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0016J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J$\u0010\u001f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0013H\u0002J\b\u0010\"\u001a\u00020\u0012H\u0016J%\u0010#\u001a\u00020$2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010%\u001a\u00020&H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/CreatePropertyAction;", "Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/CreateMemberAction;", "Lcom/intellij/lang/jvm/actions/JvmGroupIntentionAction;", "target", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "request", "Lcom/intellij/lang/jvm/actions/CreateMethodRequest;", "readOnly", "", "<init>", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;Lcom/intellij/lang/jvm/actions/CreateMethodRequest;Z)V", "getRequest", "()Lcom/intellij/lang/jvm/actions/CreateMethodRequest;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "propertyInfo", "Lkotlin/Pair;", "", "Lcom/intellij/lang/java/beans/PropertyKind;", "getPropertyInfo", "()Lkotlin/Pair;", "getRenderData", "Lcom/intellij/lang/jvm/actions/JvmActionGroup$RenderData;", "getFamilyName", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "counterPart", "propertyKind", "getText", "invoke", "", "getActionGroup", "Lcom/intellij/lang/jvm/actions/JvmActionGroup;", "PropertyRequest", "intellij.groovy"})
public final class CreatePropertyAction
extends CreateMemberAction
implements JvmGroupIntentionAction {
    @NotNull
    private final CreateMethodRequest request;
    private final boolean readOnly;
    @NotNull
    private final Project project;

    public CreatePropertyAction(@NotNull GrTypeDefinition target, @NotNull CreateMethodRequest request, boolean readOnly) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        super(target, (ActionRequest)request);
        this.request = request;
        this.readOnly = readOnly;
        Project project = target.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
    }

    @NotNull
    protected CreateMethodRequest getRequest() {
        return this.request;
    }

    private final Pair<String, PropertyKind> getPropertyInfo() {
        String string = this.getRequest().getMethodName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMethodName(...)");
        Pair<String, PropertyKind> pair = PropertyUtilKt.getPropertyNameAndKind(string);
        if (pair == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        return pair;
    }

    @NotNull
    public JvmActionGroup.RenderData getRenderData() {
        return () -> CreatePropertyAction.getRenderData$lambda$0(this);
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message((String)"create.property.from.usage.family", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new CreateFieldAction(this.getTarget(), new PropertyRequest(), false).generatePreview(project, editor, file);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!super.isAvailable(project, editor, file)) {
            return false;
        }
        String string = this.getRequest().getMethodName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMethodName(...)");
        Pair<String, PropertyKind> pair = PropertyUtilKt.getPropertyNameAndKind(string);
        if (pair == null) {
            return false;
        }
        Pair<String, PropertyKind> pair2 = pair;
        String propertyName = (String)pair2.component1();
        PropertyKind propertyKind = (PropertyKind)pair2.component2();
        if (propertyKind == PropertyKind.SETTER && this.readOnly) {
            return false;
        }
        List list = this.getRequest().getExpectedParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpectedParameters(...)");
        List parameters = list;
        switch (WhenMappings.$EnumSwitchMapping$0[propertyKind.ordinal()]) {
            case 1: 
            case 2: {
                if (!(!((Collection)parameters).isEmpty())) break;
                return false;
            }
            case 3: {
                if (parameters.size() == 1) break;
                return false;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String counterAccessorName = PropertyUtilKt.getAccessorName(this.counterPart(propertyKind), propertyName);
        PsiMethod[] psiMethodArray = this.getTarget().findMethodsByName(counterAccessorName, false);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
        return ((Object[])psiMethodArray).length == 0;
    }

    private final PropertyKind counterPart(PropertyKind propertyKind) {
        return switch (WhenMappings.$EnumSwitchMapping$0[propertyKind.ordinal()]) {
            case 1, 2 -> PropertyKind.SETTER;
            case 3 -> {
                List v1 = this.getRequest().getExpectedParameters();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getExpectedParameters(...)");
                List v2 = ((ExpectedParameter)CollectionsKt.single((List)v1)).getExpectedTypes();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getExpectedTypes(...)");
                ExpectedType expectedType = (ExpectedType)CollectionsKt.singleOrNull((List)v2);
                if (expectedType != null && Intrinsics.areEqual((Object)PsiTypes.booleanType(), (Object)JvmPsiConversionHelper.getInstance((Project)this.project).convertType(expectedType.getTheType()))) {
                    yield PropertyKind.BOOLEAN_GETTER;
                }
                yield PropertyKind.GETTER;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public String getText() {
        String string;
        String propertyName = GroovyPropertyUtils.getPropertyNameByAccessorName(this.getRequest().getMethodName());
        String className = ClassPresentationUtil.getNameForClass((PsiClass)this.getTarget(), (boolean)false);
        if (this.readOnly) {
            Object[] objectArray = new Object[]{propertyName, className};
            String string2 = QuickFixBundle.message((String)"create.read.only.property.from.usage.full.text", (Object[])objectArray);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            Object[] objectArray = new Object[]{propertyName, className};
            String string3 = QuickFixBundle.message((String)"create.property.from.usage.full.text", (Object[])objectArray);
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        }
        return string;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        CreateFieldAction createFieldAction;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CreateFieldAction $this$invoke_u24lambda_u241 = createFieldAction = new CreateFieldAction(this.getTarget(), new PropertyRequest(), false);
        boolean bl = false;
        if ($this$invoke_u24lambda_u241.isAvailable(project, editor, file)) {
            $this$invoke_u24lambda_u241.invoke(project, editor, file);
        }
    }

    @NotNull
    public JvmActionGroup getActionGroup() {
        return this.readOnly ? (JvmActionGroup)CreateReadOnlyPropertyActionGroup.INSTANCE : (JvmActionGroup)CreatePropertyActionGroup.INSTANCE;
    }

    private static final String getRenderData$lambda$0(CreatePropertyAction this$0) {
        return (String)this$0.getPropertyInfo().getFirst();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u000f0\nj\u0002`\u0010H\u0016J\r\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/CreatePropertyAction$PropertyRequest;", "Lcom/intellij/lang/jvm/actions/CreateFieldRequest;", "<init>", "(Lorg/jetbrains/plugins/groovy/annotator/intentions/elements/CreatePropertyAction;)V", "isValid", "", "getAnnotations", "", "Lcom/intellij/lang/jvm/actions/AnnotationRequest;", "getModifiers", "", "Lcom/intellij/lang/jvm/JvmModifier;", "getFieldName", "", "getFieldType", "Lcom/intellij/lang/jvm/actions/ExpectedType;", "Lcom/intellij/lang/jvm/actions/ExpectedTypes;", "getTargetSubstitutor", "Lcom/intellij/lang/jvm/types/JvmSubstitutor;", "Lorg/jetbrains/annotations/NotNull;", "isConstant", "getInitializer", "Lcom/intellij/lang/jvm/JvmValue;", "isStartTemplate", "intellij.groovy"})
    public final class PropertyRequest
    implements CreateFieldRequest {
        public boolean isValid() {
            return true;
        }

        @NotNull
        public Collection<AnnotationRequest> getAnnotations() {
            return CollectionsKt.emptyList();
        }

        @NotNull
        public List<JvmModifier> getModifiers() {
            return CreatePropertyAction.this.readOnly ? CollectionsKt.listOf((Object)JvmModifier.FINAL) : CollectionsKt.emptyList();
        }

        @NotNull
        public String getFieldName() {
            return (String)CreatePropertyAction.this.getPropertyInfo().getFirst();
        }

        @NotNull
        public List<ExpectedType> getFieldType() {
            return JvmPsiUtilKt.createPropertyTypeConstraints(CreatePropertyAction.this.getRequest(), (PropertyKind)CreatePropertyAction.this.getPropertyInfo().getSecond());
        }

        @NotNull
        public JvmSubstitutor getTargetSubstitutor() {
            JvmSubstitutor jvmSubstitutor = CreatePropertyAction.this.getRequest().getTargetSubstitutor();
            Intrinsics.checkNotNullExpressionValue((Object)jvmSubstitutor, (String)"getTargetSubstitutor(...)");
            return jvmSubstitutor;
        }

        public boolean isConstant() {
            return false;
        }

        @Nullable
        public JvmValue getInitializer() {
            return null;
        }

        public boolean isStartTemplate() {
            return CreatePropertyAction.this.getRequest().isStartTemplate();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PropertyKind.values().length];
            try {
                nArray[PropertyKind.GETTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyKind.BOOLEAN_GETTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyKind.SETTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

