/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.dynatrace.hash4j.hashing.Hashing;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentMapBuilder;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;
import org.jetbrains.jps.incremental.storage.OutputToTargetMapping;
import org.jetbrains.jps.incremental.storage.ProjectStamps;

@ApiStatus.Internal
public final class OutputToTargetRegistry
extends AbstractStateStorage<Integer, IntSet>
implements OutputToTargetMapping {
    private static final DataExternalizer<IntSet> DATA_EXTERNALIZER = new DataExternalizer<IntSet>(){

        public void save(@NotNull DataOutput out, IntSet value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            IntIterator iterator = value.iterator();
            while (iterator.hasNext()) {
                out.writeInt(iterator.nextInt());
            }
        }

        public IntSet read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            IntOpenHashSet result = new IntOpenHashSet();
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                result.add(in.readInt());
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/incremental/storage/OutputToTargetRegistry$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final PathRelativizerService relativizer;

    OutputToTargetRegistry(@NotNull Path storePath, PathRelativizerService relativizer) throws IOException {
        if (storePath == null) {
            OutputToTargetRegistry.$$$reportNull$$$0(0);
        }
        super(PersistentMapBuilder.newBuilder((Path)storePath, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, DATA_EXTERNALIZER));
        this.relativizer = relativizer;
    }

    void addMapping(@NotNull String outputPath, int buildTargetId) throws IOException {
        if (outputPath == null) {
            OutputToTargetRegistry.$$$reportNull$$$0(1);
        }
        this.appendData(this.pathHashCode(outputPath), IntSets.singleton((int)buildTargetId));
    }

    void addMappings(@NotNull Collection<String> outputPaths, int buildTargetId) throws IOException {
        if (outputPaths == null) {
            OutputToTargetRegistry.$$$reportNull$$$0(2);
        }
        IntSet set = IntSets.singleton((int)buildTargetId);
        for (String outputPath : outputPaths) {
            this.appendData(this.pathHashCode(outputPath), set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMappings(@NotNull Collection<String> outputPaths, int buildTargetId, @NotNull SourceToOutputMapping srcToOut) throws IOException {
        if (outputPaths == null) {
            OutputToTargetRegistry.$$$reportNull$$$0(3);
        }
        if (srcToOut == null) {
            OutputToTargetRegistry.$$$reportNull$$$0(4);
        }
        if (outputPaths.isEmpty()) {
            return;
        }
        for (String outputPath : outputPaths) {
            int key = this.pathHashCode(outputPath);
            Object object = this.dataLock;
            synchronized (object) {
                IntSet state = (IntSet)this.getState(key);
                if (state != null) {
                    boolean removed = state.remove(buildTargetId);
                    if (state.isEmpty()) {
                        this.remove(key);
                    } else if (removed) {
                        this.update(key, state);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<String> removeTargetAndGetSafeToDeleteOutputs(Collection<String> outputPaths, int currentTargetId, @NotNull SourceToOutputMapping srcToOut) throws IOException {
        int size;
        if (srcToOut == null) {
            OutputToTargetRegistry.$$$reportNull$$$0(5);
        }
        if ((size = outputPaths.size()) == 0) {
            Collection<String> collection = outputPaths;
            if (collection == null) {
                OutputToTargetRegistry.$$$reportNull$$$0(6);
            }
            return collection;
        }
        ArrayList<String> result = new ArrayList<String>(size);
        for (String outputPath : outputPaths) {
            int key = this.pathHashCode(outputPath);
            Object object = this.dataLock;
            synchronized (object) {
                IntSet state = (IntSet)this.getState(key);
                boolean isSafeToDelete = false;
                if (state == null) {
                    isSafeToDelete = true;
                } else {
                    boolean removed = state.remove(currentTargetId);
                    if (state.isEmpty()) {
                        this.remove(key);
                        isSafeToDelete = true;
                    } else if (removed) {
                        this.update(key, state);
                    }
                }
                if (isSafeToDelete) {
                    result.add(outputPath);
                }
            }
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            OutputToTargetRegistry.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private int pathHashCode(@NotNull String path) {
        if (path == null) {
            OutputToTargetRegistry.$$$reportNull$$$0(8);
        }
        String relativePath = this.relativizer.toRelative(path);
        if (ProjectStamps.PORTABLE_CACHES) {
            return Hashing.xxh3_64().hashBytesToInt(relativePath.getBytes(StandardCharsets.UTF_8));
        }
        return FileUtilRt.pathHashCode((String)relativePath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputPaths";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcToOut";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/storage/OutputToTargetRegistry";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/storage/OutputToTargetRegistry";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "removeTargetAndGetSafeToDeleteOutputs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addMapping";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addMappings";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeMappings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeTargetAndGetSafeToDeleteOutputs";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "pathHashCode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

