/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.util.concurrency.SynchronizedClearableLazy;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.ExperimentalOneToManyPathMapping;
import org.jetbrains.jps.incremental.storage.ExperimentalOutputToTargetMapping;
import org.jetbrains.jps.incremental.storage.OutputToTargetMapping;
import org.jetbrains.jps.incremental.storage.PerTargetMapManager;
import org.jetbrains.jps.incremental.storage.StampsStorage;
import org.jetbrains.jps.incremental.storage.StorageManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u0014\u0010\u0015\u001a\u00020\u000b2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\nH\u0002J\u0016\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\nJ\u0012\u0010\u0019\u001a\u00020\u001a2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\nJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010\u001d\u001a\u00020\u001e2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\nJ\u0012\u0010\u001f\u001a\u00020\u00102\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\nJ\u0006\u0010 \u001a\u00020\u0010J\u0006\u0010!\u001a\u00020\u0010J\u0006\u0010\"\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/jps/incremental/storage/ExperimentalBuildDataManager;", "", "storageManager", "Lorg/jetbrains/jps/incremental/storage/StorageManager;", "relativizer", "Lorg/jetbrains/jps/incremental/relativizer/PathRelativizerService;", "<init>", "(Lorg/jetbrains/jps/incremental/storage/StorageManager;Lorg/jetbrains/jps/incremental/relativizer/PathRelativizerService;)V", "targetToMapManager", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/jps/builders/BuildTarget;", "Lorg/jetbrains/jps/incremental/storage/PerTargetMapManager;", "outputToTargetMapping", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Lorg/jetbrains/jps/incremental/storage/ExperimentalOutputToTargetMapping;", "clearCache", "", "removeStaleTarget", "targetId", "", "targetTypeId", "getPerTargetMapManager", "target", "getFileStampStorage", "Lorg/jetbrains/jps/incremental/storage/StampsStorage;", "getSourceToOutputMapping", "Lorg/jetbrains/jps/builders/storage/SourceToOutputMapping;", "getOutputToTargetMapping", "Lorg/jetbrains/jps/incremental/storage/OutputToTargetMapping;", "getSourceToForm", "Lorg/jetbrains/jps/incremental/storage/ExperimentalOneToManyPathMapping;", "closeTargetMaps", "removeAllMaps", "commit", "close", "intellij.platform.jps.build"})
public final class ExperimentalBuildDataManager {
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final PathRelativizerService relativizer;
    @NotNull
    private final ConcurrentHashMap<BuildTarget<?>, PerTargetMapManager> targetToMapManager;
    @NotNull
    private final SynchronizedClearableLazy<ExperimentalOutputToTargetMapping> outputToTargetMapping;

    public ExperimentalBuildDataManager(@NotNull StorageManager storageManager, @NotNull PathRelativizerService relativizer) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)relativizer, (String)"relativizer");
        this.storageManager = storageManager;
        this.relativizer = relativizer;
        this.targetToMapManager = new ConcurrentHashMap();
        this.outputToTargetMapping = new SynchronizedClearableLazy(() -> ExperimentalBuildDataManager.outputToTargetMapping$lambda$0(this));
    }

    public final void clearCache() {
        this.storageManager.clearCache();
    }

    public final void removeStaleTarget(@NotNull String targetId, @NotNull String targetTypeId) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)targetTypeId, (String)"targetTypeId");
        this.storageManager.removeMaps(targetId, targetTypeId);
        ((ExperimentalOutputToTargetMapping)this.outputToTargetMapping.getValue()).removeTarget(targetId, targetTypeId);
    }

    private final PerTargetMapManager getPerTargetMapManager(BuildTarget<?> target) {
        PerTargetMapManager perTargetMapManager = this.targetToMapManager.computeIfAbsent(target, arg_0 -> ExperimentalBuildDataManager.getPerTargetMapManager$lambda$2(arg_0 -> ExperimentalBuildDataManager.getPerTargetMapManager$lambda$1(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)perTargetMapManager, (String)"computeIfAbsent(...)");
        return perTargetMapManager;
    }

    @NotNull
    public final StampsStorage<?> getFileStampStorage(@NotNull BuildTarget<?> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        return this.getPerTargetMapManager(target).stamp;
    }

    @NotNull
    public final SourceToOutputMapping getSourceToOutputMapping(@NotNull BuildTarget<?> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        return this.getPerTargetMapManager(target).getSourceToOutputMapping();
    }

    @NotNull
    public final OutputToTargetMapping getOutputToTargetMapping() {
        return (OutputToTargetMapping)this.outputToTargetMapping.getValue();
    }

    @NotNull
    public final ExperimentalOneToManyPathMapping getSourceToForm(@NotNull BuildTarget<?> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        return this.getPerTargetMapManager(target).getSourceToForm();
    }

    public final void closeTargetMaps(@NotNull BuildTarget<?> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        this.targetToMapManager.remove(target);
    }

    public final void removeAllMaps() {
        this.outputToTargetMapping.drop();
        this.targetToMapManager.clear();
        this.storageManager.clean();
    }

    public final void commit() {
        this.storageManager.commit();
    }

    public final void close() {
        this.outputToTargetMapping.drop();
        this.targetToMapManager.clear();
        this.storageManager.close();
    }

    private static final ExperimentalOutputToTargetMapping outputToTargetMapping$lambda$0(ExperimentalBuildDataManager this$0) {
        return new ExperimentalOutputToTargetMapping(this$0.storageManager);
    }

    private static final PerTargetMapManager getPerTargetMapManager$lambda$1(ExperimentalBuildDataManager this$0, BuildTarget it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new PerTargetMapManager(this$0.storageManager, this$0.relativizer, it, (Supplier)this$0.outputToTargetMapping);
    }

    private static final PerTargetMapManager getPerTargetMapManager$lambda$2(Function1 $tmp0, Object p0) {
        return (PerTargetMapManager)$tmp0.invoke(p0);
    }
}

