/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.messages;

import com.intellij.openapi.diagnostic.Logger;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.jps.FreezeDetector;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.incremental.BuilderRegistry;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;

public final class BuildProgress {
    private static final Logger LOG = Logger.getInstance(BuildProgress.class);
    private final BuildDataManager myDataManager;
    private final BuildTargetIndex myTargetIndex;
    private final Object2LongMap<BuildTargetType<?>> myExpectedBuildTimeForTarget = new Object2LongOpenHashMap();
    private final long myExpectedTotalTime;
    private final Map<BuildTarget<?>, Double> myCurrentProgress = new HashMap();
    private long myExpectedTimeForFinishedTargets;
    private long myAbsoluteBuildTime;
    private final Object2IntOpenHashMap<BuildTargetType<?>> myTotalTargets = new Object2IntOpenHashMap();
    private final Object2LongOpenHashMap<BuildTargetType<?>> myTotalBuildTimeForFullyRebuiltTargets = new Object2LongOpenHashMap();
    private final Object2IntOpenHashMap<BuildTargetType<?>> myNumberOfFullyRebuiltTargets = new Object2IntOpenHashMap();
    private final FreezeDetector myFreezeDetector;

    public BuildProgress(BuildDataManager dataManager, BuildTargetIndex targetIndex, List<BuildTargetChunk> allChunks, Predicate<? super BuildTargetChunk> isAffected) {
        this.myDataManager = dataManager;
        this.myTargetIndex = targetIndex;
        LinkedHashSet targetTypes = new LinkedHashSet();
        Object2IntOpenHashMap totalAffectedTargets = new Object2IntOpenHashMap();
        for (BuildTargetChunk chunk : allChunks) {
            boolean affected = isAffected.test(chunk);
            for (BuildTarget<?> target : chunk.getTargets()) {
                if (this.myTargetIndex.isDummy(target)) continue;
                if (affected) {
                    totalAffectedTargets.addTo(target.getTargetType(), 1);
                    targetTypes.add(target.getTargetType());
                }
                this.myTotalTargets.addTo(target.getTargetType(), 1);
            }
        }
        long expectedTotalTime = 0L;
        for (BuildTargetType buildTargetType : targetTypes) {
            this.myExpectedBuildTimeForTarget.put((Object)buildTargetType, this.myDataManager.getTargetsState().getAverageBuildTime(buildTargetType));
        }
        for (BuildTargetType buildTargetType : targetTypes) {
            if (this.myExpectedBuildTimeForTarget.getLong((Object)buildTargetType) != -1L) continue;
            this.myExpectedBuildTimeForTarget.put((Object)buildTargetType, BuildProgress.computeExpectedTimeBasedOnOtherTargets(buildTargetType, targetTypes, this.myExpectedBuildTimeForTarget));
        }
        for (BuildTargetType buildTargetType : targetTypes) {
            expectedTotalTime += this.myExpectedBuildTimeForTarget.getLong((Object)buildTargetType) * (long)totalAffectedTargets.getInt((Object)buildTargetType);
        }
        this.myExpectedTotalTime = Math.max(expectedTotalTime, 1L);
        this.myFreezeDetector = new FreezeDetector();
        this.myFreezeDetector.start();
        if (LOG.isDebugEnabled()) {
            LOG.debug("expected total time is " + this.myExpectedTotalTime);
            for (BuildTargetType buildTargetType : targetTypes) {
                LOG.debug(" expected build time for " + buildTargetType.getTypeId() + " is " + this.myExpectedBuildTimeForTarget.getLong((Object)buildTargetType));
            }
        }
    }

    private static long computeExpectedTimeBasedOnOtherTargets(BuildTargetType<?> type, Set<? extends BuildTargetType<?>> allTypes, Object2LongMap<BuildTargetType<?>> expectedBuildTimeForTarget) {
        BuilderRegistry registry = BuilderRegistry.getInstance();
        int baseTargetsCount = 0;
        long expectedTimeSum = 0L;
        for (BuildTargetType<?> anotherType : allTypes) {
            long realExpectedTime = expectedBuildTimeForTarget.getLong(anotherType);
            long defaultExpectedTime = registry.getExpectedBuildTimeForTarget(anotherType);
            if (realExpectedTime == -1L || defaultExpectedTime <= 0L) continue;
            ++baseTargetsCount;
            expectedTimeSum += realExpectedTime * registry.getExpectedBuildTimeForTarget(type) / defaultExpectedTime;
        }
        return baseTargetsCount != 0 ? expectedTimeSum / (long)baseTargetsCount : registry.getExpectedBuildTimeForTarget(type);
    }

    private synchronized void notifyAboutTotalProgress(CompileContext context) {
        long expectedTimeForFinishedWork = this.myExpectedTimeForFinishedTargets;
        for (Map.Entry<BuildTarget<?>, Double> entry : this.myCurrentProgress.entrySet()) {
            expectedTimeForFinishedWork = (long)((double)expectedTimeForFinishedWork + (double)this.myExpectedBuildTimeForTarget.getLong(entry.getKey().getTargetType()) * entry.getValue());
        }
        float done = (float)expectedTimeForFinishedWork / (float)this.myExpectedTotalTime;
        context.setDone(done);
    }

    public synchronized void updateProgress(BuildTarget<?> target, double done, CompileContext context) {
        this.myCurrentProgress.put(target, done);
        this.notifyAboutTotalProgress(context);
    }

    public synchronized void onTargetChunkFinished(BuildTargetChunk chunk, CompileContext context) {
        boolean successful = !Utils.errorsDetected(context) && !context.getCancelStatus().isCanceled();
        long nonDummyTargetsCount = chunk.getTargets().stream().filter(it -> !this.myTargetIndex.isDummy((BuildTarget<?>)it)).count();
        for (BuildTarget<?> target : chunk.getTargets()) {
            this.myCurrentProgress.remove(target);
            if (this.myTargetIndex.isDummy(target)) continue;
            BuildTargetType<BuildTarget<?>> targetType = target.getTargetType();
            this.myExpectedTimeForFinishedTargets += this.myExpectedBuildTimeForTarget.getLong(targetType);
            long elapsedTime = this.myFreezeDetector.getAdjustedDuration(context.getCompilationStartStamp(target), System.currentTimeMillis());
            this.myAbsoluteBuildTime += elapsedTime;
            if (!successful || !FSOperations.isMarkedDirty(context, target)) continue;
            long buildTime = elapsedTime / nonDummyTargetsCount;
            this.myTotalBuildTimeForFullyRebuiltTargets.addTo(targetType, buildTime);
            this.myNumberOfFullyRebuiltTargets.addTo(targetType, 1);
        }
        this.notifyAboutTotalProgress(context);
    }

    public void updateExpectedAverageTime() {
        this.myFreezeDetector.stop();
        if (LOG.isDebugEnabled()) {
            LOG.debug("update expected build time for " + this.myTotalBuildTimeForFullyRebuiltTargets.size() + " target types");
        }
        ObjectIterator iterator = this.myTotalBuildTimeForFullyRebuiltTargets.object2LongEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Object2LongMap.Entry entry = (Object2LongMap.Entry)iterator.next();
            BuildTargetType type = (BuildTargetType)entry.getKey();
            long totalTime = entry.getLongValue();
            BuildTargetsState targetsState = this.myDataManager.getTargetsState();
            long oldAverageTime = targetsState.getAverageBuildTime(type);
            long newAverageTime = oldAverageTime == -1L ? totalTime / (long)this.myNumberOfFullyRebuiltTargets.getInt((Object)type) : (totalTime + (long)(this.myTotalTargets.getInt((Object)type) - this.myNumberOfFullyRebuiltTargets.getInt((Object)type)) * oldAverageTime) / (long)this.myTotalTargets.getInt((Object)type);
            if (LOG.isDebugEnabled()) {
                LOG.debug(" " + type.getTypeId() + ": old=" + oldAverageTime + ", new=" + newAverageTime + " (based on " + this.myNumberOfFullyRebuiltTargets.getInt((Object)type) + " of " + this.myTotalTargets.getInt((Object)type) + " targets)");
            }
            targetsState.setAverageBuildTime(type, newAverageTime);
        }
    }

    public synchronized long getAbsoluteBuildTime() {
        return this.myAbsoluteBuildTime;
    }
}

