/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.BackDependencyIndex;
import org.jetbrains.jps.dependency.Delta;
import org.jetbrains.jps.dependency.DifferentiateContext;
import org.jetbrains.jps.dependency.Graph;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.dependency.diff.DiffCapable;
import org.jetbrains.jps.dependency.impl.Containers;
import org.jetbrains.jps.dependency.java.JVMClassNode;
import org.jetbrains.jps.dependency.java.JVMFlags;
import org.jetbrains.jps.dependency.java.JvmClass;
import org.jetbrains.jps.dependency.java.JvmField;
import org.jetbrains.jps.dependency.java.JvmMethod;
import org.jetbrains.jps.dependency.java.JvmModule;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.ProtoMember;
import org.jetbrains.jps.dependency.java.TypeRepr;
import org.jetbrains.jps.javac.Iterators;

public final class Utils {
    @NotNull
    private final Graph myGraph;
    @Nullable
    private final Delta myDelta;
    @NotNull
    private final Predicate<? super NodeSource> mySourcesFilter;
    @NotNull
    private final Predicate<? super ReferenceID> myIsNodeDeleted;
    @NotNull
    private final BackDependencyIndex myDirectSubclasses;
    @Nullable
    private final BackDependencyIndex myDeltaDirectSubclasses;

    public Utils(@NotNull DifferentiateContext context, boolean isDelta) {
        if (context == null) {
            Utils.$$$reportNull$$$0(0);
        }
        this(context.getGraph(), isDelta ? context.getDelta() : null, context.getParams().affectionFilter(), context::isDeleted);
    }

    public Utils(@NotNull Graph graph, @NotNull Predicate<? super NodeSource> sourceFilter) {
        if (graph == null) {
            Utils.$$$reportNull$$$0(1);
        }
        if (sourceFilter == null) {
            Utils.$$$reportNull$$$0(2);
        }
        this(graph, null, sourceFilter, id -> false);
    }

    public Utils(@NotNull Graph graph, @Nullable Delta delta, @NotNull Predicate<? super NodeSource> sourceFilter, @NotNull Predicate<? super ReferenceID> isNodeDeleted) {
        if (graph == null) {
            Utils.$$$reportNull$$$0(3);
        }
        if (sourceFilter == null) {
            Utils.$$$reportNull$$$0(4);
        }
        if (isNodeDeleted == null) {
            Utils.$$$reportNull$$$0(5);
        }
        this.myGraph = graph;
        this.myDelta = delta;
        this.mySourcesFilter = sourceFilter;
        this.myIsNodeDeleted = isNodeDeleted;
        this.myDirectSubclasses = Objects.requireNonNull(this.myGraph.getIndex("direct-subclasses"));
        this.myDeltaDirectSubclasses = this.myDelta != null ? Objects.requireNonNull(this.myDelta.getIndex("direct-subclasses")) : null;
    }

    public Iterable<NodeSource> getNodeSources(ReferenceID nodeId) {
        if (this.myDelta != null) {
            Collection _src = this.myDelta.getSources(nodeId);
            Collection deltaSources = _src instanceof Set ? _src : Iterators.collect(_src, new HashSet());
            Set<NodeSource> deleted = this.myDelta.getDeletedSources();
            return Iterators.flat((Iterable)deltaSources, (Iterable)Iterators.filter(this.myGraph.getSources(nodeId), src -> !Iterators.contains((Iterable)deltaSources, (Object)src) && !deleted.contains(src) && this.mySourcesFilter.test((NodeSource)src)));
        }
        return Iterators.filter(this.myGraph.getSources(nodeId), this.mySourcesFilter::test);
    }

    public Iterable<JvmClass> getClassesByName(@NotNull String name) {
        if (name == null) {
            Utils.$$$reportNull$$$0(6);
        }
        return this.getNodes(new JvmNodeReferenceID(name), JvmClass.class);
    }

    public Iterable<JvmModule> getModulesByName(@NotNull String name) {
        if (name == null) {
            Utils.$$$reportNull$$$0(7);
        }
        return this.getNodes(new JvmNodeReferenceID(name), JvmModule.class);
    }

    @Nullable
    public String getNodeName(ReferenceID id) {
        if (id instanceof JvmNodeReferenceID) {
            return ((JvmNodeReferenceID)id).getNodeName();
        }
        Iterable<JVMClassNode> nodes = this.getNodes(id, JVMClassNode.class);
        Iterator<JVMClassNode> iterator = nodes.iterator();
        if (iterator.hasNext()) {
            JVMClassNode node = iterator.next();
            return node.getName();
        }
        return null;
    }

    public boolean isLambdaTarget(ReferenceID classId) {
        return !Iterators.isEmpty((Iterable)Iterators.filter(this.getNodes(classId, JvmClass.class), this::isLambdaTarget));
    }

    public boolean isLambdaTarget(JvmClass cls) {
        if (cls.isInterface()) {
            int amFound = 0;
            for (JvmMethod method : this.allMethodsRecursively(cls)) {
                if (method.isAbstract() && ++amFound > 1) break;
            }
            if (amFound == 1) {
                return true;
            }
        }
        return false;
    }

    public Iterable<JvmMethod> allMethodsRecursively(JvmClass cls) {
        return Iterators.flat((Iterable)Iterators.map((Iterable)Iterators.recurse((Object)cls, c -> Iterators.flat((Iterable)Iterators.map(c.getSuperTypes(), st -> this.getClassesByName((String)st))), (boolean)true), c -> c.getMethods()));
    }

    public <T extends Node<T, ?>> Iterable<T> getNodes(@NotNull ReferenceID id, Class<T> selector) {
        if (id == null) {
            Utils.$$$reportNull$$$0(8);
        }
        return this.getNodesImpl(id, selector, false);
    }

    public <T extends Node<T, ?>> Iterable<T> getCompiledNodes(@NotNull ReferenceID id, Class<T> selector) {
        if (id == null) {
            Utils.$$$reportNull$$$0(9);
        }
        return this.getNodesImpl(id, selector, true);
    }

    @NotNull
    private <T extends Node<T, ?>> Iterable<T> getNodesImpl(@NotNull ReferenceID id, Class<T> selector, boolean fromDeltaOnly) {
        Iterable<Object> allNodes;
        if (id == null) {
            Utils.$$$reportNull$$$0(10);
        }
        if (id instanceof JvmNodeReferenceID && "".equals(((JvmNodeReferenceID)id).getNodeName())) {
            List list = Collections.emptyList();
            if (list == null) {
                Utils.$$$reportNull$$$0(11);
            }
            return list;
        }
        if (this.myDelta != null) {
            Collection deltaSrc = this.myDelta.getSources(id);
            Collection deltaSources = fromDeltaOnly ? deltaSrc : (deltaSrc instanceof Set ? deltaSrc : Iterators.collect(deltaSrc, new HashSet()));
            Iterable deltaNodes = Iterators.flat((Iterable)Iterators.map(deltaSources, src -> this.myDelta.getNodes((NodeSource)src, selector)));
            if (fromDeltaOnly) {
                allNodes = deltaNodes;
            } else {
                Set<NodeSource> deleted = this.myDelta.getDeletedSources();
                allNodes = Iterators.flat((Iterable)deltaNodes, (Iterable)Iterators.flat((Iterable)Iterators.map((Iterable)Iterators.filter(this.myGraph.getSources(id), src -> !Iterators.contains((Iterable)deltaSources, (Object)src) && !deleted.contains(src) && this.mySourcesFilter.test((NodeSource)src)), src -> this.myGraph.getNodes((NodeSource)src, selector))));
            }
        } else {
            allNodes = fromDeltaOnly ? Collections.emptyList() : Iterators.flat((Iterable)Iterators.map((Iterable)Iterators.filter(this.myGraph.getSources(id), this.mySourcesFilter::test), src -> this.myGraph.getNodes((NodeSource)src, selector)));
        }
        return Utils.uniqueBy(Iterators.filter(allNodes, n -> id.equals(n.getReferenceID())), DiffCapable::isSame, DiffCapable::diffHashCode);
    }

    @NotNull
    public static <T> Iterable<T> uniqueBy(Iterable<? extends T> it, final BiFunction<? super T, ? super T, Boolean> equalsImpl, final Function<? super T, Integer> hashCodeImpl) {
        Iterable iterable = Iterators.uniqueBy(it, () -> new Iterators.BooleanFunction<T>(){
            Set<T> visited;

            public boolean fun(T t) {
                if (this.visited == null) {
                    this.visited = Containers.createCustomPolicySet(equalsImpl, hashCodeImpl);
                }
                return this.visited.add(t);
            }
        });
        if (iterable == null) {
            Utils.$$$reportNull$$$0(12);
        }
        return iterable;
    }

    public Iterable<ReferenceID> allDirectSupertypes(ReferenceID classId) {
        return classId instanceof JvmNodeReferenceID ? Iterators.map(this.allDirectSupertypes((JvmNodeReferenceID)classId), id -> id) : Collections.emptyList();
    }

    public Iterable<JvmNodeReferenceID> allDirectSupertypes(JvmNodeReferenceID classId) {
        return Iterators.unique((Iterable)Iterators.flat((Iterable)Iterators.map(this.getNodes(classId, JvmClass.class), cl -> Iterators.flat((Iterable)Iterators.map(cl.getSuperTypes(), st -> Iterators.map(this.getNodes(new JvmNodeReferenceID((String)st), JvmClass.class), JVMClassNode::getReferenceID))))));
    }

    public Iterable<JvmClass> allDirectSupertypes(JvmClass cls) {
        return Iterators.flat((Iterable)Iterators.map(cls.getSuperTypes(), st -> this.getNodes(new JvmNodeReferenceID((String)st), JvmClass.class)));
    }

    public Iterable<JvmNodeReferenceID> allSupertypes(JvmNodeReferenceID classId) {
        return Iterators.recurse((Object)classId, this::allDirectSupertypes, (boolean)false);
    }

    @NotNull
    public Iterable<ReferenceID> withAllSubclasses(ReferenceID from) {
        Iterable iterable = Iterators.recurse((Object)from, this::directSubclasses, (boolean)true);
        if (iterable == null) {
            Utils.$$$reportNull$$$0(13);
        }
        return iterable;
    }

    @NotNull
    public Iterable<ReferenceID> allSubclasses(ReferenceID from) {
        Iterable iterable = Iterators.recurse((Object)from, this::directSubclasses, (boolean)false);
        if (iterable == null) {
            Utils.$$$reportNull$$$0(14);
        }
        return iterable;
    }

    @NotNull
    public Iterable<ReferenceID> directSubclasses(ReferenceID from) {
        if (this.myDeltaDirectSubclasses != null) {
            Iterators.BooleanFunction subClassFilter = sub -> {
                if (this.myIsNodeDeleted.test((ReferenceID)sub)) {
                    return false;
                }
                Iterable<JvmClass> justCompiled = this.getCompiledNodes((ReferenceID)sub, (Class)JvmClass.class);
                return Iterators.isEmpty(justCompiled) || Iterators.contains((Iterable)Iterators.flat((Iterable)Iterators.map(justCompiled, cl -> Iterators.map(cl.getSuperTypes(), st -> new JvmNodeReferenceID((String)st)))), (Object)from);
            };
            Iterable iterable = Iterators.unique((Iterable)Iterators.flat((Iterable)Iterators.filter(this.myDirectSubclasses.getDependencies(from), (Iterators.BooleanFunction)subClassFilter), this.myDeltaDirectSubclasses.getDependencies(from)));
            if (iterable == null) {
                Utils.$$$reportNull$$$0(15);
            }
            return iterable;
        }
        Iterable<ReferenceID> iterable = this.myDirectSubclasses.getDependencies(from);
        if (iterable == null) {
            Utils.$$$reportNull$$$0(16);
        }
        return iterable;
    }

    public Set<JvmNodeReferenceID> collectSubclassesWithoutField(JvmNodeReferenceID classId, JvmField field) {
        return this.collectSubclassesWithoutMember(classId, f -> Objects.equals(field.getName(), f.getName()), JvmClass::getFields);
    }

    public Set<JvmNodeReferenceID> collectSubclassesWithoutMethod(JvmNodeReferenceID classId, JvmMethod method) {
        return this.collectSubclassesWithoutMember(classId, method::isSame, JvmClass::getMethods);
    }

    private <T extends ProtoMember> Set<JvmNodeReferenceID> collectSubclassesWithoutMember(JvmNodeReferenceID classId, Predicate<? super T> isSame, Function<JvmClass, Iterable<T>> membersGetter) {
        Predicate<ReferenceID> containsMember = id -> Iterators.isEmpty((Iterable)Iterators.filter(this.getNodes((ReferenceID)id, (Class)JvmClass.class), cls -> Iterators.isEmpty((Iterable)Iterators.filter((Iterable)((Iterable)membersGetter.apply((JvmClass)cls)), isSame::test))));
        Iterable<JvmNodeReferenceID> result = Utils.getNodesData(classId, this::directSubclasses, id -> id instanceof JvmNodeReferenceID && !containsMember.test((ReferenceID)id) ? (JvmNodeReferenceID)id : null, Objects::nonNull, false);
        return (Set)Iterators.collect((Iterable)Iterators.filter(result, (Iterators.BooleanFunction)Iterators.notNullFilter()), new HashSet());
    }

    public Iterable<Pair<JvmClass, JvmField>> getOverriddenFields(JvmClass fromCls, JvmField field) {
        Function<JvmClass, Iterable> dataGetter = cl -> Iterators.collect((Iterable)Iterators.map((Iterable)Iterators.filter(cl.getFields(), f -> Objects.equals(f.getName(), field.getName()) && this.isVisibleInHierarchy((JvmClass)cl, (ProtoMember)f, fromCls)), ff -> Pair.create((Object)cl, (Object)ff)), (Collection)new SmartList());
        return Iterators.flat(Utils.getNodesData(fromCls, cl -> Iterators.flat((Iterable)Iterators.map(cl.getSuperTypes(), st -> this.getClassesByName((String)st))), dataGetter, result -> Iterators.isEmpty((Iterable)result), false));
    }

    public Iterable<Pair<JvmClass, JvmMethod>> getOverriddenMethods(JvmClass fromCls, Predicate<JvmMethod> searchCond) {
        Function<JvmClass, Iterable> dataGetter = cl -> Iterators.collect((Iterable)Iterators.map((Iterable)Iterators.filter(cl.getMethods(), m -> searchCond.test((JvmMethod)m) && this.isVisibleInHierarchy((JvmClass)cl, (ProtoMember)m, fromCls)), mm -> Pair.create((Object)cl, (Object)mm)), (Collection)new SmartList());
        return Iterators.flat(Utils.getNodesData(fromCls, cl -> Iterators.flat((Iterable)Iterators.map(cl.getSuperTypes(), st -> this.getClassesByName((String)st))), dataGetter, result -> Iterators.isEmpty((Iterable)result), false));
    }

    public Iterable<Pair<JvmClass, JvmMethod>> getOverridingMethods(JvmClass fromCls, JvmMethod method, Predicate<JvmMethod> searchCond) {
        Function<JvmClass, Iterable> dataGetter = cl -> this.isVisibleInHierarchy(fromCls, method, (JvmClass)cl) ? Iterators.collect((Iterable)Iterators.map((Iterable)Iterators.filter(cl.getMethods(), searchCond::test), mm -> Pair.create((Object)cl, (Object)mm)), (Collection)new SmartList()) : Collections.emptyList();
        return Iterators.flat(Utils.getNodesData(fromCls, cl -> Iterators.flat((Iterable)Iterators.map(this.directSubclasses(cl.getReferenceID()), st -> this.getNodes((ReferenceID)st, (Class)JvmClass.class))), dataGetter, result -> Iterators.isEmpty((Iterable)result), false));
    }

    public Iterable<OverloadDescriptor> findAllOverloads(JvmClass cls, Function<? super JvmMethod, JVMFlags> correspondenceFinder) {
        Function<JvmClass, Iterable> mapper = c -> Iterators.filter((Iterable)Iterators.map(c.getMethods(), m -> {
            JVMFlags accessScope = (JVMFlags)correspondenceFinder.apply((JvmMethod)m);
            return accessScope != null ? new OverloadDescriptor(accessScope, (JvmMethod)m, (JvmClass)c) : null;
        }), (Iterators.BooleanFunction)Iterators.notNullFilter());
        return Iterators.flat((Iterable)Iterators.flat((Iterable)Iterators.map((Iterable)Iterators.recurse((Object)cls, cl -> Iterators.flat((Iterable)Iterators.map(cl.getSuperTypes(), st -> this.getClassesByName((String)st))), (boolean)true), cl -> (Iterable)mapper.apply((JvmClass)cl))), (Iterable)Iterators.flat((Iterable)Iterators.map(this.allSubclasses(cls.getReferenceID()), id -> Iterators.flat((Iterable)Iterators.map(this.getNodes((ReferenceID)id, (Class)JvmClass.class), cl -> (Iterable)mapper.apply((JvmClass)cl))))));
    }

    private static <N, V> Iterable<V> getNodesData(N fromNode, Function<? super N, ? extends Iterable<? extends N>> step, Function<N, V> dataGetter, Predicate<V> continuationCond, boolean includeHead) {
        Function mapper = Utils.cachingFunction(dataGetter);
        return Iterators.map((Iterable)Iterators.recurseDepth(fromNode, node -> fromNode.equals(node) || continuationCond.test(mapper.apply(node)) ? (List)step.apply((Object)node) : Collections.emptyList(), (boolean)includeHead), mapper::apply);
    }

    public boolean hasOverriddenMethods(JvmClass cls, JvmMethod method) {
        return !Iterators.isEmpty(this.getOverriddenMethods(cls, method::isSameByJavaRules)) || this.inheritsFromLibraryClass(cls);
    }

    boolean isFieldVisible(JvmClass cls, JvmField field) {
        return !Iterators.isEmpty((Iterable)Iterators.filter(cls.getFields(), field::isSame)) || !Iterators.isEmpty(this.getOverriddenFields(cls, field));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isMethodVisible(JvmClass cls, JvmMethod method) {
        if (!Iterators.isEmpty((Iterable)Iterators.filter(cls.getMethods(), method::isSameByJavaRules))) return true;
        if (Iterators.isEmpty(this.getOverriddenMethods(cls, method::isSameByJavaRules))) return false;
        return true;
    }

    private boolean isVisibleInHierarchy(JvmClass cls, ProtoMember clsMember, JvmClass subClass) {
        return clsMember.isProtected() || this.isVisibleIn(cls, clsMember, subClass);
    }

    public boolean isVisibleIn(JvmClass cls, ProtoMember clsMember, JvmClass scope) {
        if (clsMember.isPrivate()) {
            return Objects.equals(cls.getReferenceID(), scope.getReferenceID());
        }
        if (clsMember.isPackageLocal()) {
            return Objects.equals(cls.getPackageName(), scope.getPackageName());
        }
        if (clsMember.isProtected()) {
            return Objects.equals(cls.getPackageName(), scope.getPackageName()) || this.isInheritorOf(scope, cls);
        }
        return true;
    }

    public boolean isInheritorOf(JvmClass who, JvmClass whom) {
        return !Iterators.isEmpty((Iterable)Iterators.filter((Iterable)Iterators.recurseDepth((Object)who, cl -> Iterators.flat((Iterable)Iterators.map(who.getSuperTypes(), st -> this.getClassesByName((String)st))), (boolean)true), cl -> cl.getReferenceID().equals(whom.getReferenceID())));
    }

    public boolean inheritsFromLibraryClass(JvmClass cls) {
        for (String st : cls.getSuperTypes()) {
            Iterator<JvmClass> classes = this.getClassesByName(st).iterator();
            if (!classes.hasNext()) {
                return true;
            }
            while (classes.hasNext()) {
                if (!this.inheritsFromLibraryClass(classes.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Boolean isInheritorOf(JvmNodeReferenceID who, JvmNodeReferenceID whom) {
        if (who.equals(whom) || !Iterators.isEmpty((Iterable)Iterators.filter(this.allSupertypes(who), st -> st.equals(whom)))) {
            return Boolean.TRUE;
        }
        return null;
    }

    public Predicate<JvmMethod> lessSpecific(JvmMethod than) {
        return m -> {
            if (m.isConstructor() || !Objects.equals(m.getName(), than.getName())) {
                return false;
            }
            Iterator<TypeRepr> it = m.getArgTypes().iterator();
            for (TypeRepr thanArgType : than.getArgTypes()) {
                if (!it.hasNext()) {
                    return false;
                }
                TypeRepr mArgType = it.next();
                Boolean subtypeOf = this.isSubtypeOf(thanArgType, mArgType);
                if (subtypeOf == null || subtypeOf.booleanValue()) continue;
                return false;
            }
            return !it.hasNext();
        };
    }

    @Nullable
    public Boolean isSubtypeOf(TypeRepr who, TypeRepr whom) {
        if (who.equals(whom)) {
            return Boolean.TRUE;
        }
        if (who instanceof TypeRepr.PrimitiveType || whom instanceof TypeRepr.PrimitiveType) {
            return Boolean.FALSE;
        }
        if (who instanceof TypeRepr.ArrayType) {
            if (whom instanceof TypeRepr.ArrayType) {
                return this.isSubtypeOf(((TypeRepr.ArrayType)who).getElementType(), ((TypeRepr.ArrayType)whom).getElementType());
            }
            String descr = whom.getDescriptor();
            if ("Ljava/lang/Cloneable;".equals(descr) || "Ljava/lang/Object;".equals(descr) || "Ljava/io/Serializable;".equals(descr)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (whom instanceof TypeRepr.ClassType) {
            return this.isInheritorOf(new JvmNodeReferenceID(((TypeRepr.ClassType)who).getJvmName()), new JvmNodeReferenceID(((TypeRepr.ClassType)whom).getJvmName()));
        }
        return Boolean.FALSE;
    }

    private static <K, V> Function<K, V> cachingFunction(Function<K, V> f) {
        HashMap cache = new HashMap();
        return k -> cache.computeIfAbsent(k, f);
    }

    public static <V> Supplier<V> lazyValue(final Supplier<V> provider) {
        return new Supplier<V>(){
            private Object[] computed;

            @Override
            public V get() {
                Object object;
                if (this.computed == null) {
                    this.computed = new Object[]{provider.get()};
                    object = this.computed[0];
                } else {
                    object = this.computed[0];
                }
                return object;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFilter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isNodeDeleted";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/java/Utils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/java/Utils";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodesImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "uniqueBy";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "withAllSubclasses";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "allSubclasses";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "directSubclasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getClassesByName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModulesByName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNodes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCompiledNodes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNodesImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class OverloadDescriptor {
        final JVMFlags accessScope;
        final JvmMethod overloadMethod;
        final JvmClass owner;

        OverloadDescriptor(JVMFlags accessScope, JvmMethod overloadMethod, JvmClass owner) {
            this.accessScope = accessScope;
            this.overloadMethod = overloadMethod;
            this.owner = owner;
        }
    }
}

