/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.DefaultArtifactFactory;
import org.apache.maven.artifact.versioning.VersionRange;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3Artifact;

public class CustomMaven3ArtifactFactory
extends DefaultArtifactFactory {
    private static final VersionRange UNKNOWN_VERSION_RANGE = VersionRange.createFromVersion((String)"unknown");
    private boolean myCustomized;

    public void customize() {
        this.myCustomized = true;
    }

    public void reset() {
        this.myCustomized = false;
    }

    public Artifact createArtifact(String groupId, String artifactId, String version, String scope, String type) {
        return this.wrap(super.createArtifact(CustomMaven3ArtifactFactory.checkValue(groupId), CustomMaven3ArtifactFactory.checkValue(artifactId), CustomMaven3ArtifactFactory.checkVersion(version), scope, type));
    }

    public Artifact createArtifactWithClassifier(String groupId, String artifactId, String version, String type, String classifier) {
        return this.wrap(super.createArtifactWithClassifier(CustomMaven3ArtifactFactory.checkValue(groupId), CustomMaven3ArtifactFactory.checkValue(artifactId), CustomMaven3ArtifactFactory.checkVersion(version), type, classifier));
    }

    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope) {
        return this.wrap(super.createDependencyArtifact(CustomMaven3ArtifactFactory.checkValue(groupId), CustomMaven3ArtifactFactory.checkValue(artifactId), CustomMaven3ArtifactFactory.checkVersionRange(versionRange), type, classifier, scope));
    }

    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, boolean optional) {
        return this.wrap(super.createDependencyArtifact(CustomMaven3ArtifactFactory.checkValue(groupId), CustomMaven3ArtifactFactory.checkValue(artifactId), CustomMaven3ArtifactFactory.checkVersionRange(versionRange), type, classifier, scope, optional));
    }

    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, String inheritedScope) {
        return this.wrap(super.createDependencyArtifact(CustomMaven3ArtifactFactory.checkValue(groupId), CustomMaven3ArtifactFactory.checkValue(artifactId), CustomMaven3ArtifactFactory.checkVersionRange(versionRange), type, classifier, scope, inheritedScope));
    }

    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, String inheritedScope, boolean optional) {
        return this.wrap(super.createDependencyArtifact(CustomMaven3ArtifactFactory.checkValue(groupId), CustomMaven3ArtifactFactory.checkValue(artifactId), CustomMaven3ArtifactFactory.checkVersionRange(versionRange), type, classifier, scope, inheritedScope, optional));
    }

    public Artifact createBuildArtifact(String groupId, String artifactId, String version, String packaging) {
        return this.wrap(super.createBuildArtifact(CustomMaven3ArtifactFactory.checkValue(groupId), CustomMaven3ArtifactFactory.checkValue(artifactId), CustomMaven3ArtifactFactory.checkVersion(version), packaging));
    }

    public Artifact createProjectArtifact(String groupId, String artifactId, String version) {
        return this.wrap(super.createProjectArtifact(CustomMaven3ArtifactFactory.checkValue(groupId), CustomMaven3ArtifactFactory.checkValue(artifactId), CustomMaven3ArtifactFactory.checkVersion(version)));
    }

    public Artifact createParentArtifact(String groupId, String artifactId, String version) {
        return this.wrap(super.createParentArtifact(CustomMaven3ArtifactFactory.checkValue(groupId), CustomMaven3ArtifactFactory.checkValue(artifactId), CustomMaven3ArtifactFactory.checkVersion(version)));
    }

    public Artifact createPluginArtifact(String groupId, String artifactId, VersionRange versionRange) {
        return this.wrap(super.createPluginArtifact(CustomMaven3ArtifactFactory.checkValue(groupId), CustomMaven3ArtifactFactory.checkValue(artifactId), CustomMaven3ArtifactFactory.checkVersionRange(versionRange)));
    }

    public Artifact createProjectArtifact(String groupId, String artifactId, String version, String scope) {
        return this.wrap(super.createProjectArtifact(CustomMaven3ArtifactFactory.checkValue(groupId), CustomMaven3ArtifactFactory.checkValue(artifactId), CustomMaven3ArtifactFactory.checkVersion(version), scope));
    }

    public Artifact createExtensionArtifact(String groupId, String artifactId, VersionRange versionRange) {
        return this.wrap(super.createExtensionArtifact(CustomMaven3ArtifactFactory.checkValue(groupId), CustomMaven3ArtifactFactory.checkValue(artifactId), CustomMaven3ArtifactFactory.checkVersionRange(versionRange)));
    }

    private Artifact wrap(Artifact a) {
        if (!this.myCustomized) {
            return a;
        }
        return a != null ? new CustomMaven3Artifact(a) : null;
    }

    private static String checkValue(String value) {
        return value == null || value.trim().length() == 0 ? "error" : value;
    }

    private static String checkVersion(String value) {
        return value == null ? "unknown" : value;
    }

    private static VersionRange checkVersionRange(VersionRange range) {
        return range == null ? UNKNOWN_VERSION_RANGE : range;
    }
}

