/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsLogStorageImpl;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogContentProviderKt;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogProjectTabsProperties;
import com.intellij.vcs.log.impl.VcsLogSharedSettings;
import com.intellij.vcs.log.impl.VcsLogTabsManager;
import com.intellij.vcs.log.impl.VcsProjectLogManagerKt;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0016\u0010\n\u001a\u0012\u0012\u0006\b\u0000\u0012\u00020\f\u0012\u0006\b\u0000\u0012\u00020\r0\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0014J\b\u0010\u0018\u001a\u00020\u0015H\u0016R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lcom/intellij/vcs/log/impl/VcsProjectLogManager;", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "project", "Lcom/intellij/openapi/project/Project;", "uiProperties", "Lcom/intellij/vcs/log/impl/VcsLogProjectTabsProperties;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "recreateHandler", "Ljava/util/function/BiConsumer;", "Lcom/intellij/vcs/log/impl/VcsLogErrorHandler$Source;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/impl/VcsLogProjectTabsProperties;Ljava/util/Map;Ljava/util/function/BiConsumer;)V", "tabsManager", "Lcom/intellij/vcs/log/impl/VcsLogTabsManager;", "getTabsManager", "()Lcom/intellij/vcs/log/impl/VcsLogTabsManager;", "createUi", "", "createUi$intellij_platform_vcs_log_impl", "disposeUi", "dispose", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVcsProjectLogManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsProjectLogManager.kt\ncom/intellij/vcs/log/impl/VcsProjectLogManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,46:1\n24#2:47\n*S KotlinDebug\n*F\n+ 1 VcsProjectLogManager.kt\ncom/intellij/vcs/log/impl/VcsProjectLogManager\n*L\n38#1:47\n*E\n"})
public final class VcsProjectLogManager
extends VcsLogManager {
    @NotNull
    private final VcsLogTabsManager tabsManager;

    public VcsProjectLogManager(@NotNull Project project, @NotNull VcsLogProjectTabsProperties uiProperties, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders, @NotNull BiConsumer<? super VcsLogErrorHandler.Source, ? super Throwable> recreateHandler) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)uiProperties, (String)"uiProperties");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        Intrinsics.checkNotNullParameter(recreateHandler, (String)"recreateHandler");
        super(project, uiProperties, logProviders, VcsProjectLogManagerKt.getProjectLogName(logProviders), false, VcsLogSharedSettings.isIndexSwitchedOn(project), recreateHandler);
        this.tabsManager = new VcsLogTabsManager(project, uiProperties, this);
    }

    @NotNull
    public final VcsLogTabsManager getTabsManager() {
        return this.tabsManager;
    }

    public final void createUi$intellij_platform_vcs_log_impl() {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        VcsLogContentProvider vcsLogContentProvider = VcsLogContentProviderKt.getVcsLogContentProvider(project);
        if (vcsLogContentProvider != null) {
            vcsLogContentProvider.addMainUi$intellij_platform_vcs_log_impl(this);
        }
        this.tabsManager.createTabs$intellij_platform_vcs_log_impl();
    }

    @Override
    protected void disposeUi() {
        this.tabsManager.disposeTabs$intellij_platform_vcs_log_impl();
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        VcsLogContentProvider vcsLogContentProvider = VcsLogContentProviderKt.getVcsLogContentProvider(project);
        if (vcsLogContentProvider != null) {
            vcsLogContentProvider.disposeMainUi$intellij_platform_vcs_log_impl();
        }
        super.disposeUi();
    }

    @Override
    public void dispose() {
        super.dispose();
        VcsLogStorage vcsLogStorage = this.getDataManager().getStorage();
        VcsLogStorageImpl vcsLogStorageImpl = vcsLogStorage instanceof VcsLogStorageImpl ? (VcsLogStorageImpl)vcsLogStorage : null;
        if (vcsLogStorageImpl == null) {
            return;
        }
        VcsLogStorageImpl storageImpl = vcsLogStorageImpl;
        if (!storageImpl.isDisposed()) {
            VcsProjectLogManager $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(VcsProjectLogManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Storage for " + this.getName() + " was not disposed");
            Disposer.dispose((Disposable)storageImpl);
        }
    }
}

