/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.prompt;

import com.intellij.openapi.editor.ex.EditorEx;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptModel;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.CommandFinishedEvent;
import org.jetbrains.plugins.terminal.block.session.KeyBinding;
import org.jetbrains.plugins.terminal.block.session.ShellCommandListener;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.util.ShellType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/ShellEditorBufferReportShellCommandListener;", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandListener;", "blockTerminalSession", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "model", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;Lcom/intellij/openapi/editor/ex/EditorEx;)V", "commandBufferReceived", "", "buffer", "", "initialized", "commandFinished", "event", "Lorg/jetbrains/plugins/terminal/block/session/CommandFinishedEvent;", "sendCodeToReportBuffer", "intellij.terminal"})
public final class ShellEditorBufferReportShellCommandListener
implements ShellCommandListener {
    @NotNull
    private final BlockTerminalSession blockTerminalSession;
    @NotNull
    private final TerminalPromptModel model;
    @NotNull
    private final EditorEx editor;

    public ShellEditorBufferReportShellCommandListener(@NotNull BlockTerminalSession blockTerminalSession, @NotNull TerminalPromptModel model, @NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)blockTerminalSession, (String)"blockTerminalSession");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.blockTerminalSession = blockTerminalSession;
        this.model = model;
        this.editor = editor;
    }

    @Override
    public void commandBufferReceived(@NotNull String buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        TerminalUiUtilsKt.invokeLater$default(null, null, () -> ShellEditorBufferReportShellCommandListener.commandBufferReceived$lambda$0(this, buffer), 3, null);
    }

    @Override
    public void initialized() {
        this.sendCodeToReportBuffer(this.blockTerminalSession);
    }

    @Override
    public void commandFinished(@NotNull CommandFinishedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.sendCodeToReportBuffer(this.blockTerminalSession);
    }

    private final void sendCodeToReportBuffer(BlockTerminalSession blockTerminalSession) {
        ShellType[] shellTypeArray = new ShellType[]{ShellType.ZSH, ShellType.BASH};
        if (!SetsKt.setOf((Object[])shellTypeArray).contains((Object)blockTerminalSession.getShellIntegration().getShellType())) {
            return;
        }
        byte[] byArray = new byte[]{27};
        byte[] escapeSymbol = byArray;
        String string = "o";
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray2 = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        byte[] iSymbol = byArray2;
        blockTerminalSession.getCommandExecutionManager$intellij_terminal().sendKeyBinding(new KeyBinding(ArraysKt.plus((byte[])escapeSymbol, (byte[])iSymbol)));
    }

    private static final void commandBufferReceived$lambda$0(ShellEditorBufferReportShellCommandListener this$0, String $buffer) {
        this$0.model.setCommandText($buffer);
        this$0.editor.getCaretModel().moveToOffset(this$0.editor.getDocument().getTextLength());
    }
}

