/*-
 * Copyright (c) 2010 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Yorick Hardy
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _TI3410_UTICOM_H_
#define _TI3410_UTICOM_H_

/* Used to test driver/firmware compatibility */

#define TI3410_FIRMWARE_VERSION_MAJOR	1
#define TI3410_FIRMWARE_VERSION_MINOR	0

/* Configurations */

#define TI3410_BOOT_CONFIGURATION	0
#define TI3410_BOOT_INTERFACE		0
#define TI3410_ACTIVE_CONFIGURATION	1
#define TI3410_ACTIVE_INTERFACE		0

/* Endpoints */

#define TI3410_BOOT_FWUPLOAD_ENDPOINT		0x01
#define TI3410_BOOT_BULK_ENDPOINT		0x01
#define TI3410_ACTIVE_BULK_OUT_ENDPOINT		0x01
#define TI3410_ACTIVE_BULK_IN_ENDPOINT		0x81
#define TI3410_ACTIVE_INTERRUPT_ENDPOINT	0x02

/* Requests */

/* in each case wIndex should be set to TI3410_ACTIVE_INTERFACE */
#define TI3410_RQ_SET_DTR		0x01  /* wValue -> zero / non-zero  */
#define TI3410_RQ_SET_RTS		0x02  /* wValue -> zero / non-zero  */
#define TI3410_RQ_SET_BREAK		0x03  /* wValue -> zero / non-zero  */
#define TI3410_RQ_SET_CRTSCTS		0x04  /* wValue -> zero / non-zero  */
#define TI3410_RQ_SET_DLLDLH		0x05  /* DLL=wValueLo, DLH=wValueHi */
#define TI3410_RQ_SET_DATABITS		0x06  /* wValue -> number of bits   */
#define TI3410_RQ_SET_STOPBITS		0x07  /* wValue -> zero / non-zero  */
#define TI3410_RQ_SET_PARITY		0x08  /* wValue -> zero / non-zero  */
#define TI3410_RQ_SET_PARITY_ODD	0x09  /* wValue -> zero / non-zero  */
#define TI3410_RQ_SET_PARAM		0x0A  /* wValueLo -> parameters     */
/* clears bulk endpoint buffers, fifo and sets DTR and RTS low */
#define TI3410_RQ_RESET_BULK		0x0B

/* Bits for TI3410_INTR_LSR from definitions for TI3410_UART_LSR (tusb3410.h) */

#define	TI3410_LSR_OVR		0x01
#define	TI3410_LSR_PTE		0x02
#define	TI3410_LSR_FRE		0x04
#define	TI3410_LSR_BRK		0x08
#define	TI3410_LSR_RxF		0x10
#define	TI3410_LSR_TxE		0x20
#define	TI3410_LSR_TEMT		0x40

/*
 * Bits for TI3410_INTR_MSR, partially from definitions for
 * TI3410_UART_MSR in tusb3410.h 
 * tusb3410.pdf uses CD (carrier detect) and DCD (delta carrier detect)
 * uticom uses DCD (data carrier detect) and DDCD (delta data carrier detect)
 */

#define	TI3410_MSR_DCTS		0x01
#define	TI3410_MSR_DDSR		0x02
#define	TI3410_MSR_TRI		0x04
#define	TI3410_MSR_DDCD		0x08	/* DCD in TI3410_UART_MSR */
#define	TI3410_MSR_CTS		0x10
#define	TI3410_MSR_DSR		0x20
#define	TI3410_MSR_RI		0x40
#define	TI3410_MSR_DCD		0x80	/* LCD in TI3410_UART_MSR */

/* Bits for PARAM, from definitions for TI3410_UART_LCR in tusb3410.h */

/* low byte */
#define	TI3410_PARAM_DATABITS_5		0x00
#define	TI3410_PARAM_DATABITS_6		0x01
#define	TI3410_PARAM_DATABITS_7		0x02
#define	TI3410_PARAM_DATABITS_8		0x03
#define	TI3410_PARAM_STOPBITS_1		0x00
#define	TI3410_PARAM_STOPBITS_2		0x04
#define	TI3410_PARAM_PARITY_ENABLE	0x08
#define	TI3410_PARAM_PARITY_ODD		0x00
#define	TI3410_PARAM_PARITY_EVEN	0x10
#define	TI3410_PARAM_PARITY_FORCE	0x20	/* force parity bit to 1 */
#define	TI3410_PARAM_SET_BREAK		0x40
#define	TI3410_PARAM_FIFO		0x80
/* high byte */
#define	TI3410_PARAM_CRTSCTS		0x01
#define	TI3410_PARAM_CDTRCTS		0x02

/*
 * Interrupts currently consist of 3 bytes:
 *   byte 0: type
 *   byte 1: number of interrupts dropped before this one
 *   byte 2: interrupt information
 * Interrupt type VEC generates excessive amounts of information
 * and should generally only be enabled for debugging (in interrupts.c)
 */

/* Interrupt type */

#define TI3410_INTR_VEC		0x00	/* contents of VECINT */
#define TI3410_INTR_LSR		0x01	/* contents of LSR */
#define TI3410_INTR_MSR		0x02	/* contents of MSR */
#define TI3410_INTR_DMA1	0x03	/* DMA1 stopped: contents of CSR1 */
#define TI3410_INTR_DMA3	0x04	/* DMA3 stopped: contents of CSR3 */
#define TI3410_INTR_OVERRUN	0x05	/* Read buffer overrun: no info */

#endif /* _TI3410_UTICOM_H_ */
